/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import java.util.List;

public class ModelValidationException
extends IllegalStateException {
    private final Object modelObject;
    private final List<Failure> failures;

    public ModelValidationException(String message, Object modelObject, List<Failure> failures) {
        super(ModelValidationException.buildMessage(message, failures));
        this.modelObject = modelObject;
        this.failures = failures;
    }

    private static String buildMessage(String message, List<Failure> failures) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        for (Failure failure : failures) {
            sb.append("\n");
            sb.append(failure.getFieldName());
            sb.append(' ');
            sb.append(failure.getMessage());
            if (failure.getObject() == null) continue;
            sb.append(": ");
            sb.append("\"");
            sb.append(failure.getObject().toString());
            sb.append("\"");
        }
        return sb.toString();
    }

    public Object getModelObject() {
        return this.modelObject;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public static class Failure {
        private final String fieldName;
        private final Object object;
        private final String message;

        public Failure(String fieldName, Object object, String message) {
            this.fieldName = fieldName;
            this.object = object;
            this.message = message;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getObject() {
            return this.object;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

