/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.repository.WorkflowDefinitionList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableWorkflowDefinitionList
extends WorkflowDefinitionList {
    private final ImmutableList<WorkflowDefinition> get;

    private ImmutableWorkflowDefinitionList(ImmutableList<WorkflowDefinition> get) {
        this.get = get;
    }

    public ImmutableList<WorkflowDefinition> get() {
        return this.get;
    }

    public final ImmutableWorkflowDefinitionList withGet(WorkflowDefinition ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableWorkflowDefinitionList((ImmutableList<WorkflowDefinition>)newValue);
    }

    public final ImmutableWorkflowDefinitionList withGet(Iterable<? extends WorkflowDefinition> elements) {
        if (this.get == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableWorkflowDefinitionList((ImmutableList<WorkflowDefinition>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowDefinitionList && this.equalTo((ImmutableWorkflowDefinitionList)another);
    }

    private boolean equalTo(ImmutableWorkflowDefinitionList another) {
        return this.get.equals(another.get);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.get.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WorkflowDefinitionList").omitNullValues().add("get", this.get).toString();
    }

    public static ImmutableWorkflowDefinitionList copyOf(WorkflowDefinitionList instance) {
        if (instance instanceof ImmutableWorkflowDefinitionList) {
            return (ImmutableWorkflowDefinitionList)instance;
        }
        return ImmutableWorkflowDefinitionList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<WorkflowDefinition> get = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WorkflowDefinitionList instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllGet(instance.get());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGet(WorkflowDefinition element) {
            this.get.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGet(WorkflowDefinition ... elements) {
            this.get.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder get(Iterable<? extends WorkflowDefinition> elements) {
            this.get = ImmutableList.builder();
            return this.addAllGet(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGet(Iterable<? extends WorkflowDefinition> elements) {
            this.get.addAll(elements);
            return this;
        }

        public ImmutableWorkflowDefinitionList build() {
            return new ImmutableWorkflowDefinitionList(this.get.build());
        }
    }
}

