/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.repository.WorkflowDefinitionImpl;
import java.time.ZoneId;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableWorkflowDefinition
extends WorkflowDefinitionImpl {
    private final String name;
    private final Config config;
    private final ZoneId timeZone;

    private ImmutableWorkflowDefinition(String name, Config config, ZoneId timeZone) {
        this.name = name;
        this.config = config;
        this.timeZone = timeZone;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="timeZone")
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public final ImmutableWorkflowDefinition withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return ImmutableWorkflowDefinition.validate(new ImmutableWorkflowDefinition(newValue, this.config, this.timeZone));
    }

    public final ImmutableWorkflowDefinition withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return ImmutableWorkflowDefinition.validate(new ImmutableWorkflowDefinition(this.name, newValue, this.timeZone));
    }

    public final ImmutableWorkflowDefinition withTimeZone(ZoneId value) {
        if (this.timeZone == value) {
            return this;
        }
        ZoneId newValue = (ZoneId)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return ImmutableWorkflowDefinition.validate(new ImmutableWorkflowDefinition(this.name, this.config, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowDefinition && this.equalTo((ImmutableWorkflowDefinition)another);
    }

    private boolean equalTo(ImmutableWorkflowDefinition another) {
        return this.name.equals(another.name) && this.config.equals((Object)another.config) && this.timeZone.equals(another.timeZone);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WorkflowDefinition").omitNullValues().add("name", (Object)this.name).add("config", (Object)this.config).add("timeZone", (Object)this.timeZone).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWorkflowDefinition fromJson(Json json) {
        Builder builder = ImmutableWorkflowDefinition.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        return builder.build();
    }

    private static ImmutableWorkflowDefinition validate(ImmutableWorkflowDefinition instance) {
        instance.check();
        return instance;
    }

    public static ImmutableWorkflowDefinition copyOf(WorkflowDefinitionImpl instance) {
        if (instance instanceof ImmutableWorkflowDefinition) {
            return (ImmutableWorkflowDefinition)instance;
        }
        return ImmutableWorkflowDefinition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_CONFIG = 2L;
        private static final long INIT_BIT_TIME_ZONE = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private Config config;
        @Nullable
        private ZoneId timeZone;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WorkflowDefinition instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(WorkflowDefinitionImpl instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof WorkflowDefinition) {
                WorkflowDefinition instance = (WorkflowDefinition)object;
                this.name(instance.getName());
                this.timeZone(instance.getTimeZone());
                this.config(instance.getConfig());
            }
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="timeZone")
        @CanIgnoreReturnValue
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableWorkflowDefinition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableWorkflowDefinition.validate(new ImmutableWorkflowDefinition(this.name, this.config, this.timeZone));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("timeZone");
            }
            return "Cannot build WorkflowDefinition, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends WorkflowDefinitionImpl {
        @Nullable
        String name;
        @Nullable
        Config config;
        @Nullable
        ZoneId timeZone;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @JsonProperty(value="timeZone")
        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }
    }
}

