/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.StoredWorkflowDefinitionWithProject;
import io.digdag.core.repository.WorkflowDefinition;
import java.time.ZoneId;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredWorkflowDefinitionWithProject
extends StoredWorkflowDefinitionWithProject {
    private final StoredProject project;
    private final Config revisionDefaultParams;
    private final String revisionName;
    private final long id;
    private final int revisionId;
    private final String name;
    private final Config config;
    private final ZoneId timeZone;

    private ImmutableStoredWorkflowDefinitionWithProject(StoredProject project, Config revisionDefaultParams, String revisionName, long id, int revisionId, String name, Config config, ZoneId timeZone) {
        this.project = project;
        this.revisionDefaultParams = revisionDefaultParams;
        this.revisionName = revisionName;
        this.id = id;
        this.revisionId = revisionId;
        this.name = name;
        this.config = config;
        this.timeZone = timeZone;
    }

    @Override
    @JsonProperty(value="project")
    public StoredProject getProject() {
        return this.project;
    }

    @Override
    @JsonProperty(value="revisionDefaultParams")
    public Config getRevisionDefaultParams() {
        return this.revisionDefaultParams;
    }

    @Override
    @JsonProperty(value="revisionName")
    public String getRevisionName() {
        return this.revisionName;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="revisionId")
    public int getRevisionId() {
        return this.revisionId;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="timeZone")
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public final ImmutableStoredWorkflowDefinitionWithProject withProject(StoredProject value) {
        if (this.project == value) {
            return this;
        }
        StoredProject newValue = (StoredProject)Preconditions.checkNotNull((Object)value, (Object)"project");
        return ImmutableStoredWorkflowDefinitionWithProject.validate(new ImmutableStoredWorkflowDefinitionWithProject(newValue, this.revisionDefaultParams, this.revisionName, this.id, this.revisionId, this.name, this.config, this.timeZone));
    }

    public final ImmutableStoredWorkflowDefinitionWithProject withRevisionDefaultParams(Config value) {
        if (this.revisionDefaultParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"revisionDefaultParams");
        return ImmutableStoredWorkflowDefinitionWithProject.validate(new ImmutableStoredWorkflowDefinitionWithProject(this.project, newValue, this.revisionName, this.id, this.revisionId, this.name, this.config, this.timeZone));
    }

    public final ImmutableStoredWorkflowDefinitionWithProject withRevisionName(String value) {
        if (this.revisionName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"revisionName");
        return ImmutableStoredWorkflowDefinitionWithProject.validate(new ImmutableStoredWorkflowDefinitionWithProject(this.project, this.revisionDefaultParams, newValue, this.id, this.revisionId, this.name, this.config, this.timeZone));
    }

    public final ImmutableStoredWorkflowDefinitionWithProject withId(long value) {
        if (this.id == value) {
            return this;
        }
        return ImmutableStoredWorkflowDefinitionWithProject.validate(new ImmutableStoredWorkflowDefinitionWithProject(this.project, this.revisionDefaultParams, this.revisionName, value, this.revisionId, this.name, this.config, this.timeZone));
    }

    public final ImmutableStoredWorkflowDefinitionWithProject withRevisionId(int value) {
        if (this.revisionId == value) {
            return this;
        }
        return ImmutableStoredWorkflowDefinitionWithProject.validate(new ImmutableStoredWorkflowDefinitionWithProject(this.project, this.revisionDefaultParams, this.revisionName, this.id, value, this.name, this.config, this.timeZone));
    }

    public final ImmutableStoredWorkflowDefinitionWithProject withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return ImmutableStoredWorkflowDefinitionWithProject.validate(new ImmutableStoredWorkflowDefinitionWithProject(this.project, this.revisionDefaultParams, this.revisionName, this.id, this.revisionId, newValue, this.config, this.timeZone));
    }

    public final ImmutableStoredWorkflowDefinitionWithProject withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return ImmutableStoredWorkflowDefinitionWithProject.validate(new ImmutableStoredWorkflowDefinitionWithProject(this.project, this.revisionDefaultParams, this.revisionName, this.id, this.revisionId, this.name, newValue, this.timeZone));
    }

    public final ImmutableStoredWorkflowDefinitionWithProject withTimeZone(ZoneId value) {
        if (this.timeZone == value) {
            return this;
        }
        ZoneId newValue = (ZoneId)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return ImmutableStoredWorkflowDefinitionWithProject.validate(new ImmutableStoredWorkflowDefinitionWithProject(this.project, this.revisionDefaultParams, this.revisionName, this.id, this.revisionId, this.name, this.config, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredWorkflowDefinitionWithProject && this.equalTo((ImmutableStoredWorkflowDefinitionWithProject)another);
    }

    private boolean equalTo(ImmutableStoredWorkflowDefinitionWithProject another) {
        return this.project.equals(another.project) && this.revisionDefaultParams.equals((Object)another.revisionDefaultParams) && this.revisionName.equals(another.revisionName) && this.id == another.id && this.revisionId == another.revisionId && this.name.equals(another.name) && this.config.equals((Object)another.config) && this.timeZone.equals(another.timeZone);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.project.hashCode();
        h = h * 17 + this.revisionDefaultParams.hashCode();
        h = h * 17 + this.revisionName.hashCode();
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + this.revisionId;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredWorkflowDefinitionWithProject").omitNullValues().add("project", (Object)this.project).add("revisionDefaultParams", (Object)this.revisionDefaultParams).add("revisionName", (Object)this.revisionName).add("id", this.id).add("revisionId", this.revisionId).add("name", (Object)this.name).add("config", (Object)this.config).add("timeZone", (Object)this.timeZone).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredWorkflowDefinitionWithProject fromJson(Json json) {
        Builder builder = ImmutableStoredWorkflowDefinitionWithProject.builder();
        if (json.project != null) {
            builder.project(json.project);
        }
        if (json.revisionDefaultParams != null) {
            builder.revisionDefaultParams(json.revisionDefaultParams);
        }
        if (json.revisionName != null) {
            builder.revisionName(json.revisionName);
        }
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.revisionIdIsSet) {
            builder.revisionId(json.revisionId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        return builder.build();
    }

    private static ImmutableStoredWorkflowDefinitionWithProject validate(ImmutableStoredWorkflowDefinitionWithProject instance) {
        instance.check();
        return instance;
    }

    public static ImmutableStoredWorkflowDefinitionWithProject copyOf(StoredWorkflowDefinitionWithProject instance) {
        if (instance instanceof ImmutableStoredWorkflowDefinitionWithProject) {
            return (ImmutableStoredWorkflowDefinitionWithProject)instance;
        }
        return ImmutableStoredWorkflowDefinitionWithProject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROJECT = 1L;
        private static final long INIT_BIT_REVISION_DEFAULT_PARAMS = 2L;
        private static final long INIT_BIT_REVISION_NAME = 4L;
        private static final long INIT_BIT_ID = 8L;
        private static final long INIT_BIT_REVISION_ID = 16L;
        private static final long INIT_BIT_NAME = 32L;
        private static final long INIT_BIT_CONFIG = 64L;
        private static final long INIT_BIT_TIME_ZONE = 128L;
        private long initBits = 255L;
        @Nullable
        private StoredProject project;
        @Nullable
        private Config revisionDefaultParams;
        @Nullable
        private String revisionName;
        private long id;
        private int revisionId;
        @Nullable
        private String name;
        @Nullable
        private Config config;
        @Nullable
        private ZoneId timeZone;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WorkflowDefinition instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredWorkflowDefinition instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredWorkflowDefinitionWithProject instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WorkflowDefinition instance;
            if (object instanceof WorkflowDefinition) {
                instance = (WorkflowDefinition)object;
                this.name(instance.getName());
                this.timeZone(instance.getTimeZone());
                this.config(instance.getConfig());
            }
            if (object instanceof StoredWorkflowDefinition) {
                instance = (StoredWorkflowDefinition)object;
                this.revisionId(((StoredWorkflowDefinition)instance).getRevisionId());
                this.id(((StoredWorkflowDefinition)instance).getId());
            }
            if (object instanceof StoredWorkflowDefinitionWithProject) {
                instance = (StoredWorkflowDefinitionWithProject)object;
                this.project(((StoredWorkflowDefinitionWithProject)instance).getProject());
                this.revisionName(((StoredWorkflowDefinitionWithProject)instance).getRevisionName());
                this.revisionDefaultParams(((StoredWorkflowDefinitionWithProject)instance).getRevisionDefaultParams());
            }
        }

        @JsonProperty(value="project")
        @CanIgnoreReturnValue
        public final Builder project(StoredProject project) {
            this.project = (StoredProject)Preconditions.checkNotNull((Object)project, (Object)"project");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="revisionDefaultParams")
        @CanIgnoreReturnValue
        public final Builder revisionDefaultParams(Config revisionDefaultParams) {
            this.revisionDefaultParams = (Config)Preconditions.checkNotNull((Object)revisionDefaultParams, (Object)"revisionDefaultParams");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="revisionName")
        @CanIgnoreReturnValue
        public final Builder revisionName(String revisionName) {
            this.revisionName = (String)Preconditions.checkNotNull((Object)revisionName, (Object)"revisionName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="revisionId")
        @CanIgnoreReturnValue
        public final Builder revisionId(int revisionId) {
            this.revisionId = revisionId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="timeZone")
        @CanIgnoreReturnValue
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableStoredWorkflowDefinitionWithProject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableStoredWorkflowDefinitionWithProject.validate(new ImmutableStoredWorkflowDefinitionWithProject(this.project, this.revisionDefaultParams, this.revisionName, this.id, this.revisionId, this.name, this.config, this.timeZone));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("project");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("revisionDefaultParams");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("revisionName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("revisionId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("timeZone");
            }
            return "Cannot build StoredWorkflowDefinitionWithProject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredWorkflowDefinitionWithProject {
        @Nullable
        StoredProject project;
        @Nullable
        Config revisionDefaultParams;
        @Nullable
        String revisionName;
        long id;
        boolean idIsSet;
        int revisionId;
        boolean revisionIdIsSet;
        @Nullable
        String name;
        @Nullable
        Config config;
        @Nullable
        ZoneId timeZone;

        Json() {
        }

        @JsonProperty(value="project")
        public void setProject(StoredProject project) {
            this.project = project;
        }

        @JsonProperty(value="revisionDefaultParams")
        public void setRevisionDefaultParams(Config revisionDefaultParams) {
            this.revisionDefaultParams = revisionDefaultParams;
        }

        @JsonProperty(value="revisionName")
        public void setRevisionName(String revisionName) {
            this.revisionName = revisionName;
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="revisionId")
        public void setRevisionId(int revisionId) {
            this.revisionId = revisionId;
            this.revisionIdIsSet = true;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @JsonProperty(value="timeZone")
        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public StoredProject getProject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getRevisionDefaultParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevisionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRevisionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }
    }
}

