/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.repository.ArchiveType;
import io.digdag.core.repository.Project;
import io.digdag.core.repository.StoredProjectWithRevision;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredProjectWithRevision
extends StoredProjectWithRevision {
    private final int id;
    private final int siteId;
    private final Instant createdAt;
    private final Optional<Instant> deletedAt;
    private final String revisionName;
    private final Instant revisionCreatedAt;
    private final ArchiveType revisionArchiveType;
    private final Optional<byte[]> revisionArchiveMd5;
    private final String name;

    private ImmutableStoredProjectWithRevision(int id, int siteId, Instant createdAt, Optional<Instant> deletedAt, String revisionName, Instant revisionCreatedAt, ArchiveType revisionArchiveType, Optional<byte[]> revisionArchiveMd5, String name) {
        this.id = id;
        this.siteId = siteId;
        this.createdAt = createdAt;
        this.deletedAt = deletedAt;
        this.revisionName = revisionName;
        this.revisionCreatedAt = revisionCreatedAt;
        this.revisionArchiveType = revisionArchiveType;
        this.revisionArchiveMd5 = revisionArchiveMd5;
        this.name = name;
    }

    @Override
    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="siteId")
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="deletedAt")
    public Optional<Instant> getDeletedAt() {
        return this.deletedAt;
    }

    @Override
    @JsonProperty(value="revisionName")
    public String getRevisionName() {
        return this.revisionName;
    }

    @Override
    @JsonProperty(value="revisionCreatedAt")
    public Instant getRevisionCreatedAt() {
        return this.revisionCreatedAt;
    }

    @Override
    @JsonProperty(value="revisionArchiveType")
    public ArchiveType getRevisionArchiveType() {
        return this.revisionArchiveType;
    }

    @Override
    @JsonProperty(value="revisionArchiveMd5")
    public Optional<byte[]> getRevisionArchiveMd5() {
        return this.revisionArchiveMd5;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public final ImmutableStoredProjectWithRevision withId(int value) {
        if (this.id == value) {
            return this;
        }
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(value, this.siteId, this.createdAt, this.deletedAt, this.revisionName, this.revisionCreatedAt, this.revisionArchiveType, this.revisionArchiveMd5, this.name));
    }

    public final ImmutableStoredProjectWithRevision withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, value, this.createdAt, this.deletedAt, this.revisionName, this.revisionCreatedAt, this.revisionArchiveType, this.revisionArchiveMd5, this.name));
    }

    public final ImmutableStoredProjectWithRevision withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, newValue, this.deletedAt, this.revisionName, this.revisionCreatedAt, this.revisionArchiveType, this.revisionArchiveMd5, this.name));
    }

    public final ImmutableStoredProjectWithRevision withDeletedAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.deletedAt.isPresent() && this.deletedAt.get() == value) {
            return this;
        }
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, this.createdAt, (Optional<Instant>)newValue, this.revisionName, this.revisionCreatedAt, this.revisionArchiveType, this.revisionArchiveMd5, this.name));
    }

    public final ImmutableStoredProjectWithRevision withDeletedAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"deletedAt");
        if (!this.deletedAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.deletedAt.isPresent() && value.isPresent() && this.deletedAt.get() == value.get()) {
            return this;
        }
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, this.createdAt, (Optional<Instant>)value, this.revisionName, this.revisionCreatedAt, this.revisionArchiveType, this.revisionArchiveMd5, this.name));
    }

    public final ImmutableStoredProjectWithRevision withRevisionName(String value) {
        if (this.revisionName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"revisionName");
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, this.createdAt, this.deletedAt, newValue, this.revisionCreatedAt, this.revisionArchiveType, this.revisionArchiveMd5, this.name));
    }

    public final ImmutableStoredProjectWithRevision withRevisionCreatedAt(Instant value) {
        if (this.revisionCreatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"revisionCreatedAt");
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, this.createdAt, this.deletedAt, this.revisionName, newValue, this.revisionArchiveType, this.revisionArchiveMd5, this.name));
    }

    public final ImmutableStoredProjectWithRevision withRevisionArchiveType(ArchiveType value) {
        if (this.revisionArchiveType == value) {
            return this;
        }
        ArchiveType newValue = (ArchiveType)Preconditions.checkNotNull((Object)value, (Object)"revisionArchiveType");
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, this.createdAt, this.deletedAt, this.revisionName, this.revisionCreatedAt, newValue, this.revisionArchiveMd5, this.name));
    }

    public final ImmutableStoredProjectWithRevision withRevisionArchiveMd5(byte[] value) {
        Optional newValue = Optional.of((Object)value);
        if (this.revisionArchiveMd5.isPresent() && this.revisionArchiveMd5.get() == value) {
            return this;
        }
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, this.createdAt, this.deletedAt, this.revisionName, this.revisionCreatedAt, this.revisionArchiveType, (Optional<byte[]>)newValue, this.name));
    }

    public final ImmutableStoredProjectWithRevision withRevisionArchiveMd5(Optional<byte[]> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"revisionArchiveMd5");
        if (!this.revisionArchiveMd5.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.revisionArchiveMd5.isPresent() && value.isPresent() && this.revisionArchiveMd5.get() == value.get()) {
            return this;
        }
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, this.createdAt, this.deletedAt, this.revisionName, this.revisionCreatedAt, this.revisionArchiveType, (Optional<byte[]>)value, this.name));
    }

    public final ImmutableStoredProjectWithRevision withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, this.createdAt, this.deletedAt, this.revisionName, this.revisionCreatedAt, this.revisionArchiveType, this.revisionArchiveMd5, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredProjectWithRevision && this.equalTo((ImmutableStoredProjectWithRevision)another);
    }

    private boolean equalTo(ImmutableStoredProjectWithRevision another) {
        return this.id == another.id && this.siteId == another.siteId && this.createdAt.equals(another.createdAt) && this.deletedAt.equals(another.deletedAt) && this.revisionName.equals(another.revisionName) && this.revisionCreatedAt.equals(another.revisionCreatedAt) && this.revisionArchiveType.equals(another.revisionArchiveType) && this.revisionArchiveMd5.equals(another.revisionArchiveMd5) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id;
        h = h * 17 + this.siteId;
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.deletedAt.hashCode();
        h = h * 17 + this.revisionName.hashCode();
        h = h * 17 + this.revisionCreatedAt.hashCode();
        h = h * 17 + this.revisionArchiveType.hashCode();
        h = h * 17 + this.revisionArchiveMd5.hashCode();
        h = h * 17 + this.name.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredProjectWithRevision").omitNullValues().add("id", this.id).add("siteId", this.siteId).add("createdAt", (Object)this.createdAt).add("deletedAt", this.deletedAt.orNull()).add("revisionName", (Object)this.revisionName).add("revisionCreatedAt", (Object)this.revisionCreatedAt).add("revisionArchiveType", (Object)this.revisionArchiveType).add("revisionArchiveMd5", this.revisionArchiveMd5.orNull()).add("name", (Object)this.name).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredProjectWithRevision fromJson(Json json) {
        Builder builder = ImmutableStoredProjectWithRevision.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.siteIdIsSet) {
            builder.siteId(json.siteId);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.deletedAt != null) {
            builder.deletedAt(json.deletedAt);
        }
        if (json.revisionName != null) {
            builder.revisionName(json.revisionName);
        }
        if (json.revisionCreatedAt != null) {
            builder.revisionCreatedAt(json.revisionCreatedAt);
        }
        if (json.revisionArchiveType != null) {
            builder.revisionArchiveType(json.revisionArchiveType);
        }
        if (json.revisionArchiveMd5 != null) {
            builder.revisionArchiveMd5(json.revisionArchiveMd5);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    private static ImmutableStoredProjectWithRevision validate(ImmutableStoredProjectWithRevision instance) {
        instance.check();
        return instance;
    }

    public static ImmutableStoredProjectWithRevision copyOf(StoredProjectWithRevision instance) {
        if (instance instanceof ImmutableStoredProjectWithRevision) {
            return (ImmutableStoredProjectWithRevision)instance;
        }
        return ImmutableStoredProjectWithRevision.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SITE_ID = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_REVISION_NAME = 8L;
        private static final long INIT_BIT_REVISION_CREATED_AT = 16L;
        private static final long INIT_BIT_REVISION_ARCHIVE_TYPE = 32L;
        private static final long INIT_BIT_NAME = 64L;
        private long initBits = 127L;
        private int id;
        private int siteId;
        @Nullable
        private Instant createdAt;
        private Optional<Instant> deletedAt = Optional.absent();
        @Nullable
        private String revisionName;
        @Nullable
        private Instant revisionCreatedAt;
        @Nullable
        private ArchiveType revisionArchiveType;
        private Optional<byte[]> revisionArchiveMd5 = Optional.absent();
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredProjectWithRevision instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Project instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Project instance;
            if (object instanceof StoredProjectWithRevision) {
                instance = (StoredProjectWithRevision)object;
                Optional<byte[]> revisionArchiveMd5Optional = ((StoredProjectWithRevision)instance).getRevisionArchiveMd5();
                if (revisionArchiveMd5Optional.isPresent()) {
                    this.revisionArchiveMd5(revisionArchiveMd5Optional);
                }
                this.createdAt(((StoredProjectWithRevision)instance).getCreatedAt());
                Optional<Instant> deletedAtOptional = ((StoredProjectWithRevision)instance).getDeletedAt();
                if (deletedAtOptional.isPresent()) {
                    this.deletedAt(deletedAtOptional);
                }
                this.revisionName(((StoredProjectWithRevision)instance).getRevisionName());
                this.revisionArchiveType(((StoredProjectWithRevision)instance).getRevisionArchiveType());
                this.siteId(((StoredProjectWithRevision)instance).getSiteId());
                this.revisionCreatedAt(((StoredProjectWithRevision)instance).getRevisionCreatedAt());
                this.id(((StoredProjectWithRevision)instance).getId());
            }
            if (object instanceof Project) {
                instance = (Project)object;
                this.name(instance.getName());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="siteId")
        @CanIgnoreReturnValue
        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = Optional.of((Object)deletedAt);
            return this;
        }

        @JsonProperty(value="deletedAt")
        @CanIgnoreReturnValue
        public final Builder deletedAt(Optional<Instant> deletedAt) {
            this.deletedAt = (Optional)Preconditions.checkNotNull(deletedAt, (Object)"deletedAt");
            return this;
        }

        @JsonProperty(value="revisionName")
        @CanIgnoreReturnValue
        public final Builder revisionName(String revisionName) {
            this.revisionName = (String)Preconditions.checkNotNull((Object)revisionName, (Object)"revisionName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="revisionCreatedAt")
        @CanIgnoreReturnValue
        public final Builder revisionCreatedAt(Instant revisionCreatedAt) {
            this.revisionCreatedAt = (Instant)Preconditions.checkNotNull((Object)revisionCreatedAt, (Object)"revisionCreatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="revisionArchiveType")
        @CanIgnoreReturnValue
        public final Builder revisionArchiveType(ArchiveType revisionArchiveType) {
            this.revisionArchiveType = (ArchiveType)Preconditions.checkNotNull((Object)revisionArchiveType, (Object)"revisionArchiveType");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder revisionArchiveMd5(byte[] revisionArchiveMd5) {
            this.revisionArchiveMd5 = Optional.of((Object)revisionArchiveMd5);
            return this;
        }

        @JsonProperty(value="revisionArchiveMd5")
        @CanIgnoreReturnValue
        public final Builder revisionArchiveMd5(Optional<byte[]> revisionArchiveMd5) {
            this.revisionArchiveMd5 = (Optional)Preconditions.checkNotNull(revisionArchiveMd5, (Object)"revisionArchiveMd5");
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableStoredProjectWithRevision build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableStoredProjectWithRevision.validate(new ImmutableStoredProjectWithRevision(this.id, this.siteId, this.createdAt, this.deletedAt, this.revisionName, this.revisionCreatedAt, this.revisionArchiveType, this.revisionArchiveMd5, this.name));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("revisionName");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("revisionCreatedAt");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("revisionArchiveType");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build StoredProjectWithRevision, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredProjectWithRevision {
        int id;
        boolean idIsSet;
        int siteId;
        boolean siteIdIsSet;
        @Nullable
        Instant createdAt;
        Optional<Instant> deletedAt = Optional.absent();
        @Nullable
        String revisionName;
        @Nullable
        Instant revisionCreatedAt;
        @Nullable
        ArchiveType revisionArchiveType;
        Optional<byte[]> revisionArchiveMd5 = Optional.absent();
        @Nullable
        String name;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(int id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="siteId")
        public void setSiteId(int siteId) {
            this.siteId = siteId;
            this.siteIdIsSet = true;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="deletedAt")
        public void setDeletedAt(Optional<Instant> deletedAt) {
            this.deletedAt = deletedAt;
        }

        @JsonProperty(value="revisionName")
        public void setRevisionName(String revisionName) {
            this.revisionName = revisionName;
        }

        @JsonProperty(value="revisionCreatedAt")
        public void setRevisionCreatedAt(Instant revisionCreatedAt) {
            this.revisionCreatedAt = revisionCreatedAt;
        }

        @JsonProperty(value="revisionArchiveType")
        public void setRevisionArchiveType(ArchiveType revisionArchiveType) {
            this.revisionArchiveType = revisionArchiveType;
        }

        @JsonProperty(value="revisionArchiveMd5")
        public void setRevisionArchiveMd5(Optional<byte[]> revisionArchiveMd5) {
            this.revisionArchiveMd5 = revisionArchiveMd5;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSiteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getDeletedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevisionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getRevisionCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchiveType getRevisionArchiveType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<byte[]> getRevisionArchiveMd5() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }
    }
}

