/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.notification;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.spi.ImmutableNotification;
import io.digdag.spi.Notification;
import io.digdag.spi.NotificationException;
import io.digdag.spi.NotificationSender;
import io.digdag.spi.TemplateEngine;
import io.digdag.spi.TemplateException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailNotificationSender
implements NotificationSender {
    private static final String NOTIFICATION_MAIL_FROM = "notification.mail.from";
    private static final String NOTIFICATION_MAIL_TO = "notification.mail.to";
    private static final String NOTIFICATION_MAIL_CC = "notification.mail.cc";
    private static final String NOTIFICATION_MAIL_BCC = "notification.mail.bcc";
    private static final String NOTIFICATION_MAIL_SUBJECT = "notification.mail.subject";
    private static final String NOTIFICATION_MAIL_SUBJECT_DEFAULT = "Digdag Notification";
    private static final String NOTIFICATION_MAIL_BODY_TEMPLATE_FILE = "notification.mail.body_template_file";
    private static final String NOTIFICATION_MAIL_HTML = "notification.mail.html";
    private static final boolean NOTIFICATION_MAIL_HTML_DEFAULT = false;
    private static final String NOTIFICATION_MAIL_BODY_TEMPLATE_DEFAULT = Joiner.on((char)'\n').join((Object)"Digdag Notification", (Object)"", new Object[]{"Message: ${message}", "Date: ${timestamp}", "", "Site Id: ${site_id}", "Project Name: ${project_name}", "Project Id: ${project_id}", "Workflow Name: ${workflow_name}", "Revision: ${revision}", "Attempt Id: ${attempt_id}", "Session Id: ${session_id}", "Task Name: ${task_name}", "Time Zone: ${timezone}", "Session Uuid: ${session_uuid}", "Session Time: ${session_time}"});
    private final List<String> to;
    private final TemplateEngine templateEngine;
    private final ObjectMapper mapper;
    private final List<String> cc;
    private final List<String> bcc;
    private final String subject;
    private final String bodyTemplate;
    private final Boolean isHtml;
    private final String from;
    private final Config config;

    @Inject
    public MailNotificationSender(Config systemConfig, TemplateEngine templateEngine, ObjectMapper mapper) {
        this.config = systemConfig.deepCopy();
        this.from = (String)systemConfig.get(NOTIFICATION_MAIL_FROM, String.class);
        this.to = this.addressList(this.config, NOTIFICATION_MAIL_TO);
        this.templateEngine = templateEngine;
        this.mapper = mapper;
        this.config.setIfNotSet(NOTIFICATION_MAIL_CC, (Object)"");
        this.cc = this.addressList(this.config, NOTIFICATION_MAIL_CC);
        this.config.setIfNotSet(NOTIFICATION_MAIL_BCC, (Object)"");
        this.bcc = this.addressList(this.config, NOTIFICATION_MAIL_BCC);
        this.subject = (String)this.config.get(NOTIFICATION_MAIL_SUBJECT, String.class, (Object)NOTIFICATION_MAIL_SUBJECT_DEFAULT);
        this.isHtml = (Boolean)this.config.get(NOTIFICATION_MAIL_HTML, Boolean.TYPE, (Object)false);
        Optional bodyTemplateFile = this.config.getOptional(NOTIFICATION_MAIL_BODY_TEMPLATE_FILE, String.class);
        this.bodyTemplate = (String)bodyTemplateFile.transform(this::readFile).or((Object)NOTIFICATION_MAIL_BODY_TEMPLATE_DEFAULT);
        this.selfCheck();
    }

    private void selfCheck() {
        this.createSession();
        ImmutableNotification notification = Notification.builder((Instant)Instant.now(), (String)"message").siteId(1).projectName("project").projectId(2).workflowName("workflow").revision("revision").attemptId(3L).sessionId(4L).taskName("task").timeZone((ZoneId)ZoneOffset.UTC).sessionUuid(UUID.randomUUID()).sessionTime(OffsetDateTime.now()).workflowDefinitionId(5L).build();
        try {
            this.body((Notification)notification);
        }
        catch (Exception e) {
            throw ThrowablesUtil.propagate((Throwable)e);
        }
    }

    private String readFile(String s) {
        try {
            return new String(Files.readAllBytes(Paths.get(s, new String[0])), "UTF-8");
        }
        catch (IOException e) {
            throw ThrowablesUtil.propagate((Throwable)e);
        }
    }

    private List<String> addressList(Config systemConfig, String key) {
        List toList;
        try {
            toList = systemConfig.getList(key, String.class);
        }
        catch (ConfigException ex) {
            String address = ((String)systemConfig.get(key, String.class)).trim();
            if (address.isEmpty()) {
                return ImmutableList.of();
            }
            toList = ImmutableList.of((Object)address);
        }
        return toList;
    }

    public void sendNotification(Notification notification) throws NotificationException {
        Session session = this.createSession();
        MimeMessage msg = new MimeMessage(session);
        try {
            msg.setFrom((Address)this.newAddress(this.from));
            msg.setSender((Address)this.newAddress(this.from));
            msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])this.addresses(this.to));
            msg.setRecipients(MimeMessage.RecipientType.CC, (Address[])this.addresses(this.cc));
            msg.setRecipients(MimeMessage.RecipientType.BCC, (Address[])this.addresses(this.bcc));
            msg.setSubject(this.subject);
            msg.setText(this.body(notification), "utf-8", this.isHtml != false ? "html" : "plain");
            Transport.send((Message)msg);
        }
        catch (TemplateException | IOException | MessagingException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    private InternetAddress[] addresses(List<String> addresses) {
        return (InternetAddress[])addresses.stream().map(this::newAddress).toArray(InternetAddress[]::new);
    }

    private String body(Notification notification) throws JsonProcessingException, TemplateException {
        String paramsJson = this.mapper.writeValueAsString((Object)notification);
        Config params = this.config.getFactory().fromJsonString(paramsJson);
        return this.templateEngine.template(this.bodyTemplate, params);
    }

    private Session createSession() {
        Session session;
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", (String)this.config.get("notification.mail.host", String.class));
        props.setProperty("mail.smtp.port", (String)this.config.get("notification.mail.port", String.class));
        props.put("mail.smtp.starttls.enable", Boolean.toString((Boolean)this.config.get("notification.mail.tls", Boolean.TYPE, (Object)true)));
        if (((Boolean)this.config.get("notification.mail.ssl", Boolean.TYPE, (Object)false)).booleanValue()) {
            props.put("mail.smtp.socketFactory.port", this.config.get("notification.mail.port", String.class));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        props.setProperty("mail.debug", Boolean.toString((Boolean)this.config.get("notification.mail.debug", Boolean.TYPE, (Object)false)));
        props.setProperty("mail.smtp.connectiontimeout", "10000");
        props.setProperty("mail.smtp.timeout", "60000");
        final String username = (String)this.config.get("notification.mail.username", String.class, null);
        if (username != null) {
            props.setProperty("mail.smtp.auth", "true");
            final String password = (String)this.config.get("notification.mail.password", String.class, (Object)"");
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
        } else {
            session = Session.getInstance((Properties)props);
        }
        return session;
    }

    private InternetAddress newAddress(String address) {
        try {
            return new InternetAddress(address);
        }
        catch (AddressException ex) {
            throw new ConfigException("Invalid address", (Throwable)ex);
        }
    }
}

