/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.notification;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import io.digdag.client.config.Config;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.spi.Notification;
import io.digdag.spi.NotificationException;
import io.digdag.spi.NotificationSender;
import io.digdag.spi.Notifier;
import io.digdag.util.RetryExecutor;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNotifier
implements Notifier {
    private static final String NOTIFICATION_TYPE = "notification.type";
    private static final String NOTIFICATION_RETRIES = "notification.retries";
    private static final String NOTIFICATION_MIN_RETRY_WAIT = "notification.min_retry_wait";
    private static final String NOTIFICATION_MAX_RETRY_WAIT = "notification.max_retry_wait";
    private static final int NOTIFICATION_RETRIES_DEFAULT = 10;
    private static final int NOTIFICATION_MIN_RETRY_WAIT_DEFAULT = 1000;
    private static final int NOTIFICATION_MAX_RETRY_WAIT_DEFAULT = 30000;
    private static Logger logger = LoggerFactory.getLogger(DefaultNotifier.class);
    private Injector injector;
    private final NotificationSender sender;
    private final int retries;
    private final int minRetryWait;
    private final int maxRetryWait;

    @Inject
    public DefaultNotifier(Config systemConfig, Injector injector) {
        this.injector = injector;
        Optional type = systemConfig.getOptional(NOTIFICATION_TYPE, String.class);
        this.sender = type.isPresent() ? this.sender((String)type.get()) : null;
        this.retries = (Integer)systemConfig.get(NOTIFICATION_RETRIES, Integer.TYPE, (Object)10);
        this.minRetryWait = (Integer)systemConfig.get(NOTIFICATION_MIN_RETRY_WAIT, Integer.TYPE, (Object)1000);
        this.maxRetryWait = (Integer)systemConfig.get(NOTIFICATION_MAX_RETRY_WAIT, Integer.TYPE, (Object)30000);
    }

    private NotificationSender sender(String type) {
        return (NotificationSender)this.injector.getInstance(Key.get(NotificationSender.class, (Annotation)Names.named((String)type)));
    }

    public void sendNotification(Notification notification) throws NotificationException {
        logger.debug("Notification: {}", (Object)notification);
        if (this.sender == null) {
            return;
        }
        RetryExecutor retryExecutor = RetryExecutor.retryExecutor().retryIf(exception -> true).withInitialRetryWait(this.minRetryWait).withMaxRetryWait(this.maxRetryWait).onRetry((exception, retryCount, retryLimit, retryWait) -> logger.warn("Sending notification failed: retry {} of {}", new Object[]{retryCount, retryLimit, exception})).withRetryLimit(this.retries);
        try {
            retryExecutor.run(() -> {
                try {
                    this.sender.sendNotification(notification);
                }
                catch (NotificationException e) {
                    throw ThrowablesUtil.propagate((Throwable)e);
                }
            });
        }
        catch (RetryExecutor.RetryGiveupException e) {
            throw new NotificationException("Sending notification failed", (Throwable)e);
        }
    }
}

