/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.log;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.digdag.spi.DirectUploadHandle;
import io.digdag.spi.LogFileHandle;
import io.digdag.spi.LogFilePrefix;
import io.digdag.spi.LogServer;
import io.digdag.spi.LogServerFactory;
import io.digdag.spi.StorageFileNotFoundException;
import java.time.Instant;
import java.util.List;

public class NullLogServerFactory
implements LogServerFactory {
    @Inject
    public NullLogServerFactory() {
    }

    public String getType() {
        return "null";
    }

    public LogServer getLogServer() {
        return new NullLogServer();
    }

    static class NullLogServer
    implements LogServer {
        NullLogServer() {
        }

        public String putFile(LogFilePrefix prefix, String taskName, Instant fileTime, String nodeId, byte[] gzData) {
            return "null";
        }

        public Optional<DirectUploadHandle> getDirectUploadHandle(LogFilePrefix prefix, String taskName, Instant fileTime, String nodeId) {
            return Optional.absent();
        }

        public List<LogFileHandle> getFileHandles(LogFilePrefix prefix, Optional<String> taskName, boolean enableDirectDownload) {
            return ImmutableList.of();
        }

        public byte[] getFile(LogFilePrefix prefix, String fileName) throws StorageFileNotFoundException {
            throw new StorageFileNotFoundException("Log file not found");
        }
    }
}

