/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.log;

import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.agent.AgentId;
import io.digdag.core.log.AbstractFileLogServer;
import io.digdag.core.log.CountingLogOutputStream;
import io.digdag.core.log.LogFiles;
import io.digdag.core.log.LogLevel;
import io.digdag.core.log.TaskLogger;
import io.digdag.spi.DirectUploadHandle;
import io.digdag.spi.LogFilePrefix;
import io.digdag.spi.LogServer;
import io.digdag.spi.LogServerFactory;
import io.digdag.spi.StorageFileNotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LocalFileLogServerFactory
implements LogServerFactory {
    private static final String LOG_GZ_FILE_SUFFIX = ".log.gz";
    private final Path logPath;
    private final long logSplitSize;
    private final AgentId agentId;

    @Inject
    public LocalFileLogServerFactory(Config systemConfig, AgentId agentId) {
        this.logPath = FileSystems.getDefault().getPath((String)systemConfig.get("log-server.local.path", String.class, (Object)"digdag.log"), new String[0]).toAbsolutePath().normalize();
        this.agentId = agentId;
        this.logSplitSize = (Long)systemConfig.get("log-server.local.split_size", Long.class, (Object)0L);
    }

    public String getType() {
        return "local";
    }

    public LogServer getLogServer() {
        try {
            return new LocalFileLogServer(this.logPath);
        }
        catch (IOException ex) {
            throw ThrowablesUtil.propagate((Throwable)ex);
        }
    }

    class LocalFileLogServer
    extends AbstractFileLogServer {
        private final Path logPath;
        private final ReentrantReadWriteLock lock;
        private final ReentrantReadWriteLock.ReadLock logAppendLock;

        public LocalFileLogServer(Path logPath) throws IOException {
            this.logPath = logPath;
            this.lock = new ReentrantReadWriteLock();
            this.logAppendLock = this.lock.readLock();
        }

        @Override
        public Optional<DirectUploadHandle> getDirectUploadHandle(String dateDir, String attemptDir, String fileName) {
            return Optional.absent();
        }

        @Override
        protected void putFile(String dateDir, String attemptDir, String fileName, byte[] gzData) {
            Path dir = this.getPrefixDir(dateDir, attemptDir);
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                Path path = dir.resolve(fileName);
                try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                    out.write(gzData);
                }
            }
            catch (IOException ex) {
                throw ThrowablesUtil.propagate((Throwable)ex);
            }
        }

        @Override
        protected void listFiles(String dateDir, String attemptDir, boolean enableDirectDownload, AbstractFileLogServer.FileMetadataConsumer consumer) {
            Path dir = this.getPrefixDir(dateDir, attemptDir);
            if (!Files.exists(dir, new LinkOption[0])) {
                return;
            }
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
                for (Path path : ds) {
                    consumer.accept(path.getFileName().toString(), Files.size(path), null);
                }
            }
            catch (IOException ex) {
                throw ThrowablesUtil.propagate((Throwable)ex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected byte[] getFile(String dateDir, String attemptDir, String fileName) throws StorageFileNotFoundException {
            Path path = this.getPrefixDir(dateDir, attemptDir).resolve(fileName);
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                byte[] byArray = ByteStreams.toByteArray((InputStream)in);
                return byArray;
            }
            catch (FileNotFoundException ex) {
                throw new StorageFileNotFoundException((Throwable)ex);
            }
            catch (IOException ex) {
                throw ThrowablesUtil.propagate((Throwable)ex);
            }
        }

        private Path getPrefixDir(String dateDir, String attemptDir) {
            return this.logPath.resolve(dateDir).resolve(attemptDir);
        }

        public LocalFileDirectTaskLogger newDirectTaskLogger(LogFilePrefix prefix, String taskName) {
            try {
                return new LocalFileDirectTaskLogger(prefix, taskName, LocalFileLogServerFactory.this.logSplitSize);
            }
            catch (IOException ex) {
                throw ThrowablesUtil.propagate((Throwable)ex);
            }
        }

        class LocalFileDirectTaskLogger
        implements TaskLogger {
            private CountingLogOutputStream output;
            private final long splitSize;
            private final Path dir;
            private final String taskName;

            public LocalFileDirectTaskLogger(LogFilePrefix prefix, String taskName, Long splitSize) throws IOException {
                String dateDir = LogFiles.formatDataDir(prefix);
                String attemptDir = LogFiles.formatSessionAttemptDir(prefix);
                this.dir = LocalFileLogServer.this.getPrefixDir(dateDir, attemptDir);
                this.taskName = taskName;
                this.splitSize = splitSize;
                this.output = this.openNewFile();
            }

            private CountingLogOutputStream openNewFile() throws IOException {
                String fileName = LogFiles.formatFileName(this.taskName, Instant.now(), LocalFileLogServerFactory.this.agentId.toString());
                Files.createDirectories(this.dir, new FileAttribute[0]);
                Path path = this.dir.resolve(fileName);
                return new CountingLogOutputStream(path);
            }

            @Override
            public void log(LogLevel level, long timestamp, String message) {
                byte[] data = message.getBytes(StandardCharsets.UTF_8);
                this.log(data, 0, data.length);
            }

            @Override
            public synchronized void log(byte[] data, int off, int len) {
                try {
                    if (this.output == null) {
                        this.output = this.openNewFile();
                    } else if (this.splitSize > 0L && (long)this.output.getUncompressedSize() > this.splitSize) {
                        this.output.close();
                        this.output = null;
                        this.output = this.openNewFile();
                    }
                    this.output.write(data, off, len);
                }
                catch (IOException ex) {
                    throw ThrowablesUtil.propagate((Throwable)ex);
                }
            }

            @Override
            public synchronized void close() {
                try {
                    this.output.close();
                }
                catch (IOException ex) {
                    throw ThrowablesUtil.propagate((Throwable)ex);
                }
            }
        }
    }
}

