/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.core.database.BasicDatabaseStoreManager;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.IdName;
import io.digdag.core.database.ImmutableWorkflowConfig;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ArchiveType;
import io.digdag.core.repository.ImmutableStoredProject;
import io.digdag.core.repository.ImmutableStoredProjectWithRevision;
import io.digdag.core.repository.ImmutableStoredRevision;
import io.digdag.core.repository.ImmutableStoredWorkflowDefinition;
import io.digdag.core.repository.ImmutableStoredWorkflowDefinitionWithProject;
import io.digdag.core.repository.Project;
import io.digdag.core.repository.ProjectControlStore;
import io.digdag.core.repository.ProjectMap;
import io.digdag.core.repository.ProjectStore;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.Revision;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.repository.StoredProjectWithRevision;
import io.digdag.core.repository.StoredRevision;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.StoredWorkflowDefinitionWithProject;
import io.digdag.core.repository.TimeZoneMap;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.schedule.Schedule;
import io.digdag.core.schedule.ScheduleStatus;
import io.digdag.metrics.DigdagTimed;
import io.digdag.spi.ScheduleTime;
import io.digdag.spi.ac.AccessController;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Define;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class DatabaseProjectStoreManager
extends BasicDatabaseStoreManager<Dao>
implements ProjectStoreManager {
    @Inject
    public DatabaseProjectStoreManager(TransactionManager tm, ConfigMapper cfm, DatabaseConfig config) {
        super(config.getType(), DatabaseProjectStoreManager.dao(config.getType()), tm, cfm);
    }

    private static Class<? extends Dao> dao(String type) {
        switch (type) {
            case "postgresql": {
                return PgDao.class;
            }
            case "h2": {
                return H2Dao.class;
            }
        }
        throw new IllegalArgumentException("Unknown database type: " + type);
    }

    @Override
    public ProjectStore getProjectStore(int siteId) {
        return new DatabaseProjectStore(siteId);
    }

    @Override
    @DigdagTimed(value="dpsm_", category="db", appendMethodName=true)
    public StoredWorkflowDefinitionWithProject getWorkflowDetailsById(long wfId) throws ResourceNotFoundException {
        return this.requiredResource((handle, dao) -> dao.getWorkflowDetailsByIdInternal(wfId), "workflow id=%s", new Object[]{wfId});
    }

    @Override
    @DigdagTimed(value="dpsm_", category="db", appendMethodName=true)
    public StoredProject getProjectByIdInternal(int projId) throws ResourceNotFoundException {
        return this.requiredResource((handle, dao) -> dao.getProjectByIdInternal(projId), "project id=%s", new Object[]{projId});
    }

    @Override
    @DigdagTimed(value="dpsm_", category="db", appendMethodName=true)
    public StoredRevision getRevisionOfWorkflowDefinition(long wfId) throws ResourceNotFoundException {
        return this.requiredResource((handle, dao) -> dao.getRevisionOfWorkflowDefinition(wfId), "revision of workflow definition id=%s", new Object[]{wfId});
    }

    private static String makeLastIdCond(Optional<Long> lastId, boolean ascending) {
        String signIneq = ascending ? "\\>" : "\\<";
        Long lastIdValue = (Long)lastId.or(() -> ascending ? 0L : Long.MAX_VALUE);
        return String.format("%s %d", signIneq, lastIdValue);
    }

    private HashMap<String, Integer> idNameListToHashMap(List<IdName> list) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (IdName idName : list) {
            map.put(idName.getName(), idName.getId());
        }
        return map;
    }

    static class ScheduleStatusMapper
    implements ResultSetMapper<ScheduleStatus> {
        ScheduleStatusMapper() {
        }

        public ScheduleStatus map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ScheduleStatus.of(ScheduleTime.of((Instant)Instant.ofEpochSecond(r.getLong("next_schedule_time")), (Instant)Instant.ofEpochSecond(r.getLong("next_run_time"))), (Optional<Instant>)BasicDatabaseStoreManager.getOptionalLong(r, "last_session_time").transform(it -> Instant.ofEpochSecond(it)));
        }
    }

    static class IdNameMapper
    implements ResultSetMapper<IdName> {
        IdNameMapper() {
        }

        public IdName map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return IdName.of(r.getInt("id"), r.getString("name"));
        }
    }

    static class WorkflowConfigMapper
    implements ResultSetMapper<WorkflowConfig> {
        WorkflowConfigMapper() {
        }

        public WorkflowConfig map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableWorkflowConfig.builder().id(r.getInt("id")).configText(r.getString("config")).timeZone(r.getString("timezone")).build();
        }
    }

    static class StoredWorkflowDefinitionWithProjectMapper
    implements ResultSetMapper<StoredWorkflowDefinitionWithProject> {
        private final ConfigMapper cfm;

        public StoredWorkflowDefinitionWithProjectMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredWorkflowDefinitionWithProject map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            String projName = r.getString("proj_name");
            Optional projDeletedAt = Optional.absent();
            if (r.wasNull()) {
                projName = r.getString("proj_deleted_name");
                projDeletedAt = Optional.of((Object)BasicDatabaseStoreManager.getTimestampInstant(r, "proj_deleted_at"));
            }
            return ImmutableStoredWorkflowDefinitionWithProject.builder().id(r.getLong("id")).revisionId(r.getInt("revision_id")).timeZone(ZoneId.of(r.getString("timezone"))).name(r.getString("name")).config(this.cfm.fromResultSetOrEmpty(r, "config")).project(ImmutableStoredProject.builder().id(r.getInt("proj_id")).name(projName).siteId(r.getInt("site_id")).createdAt(BasicDatabaseStoreManager.getTimestampInstant(r, "proj_created_at")).deletedAt((Optional<Instant>)projDeletedAt).build()).revisionName(r.getString("rev_name")).revisionDefaultParams(this.cfm.fromResultSetOrEmpty(r, "rev_default_params")).build();
        }
    }

    static class StoredWorkflowDefinitionMapper
    implements ResultSetMapper<StoredWorkflowDefinition> {
        private final ConfigMapper cfm;

        public StoredWorkflowDefinitionMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredWorkflowDefinition map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableStoredWorkflowDefinition.builder().id(r.getLong("id")).revisionId(r.getInt("revision_id")).timeZone(ZoneId.of(r.getString("timezone"))).name(r.getString("name")).config(this.cfm.fromResultSetOrEmpty(r, "config")).build();
        }
    }

    static class StoredRevisionMapper
    implements ResultSetMapper<StoredRevision> {
        private final ConfigMapper cfm;

        public StoredRevisionMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredRevision map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableStoredRevision.builder().id(r.getInt("id")).projectId(r.getInt("project_id")).createdAt(BasicDatabaseStoreManager.getTimestampInstant(r, "created_at")).name(r.getString("name")).defaultParams(this.cfm.fromResultSetOrEmpty(r, "default_params")).archiveType(ArchiveType.of(r.getString("archive_type"))).archiveMd5(BasicDatabaseStoreManager.getOptionalBytes(r, "archive_md5")).archivePath(BasicDatabaseStoreManager.getOptionalString(r, "archive_path")).userInfo(this.cfm.fromResultSetOrEmpty(r, "user_info")).build();
        }
    }

    static class StoredProjectWithRevisionMapper
    implements ResultSetMapper<StoredProjectWithRevision> {
        private final ConfigMapper cfm;

        public StoredProjectWithRevisionMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredProjectWithRevision map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            String name = r.getString("name");
            Optional deletedAt = Optional.absent();
            if (r.wasNull()) {
                name = r.getString("deleted_name");
                deletedAt = Optional.of((Object)BasicDatabaseStoreManager.getTimestampInstant(r, "deleted_at"));
            }
            return ImmutableStoredProjectWithRevision.builder().id(r.getInt("id")).name(name).siteId(r.getInt("site_id")).createdAt(BasicDatabaseStoreManager.getTimestampInstant(r, "created_at")).deletedAt((Optional<Instant>)deletedAt).revisionName(r.getString("revision_name")).revisionCreatedAt(BasicDatabaseStoreManager.getTimestampInstant(r, "revision_created_at")).revisionArchiveType(ArchiveType.of(r.getString("revision_archive_type"))).revisionArchiveMd5(BasicDatabaseStoreManager.getOptionalBytes(r, "revision_archive_md5")).build();
        }
    }

    static class StoredProjectMapper
    implements ResultSetMapper<StoredProject> {
        private final ConfigMapper cfm;

        public StoredProjectMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredProject map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            String name = r.getString("name");
            Optional deletedAt = Optional.absent();
            if (r.wasNull()) {
                name = r.getString("deleted_name");
                deletedAt = Optional.of((Object)BasicDatabaseStoreManager.getTimestampInstant(r, "deleted_at"));
            }
            return ImmutableStoredProject.builder().id(r.getInt("id")).name(name).siteId(r.getInt("site_id")).createdAt(BasicDatabaseStoreManager.getTimestampInstant(r, "created_at")).deletedAt((Optional<Instant>)deletedAt).build();
        }
    }

    @Value.Immutable
    public static abstract class WorkflowConfig {
        private static final MessageDigest md5;

        public abstract int getId();

        public abstract String getConfigText();

        public abstract String getTimeZone();

        public static long digest(String configText, String zoneId) {
            try {
                String target = configText + " " + zoneId;
                byte[] digest = ((MessageDigest)md5.clone()).digest(target.getBytes(StandardCharsets.UTF_8));
                return ByteBuffer.wrap(digest).getLong(0);
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public static boolean isEquivalent(WorkflowConfig c, String configText, String zoneId) {
            return configText.equals(c.getConfigText()) && zoneId.equals(c.getTimeZone());
        }

        static {
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static interface Dao {
        @SqlQuery(value="select proj.* from projects proj where proj.site_id = :siteId and proj.name is not null and proj.id \\> :lastId and proj.name like :namePattern and <acFilter> order by proj.id asc limit :limit")
        public List<StoredProject> getProjects(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") int var3, @Bind(value="namePattern") String var4, @Define(value="acFilter") String var5);

        public List<StoredProjectWithRevision> getProjectsWithLatestRevision(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") int var3, @Bind(value="namePattern") String var4, @Define(value="acFilter") String var5);

        @SqlUpdate(value="update projects set deleted_name = name, deleted_at = now(), name = NULL where id = :projId  and name is not null")
        public int deleteProject(@Bind(value="projId") int var1);

        @SqlQuery(value="select * from projects where site_id = :siteId and id = :id")
        public StoredProject getProjectById(@Bind(value="siteId") int var1, @Bind(value="id") int var2);

        @SqlQuery(value="select * from projects where site_id = :siteId and id = :id and name is not null for update")
        public StoredProject getProjectByIdWithLockForDelete(@Bind(value="siteId") int var1, @Bind(value="id") int var2);

        @SqlQuery(value="select * from projects where id = :id")
        public StoredProject getProjectByIdInternal(@Bind(value="id") int var1);

        @SqlQuery(value="select rev.* from workflow_definitions wd join revisions rev on rev.id = wd.revision_id where wd.id = :id")
        public StoredRevision getRevisionOfWorkflowDefinition(@Bind(value="id") long var1);

        @SqlQuery(value="select * from projects where site_id = :siteId and name = :name limit 1")
        public StoredProject getProjectByName(@Bind(value="siteId") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select rev.* from revisions rev join projects proj on proj.id = rev.project_id where site_id = :siteId and rev.id = :id")
        public StoredRevision getRevisionById(@Bind(value="siteId") int var1, @Bind(value="id") int var2);

        @SqlQuery(value="select rev.* from revisions rev join projects proj on proj.id = rev.project_id where site_id = :siteId and rev.project_id = :projId and rev.name = :name limit 1")
        public StoredRevision getRevisionByName(@Bind(value="siteId") int var1, @Bind(value="projId") int var2, @Bind(value="name") String var3);

        @SqlQuery(value="select rev.* from revisions rev join projects proj on proj.id = rev.project_id where site_id = :siteId and rev.project_id = :projId order by rev.id desc limit 1")
        public StoredRevision getLatestRevision(@Bind(value="siteId") int var1, @Bind(value="projId") int var2);

        @SqlQuery(value="select rev.* from revisions rev join projects proj on proj.id = rev.project_id where site_id = :siteId and rev.project_id = :projId and rev.id \\< :lastId order by rev.id desc limit :limit")
        public List<StoredRevision> getRevisions(@Bind(value="siteId") int var1, @Bind(value="projId") int var2, @Bind(value="limit") int var3, @Bind(value="lastId") int var4);

        @SqlQuery(value="select archive_data from revision_archives where id = :revId")
        public byte[] selectRevisionArchiveData(@Bind(value="revId") int var1);

        @SqlQuery(value="select wd.*, wc.config, wc.timezone, proj.id as proj_id, proj.name as proj_name, proj.deleted_name as proj_deleted_name, proj.deleted_at as proj_deleted_at, proj.site_id, proj.created_at as proj_created_at, rev.name as rev_name, rev.default_params as rev_default_params from workflow_definitions wd join revisions rev on rev.id = wd.revision_id join projects proj on proj.id = rev.project_id join workflow_configs wc on wc.id = wd.config_id where wd.revision_id = (select max(id) from revisions where project_id = :projId) and wd.name = :name and proj.site_id = :siteId limit 1")
        public StoredWorkflowDefinitionWithProject getLatestWorkflowDefinitionByName(@Bind(value="siteId") int var1, @Bind(value="projId") int var2, @Bind(value="name") String var3);

        default public List<StoredWorkflowDefinitionWithProject> getLatestActiveWorkflowDefinitions(int siteId, int limit, long lastId, String namePattern, String acFilter) {
            return this.getLatestActiveWorkflowDefinitions(siteId, limit, DatabaseProjectStoreManager.makeLastIdCond((Optional<Long>)Optional.of((Object)lastId), true), namePattern, "", "asc", acFilter);
        }

        public List<StoredWorkflowDefinitionWithProject> getLatestActiveWorkflowDefinitions(int var1, int var2, String var3, String var4, String var5, String var6, String var7);

        @SqlQuery(value="select wd.*, wc.config, wc.timezone, proj.id as proj_id, proj.name as proj_name, proj.deleted_name as proj_deleted_name, proj.deleted_at as proj_deleted_at, proj.site_id, proj.created_at as proj_created_at, rev.name as rev_name, rev.default_params as rev_default_params from workflow_definitions wd join revisions rev on rev.id = wd.revision_id join projects proj on proj.id = rev.project_id join workflow_configs wc on wc.id = wd.config_id where wd.id = :id")
        public StoredWorkflowDefinitionWithProject getWorkflowDetailsByIdInternal(@Bind(value="id") long var1);

        @SqlQuery(value="select wd.*, wc.config, wc.timezone, proj.id as proj_id, proj.name as proj_name, proj.deleted_name as proj_deleted_name, proj.deleted_at as proj_deleted_at, proj.site_id, proj.created_at as proj_created_at, rev.name as rev_name, rev.default_params as rev_default_params from workflow_definitions wd join revisions rev on rev.id = wd.revision_id join projects proj on proj.id = rev.project_id join workflow_configs wc on wc.id = wd.config_id where wd.id = :id and site_id = :siteId")
        public StoredWorkflowDefinitionWithProject getWorkflowDetailsById(@Bind(value="siteId") int var1, @Bind(value="id") long var2);

        @SqlQuery(value="select wd.*, wc.config, wc.timezone from workflow_definitions wd join revisions rev on rev.id = wd.revision_id join projects proj on proj.id = rev.project_id join workflow_configs wc on wc.id = wd.config_id where wd.id = :id and site_id = :siteId")
        public StoredWorkflowDefinition getWorkflowDefinitionById(@Bind(value="siteId") int var1, @Bind(value="id") long var2);

        @SqlQuery(value="select wd.*, wc.config, wc.timezone from workflow_definitions wd join revisions rev on rev.id = wd.revision_id join projects proj on proj.id = rev.project_id join workflow_configs wc on wc.id = wd.config_id where revision_id = :revId and wd.name = :name and site_id = :siteId limit 1")
        public StoredWorkflowDefinition getWorkflowDefinitionByName(@Bind(value="siteId") int var1, @Bind(value="revId") int var2, @Bind(value="name") String var3);

        @SqlQuery(value="select id, config, timezone from workflow_configs where project_id = :projId and config_digest = :configDigest")
        public WorkflowConfig findWorkflowConfigByDigest(@Bind(value="projId") int var1, @Bind(value="configDigest") long var2);

        @SqlUpdate(value="insert into workflow_configs (project_id, config, timezone, config_digest) values (:projId, :config, :timezone, :configDigest)")
        @GetGeneratedKeys
        public int insertWorkflowConfig(@Bind(value="projId") int var1, @Bind(value="config") String var2, @Bind(value="timezone") String var3, @Bind(value="configDigest") long var4);

        @SqlUpdate(value="insert into revisions (project_id, name, default_params, archive_type, archive_md5, archive_path, user_info, created_at) values (:projId, :name, :defaultParams, :archiveType, :archiveMd5, :archivePath, :userInfo, now())")
        @GetGeneratedKeys
        public int insertRevision(@Bind(value="projId") int var1, @Bind(value="name") String var2, @Bind(value="defaultParams") Config var3, @Bind(value="archiveType") String var4, @Bind(value="archiveMd5") byte[] var5, @Bind(value="archivePath") String var6, @Bind(value="userInfo") Config var7);

        @SqlQuery(value="select wd.*, wc.config, wc.timezone from workflow_definitions wd join revisions rev on rev.id = wd.revision_id join projects proj on proj.id = rev.project_id join workflow_configs wc on wc.id = wd.config_id where wd.revision_id = :revId and wd.id \\> :lastId and proj.site_id = :siteId and <acFilter> order by wd.id asc limit :limit")
        public List<StoredWorkflowDefinition> getWorkflowDefinitions(@Bind(value="siteId") int var1, @Bind(value="revId") int var2, @Bind(value="limit") int var3, @Bind(value="lastId") long var4, @Define(value="acFilter") String var6);

        @SqlUpdate(value="insert into revision_archives (id, archive_data) values (:revId, :data)")
        public void insertRevisionArchiveData(@Bind(value="revId") int var1, @Bind(value="data") byte[] var2);

        @SqlUpdate(value="insert into workflow_definitions (revision_id, name, config_id) values (:revId, :name, :configId)")
        @GetGeneratedKeys
        public long insertWorkflowDefinition(@Bind(value="revId") int var1, @Bind(value="name") String var2, @Bind(value="configId") int var3);

        @SqlQuery(value="select wd.name, schedules.id from schedules join workflow_definitions wd on wd.id = schedules.workflow_definition_id where schedules.project_id = :projId")
        public List<IdName> getScheduleNames(@Bind(value="projId") int var1);

        @SqlUpdate(value="delete from schedules where project_id = :projId")
        public int deleteSchedules(@Bind(value="projId") int var1);

        @SqlQuery(value="select next_run_time, next_schedule_time, last_session_time from schedules where id = :id for update")
        public ScheduleStatus lockScheduleById(@Bind(value="id") int var1);

        @SqlUpdate(value="update schedules set workflow_definition_id = :workflowDefinitionId, next_run_time = :nextRunTime, next_schedule_time = :nextScheduleTime, updated_at = now() where id = :id")
        public int updateScheduleById(@Bind(value="id") int var1, @Bind(value="workflowDefinitionId") long var2, @Bind(value="nextRunTime") long var4, @Bind(value="nextScheduleTime") long var6);

        @SqlUpdate(value="insert into schedules (project_id, workflow_definition_id, next_run_time, next_schedule_time, last_session_time, created_at, updated_at) values (:projId, :workflowDefinitionId, :nextRunTime, :nextScheduleTime, NULL, now(), now())")
        @GetGeneratedKeys
        public int insertSchedule(@Bind(value="projId") int var1, @Bind(value="workflowDefinitionId") long var2, @Bind(value="nextRunTime") long var4, @Bind(value="nextScheduleTime") long var6);
    }

    @UseStringTemplate3StatementLocator
    public static interface PgDao
    extends Dao {
        @Override
        @SqlQuery(value="select id, site_id, name, created_at, deleted_at, deleted_name, revision_name, revision_created_at, revision_archive_type, revision_archive_md5 from ( select proj.*, rev.name as revision_name, rev.created_at as revision_created_at, rev.archive_type as revision_archive_type, rev.archive_md5 as revision_archive_md5, rev.id as revision_id, max(rev.id) OVER(partition by rev.project_id) as max_revision_id from projects proj join revisions rev on proj.id = rev.project_id where proj.site_id = :siteId and proj.name is not null and proj.name like :namePattern and <acFilter> and proj.id > :lastId) as projects_with_revision where projects_with_revision.revision_id = projects_with_revision.max_revision_id order by id asc limit :limit")
        public List<StoredProjectWithRevision> getProjectsWithLatestRevision(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") int var3, @Bind(value="namePattern") String var4, @Define(value="acFilter") String var5);

        @SqlQuery(value="insert into projects (site_id, name, created_at) values (:siteId, :name, now()) on conflict (site_id, name) do update set created_at = projects.created_at returning *")
        public StoredProject upsertAndLockProject(@Bind(value="siteId") int var1, @Bind(value="name") String var2);

        @Override
        @SqlQuery(value="select wd.*, wc.config, wc.timezone, p.id as proj_id, p.name as proj_name, p.deleted_name as proj_deleted_name, p.deleted_at as proj_deleted_at, p.site_id, p.created_at as proj_created_at, r.name as rev_name, r.default_params as rev_default_params from (select wf.* from workflow_definitions wf join revisions rev on rev.id = wf.revision_id join projects proj on proj.id = rev.project_id where wf.revision_id = any(array(select max(r.id) from revisions r join projects p on r.project_id = p.id where p.site_id = :siteId and p.deleted_at is null group by r.project_id ))  and wf.id <lastIdCond> and ( wf.name like :namePattern or proj.name like :projectNamePattern ) and <acFilter> order by wf.id <orderDirection> limit :limit) wd join revisions r on r.id = wd.revision_id join projects p on p.id = r.project_id join workflow_configs wc on wc.id = wd.config_id order by wd.id <orderDirection>")
        public List<StoredWorkflowDefinitionWithProject> getLatestActiveWorkflowDefinitions(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Define(value="lastIdCond") String var3, @Bind(value="namePattern") String var4, @Bind(value="projectNamePattern") String var5, @Define(value="orderDirection") String var6, @Define(value="acFilter") String var7);
    }

    @UseStringTemplate3StatementLocator
    public static interface H2Dao
    extends Dao {
        @Override
        @SqlQuery(value="select proj.*, rev.name as revision_name, rev.created_at as revision_created_at, rev.archive_type as revision_archive_type, rev.archive_md5 as revision_archive_md5 from projects proj join revisions rev on proj.id = rev.project_id join (select project_id, max(id) AS id from revisions group by project_id) a on a.id = rev.id where proj.site_id = :siteId and proj.name is not null and proj.name like :namePattern and <acFilter> and proj.id > :lastId order by proj.id asc limit :limit")
        public List<StoredProjectWithRevision> getProjectsWithLatestRevision(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") int var3, @Bind(value="namePattern") String var4, @Define(value="acFilter") String var5);

        @SqlUpdate(value="merge into projects (site_id, name, created_at) key (site_id, name) values (:siteId, :name, coalesce((select created_at from projects where site_id = :siteId and name = :name), now()))")
        public void upsertAndLockProject(@Bind(value="siteId") int var1, @Bind(value="name") String var2);

        @Override
        @SqlQuery(value="select wd.*, wc.config, wc.timezone, proj.id as proj_id, proj.name as proj_name, proj.deleted_name as proj_deleted_name, proj.deleted_at as proj_deleted_at, proj.site_id, proj.created_at as proj_created_at, rev.name as rev_name, rev.default_params as rev_default_params from workflow_definitions wd join (select r.project_id, max(r.id) as revision_id from revisions r join projects p on r.project_id = p.id where p.site_id = :siteId and p.deleted_at is null group by r.project_id) a on wd.revision_id = a.revision_id join revisions rev on a.revision_id = rev.id join projects proj on a.project_id = proj.id join workflow_configs wc on wc.id = wd.config_id where wd.id <lastIdCond> and ( wd.name like :namePattern or proj.name like :projectNamePattern ) and <acFilter> order by wd.id <orderDirection> limit :limit")
        public List<StoredWorkflowDefinitionWithProject> getLatestActiveWorkflowDefinitions(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Define(value="lastIdCond") String var3, @Bind(value="namePattern") String var4, @Bind(value="projectNamePattern") String var5, @Define(value="orderDirection") String var6, @Define(value="acFilter") String var7);
    }

    private class DatabaseProjectControlStore
    implements ProjectControlStore {
        private final Handle handle;
        private final int siteId;
        private final Dao dao;

        public DatabaseProjectControlStore(Handle handle, int siteId) {
            this.handle = handle;
            this.siteId = siteId;
            this.dao = (Dao)handle.attach(Dao.class);
        }

        @Override
        @DigdagTimed(value="dpcst_", category="db", appendMethodName=true)
        public StoredRevision insertRevision(int projId, Revision revision) throws ResourceConflictException {
            int revId = DatabaseProjectStoreManager.this.catchConflict(() -> this.dao.insertRevision(projId, revision.getName(), revision.getDefaultParams(), revision.getArchiveType().getName(), (byte[])revision.getArchiveMd5().orNull(), (String)revision.getArchivePath().orNull(), revision.getUserInfo()), "revision=%s in project id=%d", revision.getName(), projId);
            try {
                return DatabaseProjectStoreManager.this.requiredResource(this.dao.getRevisionById(this.siteId, revId), "revision id=%d", revId);
            }
            catch (ResourceNotFoundException ex) {
                throw new IllegalStateException("Database state error", ex);
            }
        }

        @Override
        @DigdagTimed(value="dpcst_", category="db", appendMethodName=true)
        public void insertRevisionArchiveData(int revId, byte[] data) throws ResourceConflictException {
            DatabaseProjectStoreManager.this.catchConflict(() -> {
                this.dao.insertRevisionArchiveData(revId, data);
                return true;
            }, "revision archive=%d", revId);
        }

        @Override
        @DigdagTimed(value="dpcst_", category="db", appendMethodName=true)
        public StoredWorkflowDefinition insertWorkflowDefinition(int projId, int revId, WorkflowDefinition def, ZoneId workflowTimeZone) throws ResourceConflictException {
            String zoneId;
            String configText = DatabaseProjectStoreManager.this.configMapper.toText(def.getConfig());
            long configDigest = WorkflowConfig.digest(configText, zoneId = workflowTimeZone.getId());
            WorkflowConfig found = this.dao.findWorkflowConfigByDigest(projId, configDigest);
            int configId = found != null && WorkflowConfig.isEquivalent(found, configText, zoneId) ? found.getId() : this.dao.insertWorkflowConfig(projId, configText, zoneId, configDigest);
            long wfId = DatabaseProjectStoreManager.this.catchConflict(() -> this.dao.insertWorkflowDefinition(revId, def.getName(), configId), "workflow=%s in revision id=%d", def.getName(), revId);
            try {
                return DatabaseProjectStoreManager.this.requiredResource(this.dao.getWorkflowDefinitionById(this.siteId, wfId), "workflow id=%d", wfId);
            }
            catch (ResourceNotFoundException ex) {
                throw new IllegalStateException("Database state error", ex);
            }
        }

        @Override
        @DigdagTimed(value="dpcst_", category="db", appendMethodName=true)
        public <T extends Schedule> void updateSchedules(int projId, List<T> schedules, ProjectControlStore.ScheduleUpdateAction<T> func) throws ResourceConflictException {
            HashMap oldScheduleNames = DatabaseProjectStoreManager.this.idNameListToHashMap(this.dao.getScheduleNames(projId));
            for (Schedule schedule : schedules) {
                Integer matchedSchedId = (Integer)oldScheduleNames.get(schedule.getWorkflowName());
                if (matchedSchedId != null) {
                    ScheduleStatus status = this.dao.lockScheduleById(matchedSchedId);
                    if (status == null) continue;
                    ScheduleTime newSchedule = func.apply(status, schedule);
                    this.dao.updateScheduleById(matchedSchedId, schedule.getWorkflowDefinitionId(), newSchedule.getRunTime().getEpochSecond(), newSchedule.getTime().getEpochSecond());
                    oldScheduleNames.remove(schedule.getWorkflowName());
                    continue;
                }
                DatabaseProjectStoreManager.this.catchConflict(() -> this.dao.insertSchedule(projId, schedule.getWorkflowDefinitionId(), schedule.getNextRunTime().getEpochSecond(), schedule.getNextScheduleTime().getEpochSecond()), "workflow_definition_id=%d", schedule.getWorkflowDefinitionId());
            }
            if (!oldScheduleNames.isEmpty()) {
                this.handle.createStatement("delete from schedules where id " + DatabaseProjectStoreManager.this.inLargeIdListExpression(oldScheduleNames.values())).execute();
            }
        }

        @Override
        @DigdagTimed(value="dpcst_", category="db", appendMethodName=true)
        public void deleteSchedules(int projId) {
            this.dao.deleteSchedules(projId);
        }
    }

    private static class IdTimeZoneMapper
    implements ResultSetMapper<IdTimeZone> {
        private IdTimeZoneMapper() {
        }

        public IdTimeZone map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new IdTimeZone(r.getLong("id"), ZoneId.of(r.getString("timezone")));
        }
    }

    private static class IdTimeZone {
        protected final long id;
        protected final ZoneId timeZone;

        public IdTimeZone(long id, ZoneId timeZone) {
            this.id = id;
            this.timeZone = timeZone;
        }

        public static Map<Long, ZoneId> listToMap(List<IdTimeZone> list) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (IdTimeZone pair : list) {
                builder.put((Object)pair.id, (Object)pair.timeZone);
            }
            return builder.build();
        }
    }

    private class DatabaseProjectStore
    implements ProjectStore {
        private final int siteId;

        public DatabaseProjectStore(int siteId) {
            this.siteId = siteId;
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public List<StoredProjectWithRevision> getProjectsWithLatestRevision(int pageSize, Optional<Integer> lastId, Optional<String> namePattern, AccessController.ListFilter acFilter) {
            return DatabaseProjectStoreManager.this.autoCommit((handle, dao) -> dao.getProjectsWithLatestRevision(this.siteId, pageSize, (Integer)lastId.or((Object)0), this.generatePartialMatchPattern(namePattern), acFilter.getSql()));
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public List<StoredProject> getProjects(int pageSize, Optional<Integer> lastId, Optional<String> namePattern, AccessController.ListFilter acFilter) {
            return DatabaseProjectStoreManager.this.autoCommit((handle, dao) -> dao.getProjects(this.siteId, pageSize, (Integer)lastId.or((Object)0), this.generatePartialMatchPattern(namePattern), acFilter.getSql()));
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public ProjectMap getProjectsByIdList(List<Integer> projIdList) {
            if (projIdList.isEmpty()) {
                return ProjectMap.empty();
            }
            List projs = DatabaseProjectStoreManager.this.autoCommit((handle, dao) -> ((Query)handle.createQuery("select * from projects where site_id = :siteId and id " + DatabaseProjectStoreManager.this.inLargeIdListExpression(projIdList)).bind("siteId", this.siteId)).map((ResultSetMapper)new StoredProjectMapper(DatabaseProjectStoreManager.this.configMapper)).list());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (StoredProject proj : projs) {
                builder.put((Object)proj.getId(), (Object)proj);
            }
            return new ProjectMap((Map<Integer, StoredProject>)builder.build());
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public StoredProject getProjectById(int projId) throws ResourceNotFoundException {
            return DatabaseProjectStoreManager.this.requiredResource((handle, dao) -> dao.getProjectById(this.siteId, projId), "project id=%d", new Object[]{projId});
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public StoredProject getProjectByName(String projName) throws ResourceNotFoundException {
            return DatabaseProjectStoreManager.this.requiredResource((handle, dao) -> dao.getProjectByName(this.siteId, projName), "project name=%s", new Object[]{projName});
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public <T> T putAndLockProject(Project project, ProjectStore.ProjectLockAction<T> func) throws ResourceConflictException {
            return (T)DatabaseProjectStoreManager.this.transaction((handle, dao) -> {
                StoredProject proj;
                if (dao instanceof H2Dao) {
                    ((H2Dao)dao).upsertAndLockProject(this.siteId, project.getName());
                    proj = dao.getProjectByName(this.siteId, project.getName());
                    if (proj == null) {
                        throw new IllegalStateException(String.format(Locale.ENGLISH, "Database state error: locked project is null: site_id=%d, name=%s", this.siteId, project.getName()));
                    }
                } else {
                    proj = dao.getProjectByName(this.siteId, project.getName());
                    if (proj == null) {
                        proj = ((PgDao)dao).upsertAndLockProject(this.siteId, project.getName());
                    }
                }
                return func.call(new DatabaseProjectControlStore(handle, this.siteId), proj);
            }, ResourceConflictException.class);
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public <T> T deleteProject(int projId, ProjectStore.ProjectObsoleteAction<T> func) throws ResourceNotFoundException {
            return (T)DatabaseProjectStoreManager.this.transaction((handle, dao) -> {
                StoredProject proj = DatabaseProjectStoreManager.this.requiredResource(dao.getProjectByIdWithLockForDelete(this.siteId, projId), "project id=%d", projId);
                Object res = func.call(new DatabaseProjectControlStore(handle, this.siteId), proj);
                dao.deleteProject(proj.getId());
                return res;
            }, ResourceNotFoundException.class);
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public StoredRevision getRevisionById(int revId) throws ResourceNotFoundException {
            return DatabaseProjectStoreManager.this.requiredResource((handle, dao) -> dao.getRevisionById(this.siteId, revId), "revision id=%d", new Object[]{revId});
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public StoredRevision getRevisionByName(int projId, String revName) throws ResourceNotFoundException {
            return DatabaseProjectStoreManager.this.requiredResource((handle, dao) -> dao.getRevisionByName(this.siteId, projId, revName), "revision name=%s in project id=%d", new Object[]{revName, projId});
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public StoredRevision getLatestRevision(int projId) throws ResourceNotFoundException {
            return DatabaseProjectStoreManager.this.requiredResource((handle, dao) -> dao.getLatestRevision(this.siteId, projId), "project id=%d", new Object[]{projId});
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public List<StoredRevision> getRevisions(int projId, int pageSize, Optional<Integer> lastId) {
            return DatabaseProjectStoreManager.this.autoCommit((handle, dao) -> dao.getRevisions(this.siteId, projId, pageSize, (Integer)lastId.or((Object)Integer.MAX_VALUE)));
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public byte[] getRevisionArchiveData(int revId) throws ResourceNotFoundException {
            return DatabaseProjectStoreManager.this.requiredResource((handle, dao) -> dao.selectRevisionArchiveData(revId), "revisin id=%d", new Object[]{revId});
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public StoredWorkflowDefinitionWithProject getLatestWorkflowDefinitionByName(int projId, String name) throws ResourceNotFoundException {
            return DatabaseProjectStoreManager.this.requiredResource((handle, dao) -> dao.getLatestWorkflowDefinitionByName(this.siteId, projId, name), "workflow name=%s in the latest revision of project id=%d", new Object[]{name, projId});
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public List<StoredWorkflowDefinitionWithProject> getLatestActiveWorkflowDefinitions(int pageSize, Optional<Long> lastId, boolean ascending, Optional<String> namePattern, boolean searchProjectName, AccessController.ListFilter acFilter) throws ResourceNotFoundException {
            String projectNamePattern = searchProjectName ? this.generatePartialMatchPattern(namePattern) : "";
            String ascDesc = ascending ? "asc" : "desc";
            return DatabaseProjectStoreManager.this.autoCommit((handle, dao) -> dao.getLatestActiveWorkflowDefinitions(this.siteId, pageSize, DatabaseProjectStoreManager.makeLastIdCond((Optional<Long>)lastId, ascending), this.generatePartialMatchPattern(namePattern), projectNamePattern, ascDesc, acFilter.getSql()));
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public List<StoredWorkflowDefinition> getWorkflowDefinitions(int revId, int pageSize, Optional<Long> lastId, AccessController.ListFilter acFilter) {
            return DatabaseProjectStoreManager.this.autoCommit((handle, dao) -> dao.getWorkflowDefinitions(this.siteId, revId, pageSize, (Long)lastId.or((Object)0L), acFilter.getSql()));
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public StoredWorkflowDefinitionWithProject getWorkflowDefinitionById(long wfId) throws ResourceNotFoundException {
            return DatabaseProjectStoreManager.this.requiredResource((handle, dao) -> dao.getWorkflowDetailsById(this.siteId, wfId), "workflow id=%d", new Object[]{wfId});
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public StoredWorkflowDefinition getWorkflowDefinitionByName(int revId, String name) throws ResourceNotFoundException {
            return DatabaseProjectStoreManager.this.requiredResource((handle, dao) -> dao.getWorkflowDefinitionByName(this.siteId, revId, name), "workflow name=%s in revision id=%d", new Object[]{name, revId});
        }

        @Override
        @DigdagTimed(value="dpst_", category="db", appendMethodName=true)
        public TimeZoneMap getWorkflowTimeZonesByIdList(List<Long> defIdList) {
            if (defIdList.isEmpty()) {
                return TimeZoneMap.empty();
            }
            List list = DatabaseProjectStoreManager.this.autoCommit((handle, dao) -> ((Query)handle.createQuery("select wd.id, wc.timezone from workflow_definitions wd join revisions rev on rev.id = wd.revision_id join projects proj on proj.id = rev.project_id join workflow_configs wc on wc.id = wd.config_id where wd.id in (" + defIdList.stream().map(it -> Long.toString(it)).collect(Collectors.joining(", ")) + ") and site_id = :siteId").bind("siteId", this.siteId)).map((ResultSetMapper)new IdTimeZoneMapper()).list());
            Map<Long, ZoneId> map = IdTimeZone.listToMap(list);
            return new TimeZoneMap(map);
        }

        private String generatePartialMatchPattern(Optional<String> pattern) {
            return !((String)pattern.or((Object)"")).isEmpty() ? "%" + this.escapeLikePattern((String)pattern.get()) + "%" : "%";
        }

        private String escapeLikePattern(String pattern) {
            return pattern.replace("%", "\\%").replace("_", "\\_");
        }
    }
}

