/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.migrate.Migration;
import io.digdag.core.database.migrate.MigrationContext;
import io.digdag.core.database.migrate.Migration_20151204221156_CreateTables;
import io.digdag.core.database.migrate.Migration_20160602123456_SessionsOnProjectIdIndexToDesc;
import io.digdag.core.database.migrate.Migration_20160602184025_CreateResumingTasks;
import io.digdag.core.database.migrate.Migration_20160610154832_MakeProjectsDeletable;
import io.digdag.core.database.migrate.Migration_20160623123456_AddUserInfoColumnToRevisions;
import io.digdag.core.database.migrate.Migration_20160719172538_QueueRearchitecture;
import io.digdag.core.database.migrate.Migration_20160817123456_AddSecretsTable;
import io.digdag.core.database.migrate.Migration_20160818043815_AddFinishedAtToSessionAttempts;
import io.digdag.core.database.migrate.Migration_20160818220026_QueueUniqueName;
import io.digdag.core.database.migrate.Migration_20160908175551_KeepSecretsUnique;
import io.digdag.core.database.migrate.Migration_20160926123456_AddDisabledAtColumnToSchedules;
import io.digdag.core.database.migrate.Migration_20160928203753_AddWorkflowOrderIndex;
import io.digdag.core.database.migrate.Migration_20161005225356_AddResetParamsToTaskState;
import io.digdag.core.database.migrate.Migration_20161028112233_AddStateFlagsAndCreatedAtIndexToSessionAttempts;
import io.digdag.core.database.migrate.Migration_20161110112233_AddStartedAtColumnAndIndexToTasks;
import io.digdag.core.database.migrate.Migration_20161209001857_CreateDelayedSessionAttempts;
import io.digdag.core.database.migrate.Migration_20170116082921_AddAttemptIndexColumn1;
import io.digdag.core.database.migrate.Migration_20170116090744_AddAttemptIndexColumn2;
import io.digdag.core.database.migrate.Migration_20170223220127_AddLastSessionTimeAndFlagsToSessions;
import io.digdag.core.database.migrate.Migration_20190318175338_AddIndexToSessionAttempts;
import io.digdag.core.database.migrate.Migration_20191105105927_AddIndexToSessions;
import io.digdag.core.database.migrate.Migration_20200716114008_AddLastAttemptIdIndexToSessions;
import io.digdag.core.database.migrate.Migration_20200803184355_ReplacePartialIndexOnSessionAttempts;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMigrator {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMigrator.class);
    private final List<Migration> migrations = Stream.of(new Migration_20151204221156_CreateTables(), new Migration_20160602123456_SessionsOnProjectIdIndexToDesc(), new Migration_20160602184025_CreateResumingTasks(), new Migration_20160610154832_MakeProjectsDeletable(), new Migration_20160623123456_AddUserInfoColumnToRevisions(), new Migration_20160719172538_QueueRearchitecture(), new Migration_20160817123456_AddSecretsTable(), new Migration_20160818043815_AddFinishedAtToSessionAttempts(), new Migration_20160818220026_QueueUniqueName(), new Migration_20160908175551_KeepSecretsUnique(), new Migration_20160926123456_AddDisabledAtColumnToSchedules(), new Migration_20160928203753_AddWorkflowOrderIndex(), new Migration_20161005225356_AddResetParamsToTaskState(), new Migration_20161028112233_AddStateFlagsAndCreatedAtIndexToSessionAttempts(), new Migration_20161110112233_AddStartedAtColumnAndIndexToTasks(), new Migration_20161209001857_CreateDelayedSessionAttempts(), new Migration_20170116082921_AddAttemptIndexColumn1(), new Migration_20170116090744_AddAttemptIndexColumn2(), new Migration_20170223220127_AddLastSessionTimeAndFlagsToSessions(), new Migration_20190318175338_AddIndexToSessionAttempts(), new Migration_20191105105927_AddIndexToSessions(), new Migration_20200716114008_AddLastAttemptIdIndexToSessions(), new Migration_20200803184355_ReplacePartialIndexOnSessionAttempts()).sorted(Comparator.comparing(m -> m.getVersion())).collect(Collectors.toList());
    private final DBI dbi;
    private final String databaseType;

    @Inject
    public DatabaseMigrator(DBI dbi, DatabaseConfig config) {
        this(dbi, config.getType());
    }

    DatabaseMigrator(DBI dbi, String databaseType) {
        this.dbi = dbi;
        this.databaseType = databaseType;
    }

    public static String getDriverClassName(String type) {
        switch (type) {
            case "h2": {
                return "org.h2.Driver";
            }
            case "postgresql": {
                return "org.postgresql.Driver";
            }
        }
        throw new RuntimeException("Unsupported database type: " + type);
    }

    public String getSchemaVersion() {
        try (Handle handle = this.dbi.open();){
            String string = (String)handle.createQuery("select name from schema_migrations order by name desc limit 1").mapTo(String.class).first();
            return string;
        }
    }

    public int migrate() {
        Set<String> appliedSet;
        int numApplied = 0;
        MigrationContext context = new MigrationContext(this.databaseType);
        try (Handle handle = this.dbi.open();){
            boolean isInitial;
            boolean bl = isInitial = !this.existsSchemaMigrationsTable(handle);
            if (isInitial) {
                this.createSchemaMigrationsTable(handle, context);
            }
            appliedSet = this.getAppliedMigrationNames(handle);
        }
        for (Migration m : this.migrations) {
            if (!appliedSet.add(m.getVersion()) || !this.applyMigrationIfNotDone(context, m)) continue;
            ++numApplied;
        }
        if (numApplied > 0) {
            if (context.isPostgres()) {
                logger.info("{} migrations applied.", (Object)numApplied);
            } else {
                logger.debug("{} migrations applied.", (Object)numApplied);
            }
        }
        return numApplied;
    }

    private synchronized boolean applyMigrationIfNotDone(MigrationContext context, Migration m) {
        try (Handle handle = this.dbi.open();){
            if (m.noTransaction(context)) {
                if (context.isPostgres()) {
                    handle.select("SELECT pg_advisory_lock(23299, 0)", new Object[0]);
                    if (!this.checkIfMigrationApplied(handle, m.getVersion())) {
                        logger.info("Applying database migration:" + m.getVersion());
                        this.applyMigration(m, handle, context);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                logger.debug("Applying database migration:" + m.getVersion());
                this.applyMigration(m, handle, context);
                boolean bl = true;
                return bl;
            }
            boolean bl = (Boolean)handle.inTransaction((h, session) -> {
                if (context.isPostgres()) {
                    h.update("LOCK TABLE schema_migrations IN EXCLUSIVE MODE", new Object[0]);
                    if (!this.checkIfMigrationApplied(h, m.getVersion())) {
                        logger.info("Applying database migration:" + m.getVersion());
                        this.applyMigration(m, handle, context);
                        return true;
                    }
                    return false;
                }
                logger.debug("Applying database migration:" + m.getVersion());
                this.applyMigration(m, handle, context);
                return true;
            });
            return bl;
        }
    }

    public List<Migration> getApplicableMigration() {
        ArrayList<Migration> applicableMigrations = new ArrayList<Migration>();
        MigrationContext context = new MigrationContext(this.databaseType);
        try (Handle handle = this.dbi.open();){
            boolean isInitial;
            boolean bl = isInitial = !this.existsSchemaMigrationsTable(handle);
            if (isInitial) {
                ArrayList<Migration> arrayList = applicableMigrations;
                return arrayList;
            }
            Set<String> appliedSet = this.getAppliedMigrationNames(handle);
            for (Migration m : this.migrations) {
                if (appliedSet.contains(m.getVersion())) continue;
                applicableMigrations.add(m);
            }
        }
        return applicableMigrations;
    }

    private Set<String> getAppliedMigrationNames(Handle handle) {
        return new HashSet<String>(handle.createQuery("select name from schema_migrations").mapTo(String.class).list());
    }

    private boolean checkIfMigrationApplied(Handle handle, String name) {
        return ((Query)handle.createQuery("select name from schema_migrations where name = :name limit 1").bind("name", name)).mapTo(String.class).list().size() > 0;
    }

    @VisibleForTesting
    public void createSchemaMigrationsTable(Handle handle, MigrationContext context) {
        handle.update(context.newCreateTableBuilder("schema_migrations").addString("name", "not null").addTimestamp("created_at", "not null").build(), new Object[0]);
    }

    public boolean existsSchemaMigrationsTable() {
        try (Handle handle = this.dbi.open();){
            boolean bl = this.existsSchemaMigrationsTable(handle);
            return bl;
        }
    }

    private boolean existsSchemaMigrationsTable(Handle handle) {
        try {
            handle.createQuery("select name from schema_migrations limit 1").mapTo(String.class).list();
            return true;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    @VisibleForTesting
    public void applyMigration(Migration m, Handle handle, MigrationContext context) {
        m.migrate(handle, context);
        handle.insert("insert into schema_migrations (name, created_at) values (?, now())", new Object[]{m.getVersion()});
    }

    @VisibleForTesting
    public String getDatabaseType() {
        return this.databaseType;
    }
}

