/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.Optional;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.exceptions.TransactionFailedException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicDatabaseStoreManager<D> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String databaseType;
    private final Class<? extends D> daoIface;
    private final TransactionManager transactionManager;
    protected final ConfigMapper configMapper;

    protected BasicDatabaseStoreManager(String databaseType, Class<? extends D> daoIface, TransactionManager transactionManager, ConfigMapper configMapper) {
        this.databaseType = databaseType;
        this.daoIface = daoIface;
        this.transactionManager = transactionManager;
        this.configMapper = configMapper;
    }

    public <T> T requiredResource(T resource, String messageFormat, Object ... messageParameters) throws ResourceNotFoundException {
        if (resource == null) {
            throw new ResourceNotFoundException("Resource does not exist: " + String.format(messageFormat, messageParameters));
        }
        return resource;
    }

    public <T> T requiredResource(AutoCommitAction<T, D> action, String messageFormat, Object ... messageParameters) throws ResourceNotFoundException {
        return this.requiredResource(this.autoCommit(action), messageFormat, messageParameters);
    }

    public <T> T catchConflict(NewResourceAction<T> function, String messageFormat, Object ... messageParameters) throws ResourceConflictException {
        try {
            return function.call();
        }
        catch (UnableToExecuteStatementException ex) {
            SQLException sqlEx;
            if (ex.getCause() instanceof SQLException && this.isConflictException(sqlEx = (SQLException)ex.getCause())) {
                throw new ResourceConflictException("Resource already exists: " + String.format(messageFormat, messageParameters));
            }
            throw ex;
        }
    }

    public <T> T catchForeignKeyNotFound(NewResourceAction<T> function, String messageFormat, Object ... messageParameters) throws ResourceNotFoundException, ResourceConflictException {
        try {
            return function.call();
        }
        catch (UnableToExecuteStatementException ex) {
            SQLException sqlEx;
            if (ex.getCause() instanceof SQLException && this.isForeignKeyException(sqlEx = (SQLException)ex.getCause())) {
                throw new ResourceNotFoundException("Resource not found: " + String.format(messageFormat, messageParameters));
            }
            throw ex;
        }
    }

    public boolean isConflictException(SQLException ex) {
        return "23505".equals(ex.getSQLState());
    }

    public boolean isForeignKeyException(SQLException ex) {
        switch (this.databaseType) {
            case "h2": {
                return "23506".equals(ex.getSQLState());
            }
        }
        return "23503".equals(ex.getSQLState());
    }

    public <T extends Number> String inLargeIdListExpression(Collection<T> idList) {
        if (idList.size() == 1) {
            return "= " + ((Number)idList.iterator().next()).toString();
        }
        switch (this.databaseType) {
            case "h2": {
                return "in (" + idList.stream().map(it -> it.toString()).collect(Collectors.joining(", ")) + ")";
            }
        }
        return "= any('{" + idList.stream().map(it -> it.toString()).collect(Collectors.joining(",")) + "}')";
    }

    public <T> T transaction(TransactionAction<T, D> action) {
        Handle handle = this.transactionManager.getHandle(this.configMapper);
        return action.call(handle, handle.attach(this.daoIface));
    }

    public <T, E1 extends Exception> T transaction(TransactionActionWithExceptions<T, D, E1, RuntimeException, RuntimeException> action, Class<E1> exClass1) throws E1 {
        return this.transaction(action, exClass1, RuntimeException.class, RuntimeException.class);
    }

    public <T, E1 extends Exception, E2 extends Exception> T transaction(TransactionActionWithExceptions<T, D, E1, E2, RuntimeException> action, Class<E1> exClass1, Class<E2> exClass2) throws E1, E2 {
        return this.transaction(action, exClass1, exClass2, RuntimeException.class);
    }

    public <T, E1 extends Exception, E2 extends Exception, E3 extends Exception> T transaction(TransactionActionWithExceptions<T, D, E1, E2, E3> action, Class<E1> exClass1, Class<E2> exClass2, Class<E3> exClass3) throws E1, E2, E3 {
        try {
            Handle handle = this.transactionManager.getHandle(this.configMapper);
            return action.call(handle, handle.attach(this.daoIface));
        }
        catch (Exception ex) {
            ThrowablesUtil.propagateIfInstanceOf((Throwable)ex, exClass1);
            ThrowablesUtil.propagateIfInstanceOf((Throwable)ex, exClass2);
            ThrowablesUtil.propagateIfInstanceOf((Throwable)ex, exClass3);
            ThrowablesUtil.propagateIfPossible((Throwable)ex);
            throw new TransactionFailedException("Transaction failed due to exception being thrown from within the callback. See cause for the original exception.", (Throwable)ex);
        }
    }

    public <T> T autoCommit(AutoCommitAction<T, D> action) {
        Handle handle = this.transactionManager.getHandle(this.configMapper);
        return action.call(handle, handle.attach(this.daoIface));
    }

    public static Optional<Integer> getOptionalInt(ResultSet r, String column) throws SQLException {
        int v = r.getInt(column);
        return BasicDatabaseStoreManager.optional(r.wasNull(), v);
    }

    public static Optional<Long> getOptionalLong(ResultSet r, String column) throws SQLException {
        long v = r.getLong(column);
        return BasicDatabaseStoreManager.optional(r.wasNull(), v);
    }

    public static UUID getUuid(ResultSet r, String column) throws SQLException {
        String v = r.getString(column);
        return UUID.fromString(v);
    }

    public static Instant getTimestampInstant(ResultSet r, String column) throws SQLException {
        return r.getTimestamp(column).toInstant();
    }

    public static Optional<Instant> getOptionalTimestampInstant(ResultSet r, String column) throws SQLException {
        Timestamp t = r.getTimestamp(column);
        if (r.wasNull()) {
            return Optional.absent();
        }
        return Optional.of((Object)t.toInstant());
    }

    public static Optional<String> getOptionalString(ResultSet r, String column) throws SQLException {
        String v = r.getString(column);
        return BasicDatabaseStoreManager.optional(r.wasNull(), v);
    }

    public static Optional<byte[]> getOptionalBytes(ResultSet r, String column) throws SQLException {
        byte[] v = r.getBytes(column);
        return BasicDatabaseStoreManager.optional(r.wasNull(), v);
    }

    public static List<Long> getLongIdList(ResultSet r, String column) throws SQLException {
        String v = r.getString(column);
        if (r.wasNull()) {
            return new ArrayList<Long>();
        }
        return Stream.of(v.split(",")).map(it -> Long.parseLong(it)).collect(Collectors.toList());
    }

    private static <T> Optional<T> optional(boolean wasNull, T v) {
        if (wasNull) {
            return Optional.absent();
        }
        return Optional.of(v);
    }

    public static interface TransactionActionWithExceptions<T, D, E1 extends Exception, E2 extends Exception, E3 extends Exception> {
        public T call(Handle var1, D var2) throws E1, E2, E3;
    }

    public static interface TransactionAction<T, D> {
        public T call(Handle var1, D var2);
    }

    public static interface AutoCommitActionWithExceptions<T, D, E1 extends Exception, E2 extends Exception, E3 extends Exception> {
        public T call(Handle var1, D var2) throws E1, E2, E3;
    }

    public static interface AutoCommitAction<T, D> {
        public T call(Handle var1, D var2);
    }

    public static interface NewResourceAction<T> {
        public T call() throws ResourceConflictException;
    }
}

