/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.crypto;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.digdag.client.config.Config;
import io.digdag.core.crypto.SecretCrypto;
import io.digdag.core.database.AESGCMSecretCrypto;
import io.digdag.core.database.DisabledSecretCrypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretCryptoProvider
implements Provider<SecretCrypto> {
    private static final Logger logger = LoggerFactory.getLogger(SecretCryptoProvider.class);
    private final SecretCrypto crypto;

    @Inject
    public SecretCryptoProvider(Config systemConfig) {
        Optional encryptionKey = systemConfig.getOptional("digdag.secret-encryption-key", String.class);
        this.crypto = encryptionKey.isPresent() ? new AESGCMSecretCrypto((String)encryptionKey.get()) : new DisabledSecretCrypto();
        logger.info("secret encryption engine: {}", (Object)this.crypto.getName());
    }

    public SecretCrypto get() {
        return this.crypto;
    }
}

