/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.archive;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class ProjectArchives {
    private ProjectArchives() {
    }

    public static void extractTarArchive(Path destDir, InputStream in) throws IOException {
        ProjectArchives.extractTarArchive(destDir, in, null);
    }

    public static void extractTarArchive(Path destDir, InputStream in, ExtractListener listener) throws IOException {
        try (TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(in, 16384)));){
            ProjectArchives.extractArchive(destDir.toAbsolutePath().normalize(), archive, listener);
        }
    }

    private static void extractArchive(Path destDir, TarArchiveInputStream archive, ExtractListener listener) throws IOException {
        TarArchiveEntry entry;
        String prefix = destDir.toString();
        while ((entry = archive.getNextTarEntry()) != null) {
            Path path = destDir.resolve(entry.getName()).normalize();
            if (!path.toString().startsWith(prefix)) {
                throw new RuntimeException("Archive includes an invalid entry: " + entry.getName());
            }
            if (entry.isDirectory()) {
                Files.createDirectories(path, new FileAttribute[0]);
            } else if (entry.isSymbolicLink()) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                String dest = entry.getLinkName();
                Path destAbsPath = path.getParent().resolve(dest).normalize();
                if (!destAbsPath.normalize().toString().startsWith(prefix)) {
                    throw new RuntimeException("Archive includes an invalid symlink: " + entry.getName() + " -> " + dest);
                }
                if (listener != null) {
                    listener.symlink(destDir.relativize(path), dest);
                }
                Files.createSymbolicLink(path, Paths.get(dest, new String[0]), new FileAttribute[0]);
            } else {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                if (listener != null) {
                    listener.file(destDir.relativize(path));
                }
                try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                    ByteStreams.copy((InputStream)archive, (OutputStream)out);
                }
            }
            if (Files.isSymbolicLink(path) || !ProjectArchives.isPosixCompliant()) continue;
            Files.setPosixFilePermissions(path, ProjectArchives.getPosixFilePermissions(entry));
        }
    }

    private static boolean isPosixCompliant() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            return !osName.toLowerCase(Locale.ENGLISH).contains("windows");
        }
        return true;
    }

    private static Set<PosixFilePermission> getPosixFilePermissions(TarArchiveEntry entry) {
        int mode = entry.getMode();
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public static interface ExtractListener {
        public void file(Path var1);

        public void symlink(Path var1, String var2);
    }
}

