/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.archive;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.archive.ArchiveMetadata;
import io.digdag.core.repository.WorkflowDefinitionList;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableArchiveMetadata
extends ArchiveMetadata {
    private final WorkflowDefinitionList workflowList;
    private final Config defaultParams;

    private ImmutableArchiveMetadata(WorkflowDefinitionList workflowList, Config defaultParams) {
        this.workflowList = workflowList;
        this.defaultParams = defaultParams;
    }

    @Override
    @JsonProperty(value="workflows")
    public WorkflowDefinitionList getWorkflowList() {
        return this.workflowList;
    }

    @Override
    @JsonProperty(value="params")
    public Config getDefaultParams() {
        return this.defaultParams;
    }

    public final ImmutableArchiveMetadata withWorkflowList(WorkflowDefinitionList value) {
        if (this.workflowList == value) {
            return this;
        }
        WorkflowDefinitionList newValue = (WorkflowDefinitionList)Preconditions.checkNotNull((Object)value, (Object)"workflowList");
        return new ImmutableArchiveMetadata(newValue, this.defaultParams);
    }

    public final ImmutableArchiveMetadata withDefaultParams(Config value) {
        if (this.defaultParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"defaultParams");
        return new ImmutableArchiveMetadata(this.workflowList, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArchiveMetadata && this.equalTo((ImmutableArchiveMetadata)another);
    }

    private boolean equalTo(ImmutableArchiveMetadata another) {
        return this.workflowList.equals(another.workflowList) && this.defaultParams.equals((Object)another.defaultParams);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.workflowList.hashCode();
        h = h * 17 + this.defaultParams.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ArchiveMetadata").omitNullValues().add("workflowList", (Object)this.workflowList).add("defaultParams", (Object)this.defaultParams).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableArchiveMetadata fromJson(Json json) {
        Builder builder = ImmutableArchiveMetadata.builder();
        if (json.workflowList != null) {
            builder.workflowList(json.workflowList);
        }
        if (json.defaultParams != null) {
            builder.defaultParams(json.defaultParams);
        }
        return builder.build();
    }

    public static ImmutableArchiveMetadata copyOf(ArchiveMetadata instance) {
        if (instance instanceof ImmutableArchiveMetadata) {
            return (ImmutableArchiveMetadata)instance;
        }
        return ImmutableArchiveMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WORKFLOW_LIST = 1L;
        private static final long INIT_BIT_DEFAULT_PARAMS = 2L;
        private long initBits = 3L;
        @Nullable
        private WorkflowDefinitionList workflowList;
        @Nullable
        private Config defaultParams;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ArchiveMetadata instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.workflowList(instance.getWorkflowList());
            this.defaultParams(instance.getDefaultParams());
            return this;
        }

        @JsonProperty(value="workflows")
        @CanIgnoreReturnValue
        public final Builder workflowList(WorkflowDefinitionList workflowList) {
            this.workflowList = (WorkflowDefinitionList)Preconditions.checkNotNull((Object)workflowList, (Object)"workflowList");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="params")
        @CanIgnoreReturnValue
        public final Builder defaultParams(Config defaultParams) {
            this.defaultParams = (Config)Preconditions.checkNotNull((Object)defaultParams, (Object)"defaultParams");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableArchiveMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArchiveMetadata(this.workflowList, this.defaultParams);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("workflowList");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("defaultParams");
            }
            return "Cannot build ArchiveMetadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ArchiveMetadata {
        @Nullable
        WorkflowDefinitionList workflowList;
        @Nullable
        Config defaultParams;

        Json() {
        }

        @JsonProperty(value="workflows")
        public void setWorkflowList(WorkflowDefinitionList workflowList) {
            this.workflowList = workflowList;
        }

        @JsonProperty(value="params")
        public void setDefaultParams(Config defaultParams) {
            this.defaultParams = defaultParams;
        }

        @Override
        public WorkflowDefinitionList getWorkflowList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getDefaultParams() {
            throw new UnsupportedOperationException();
        }
    }
}

