/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.core.Environment;
import io.digdag.core.plugin.DynamicPluginLoader;
import io.digdag.core.plugin.PluginLoader;
import io.digdag.core.plugin.PluginSet;
import io.digdag.core.plugin.Spec;
import io.digdag.spi.CommandExecutor;
import io.digdag.spi.CommandLogger;
import io.digdag.spi.OperatorFactory;
import io.digdag.spi.OperatorProvider;
import io.digdag.spi.TaskRequest;
import io.digdag.spi.TemplateEngine;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OperatorRegistry {
    private final Map<String, OperatorFactory> map;
    private final DynamicPluginLoader<Map<String, OperatorFactory>> dynamicLoader;

    @Inject
    public OperatorRegistry(Set<OperatorFactory> injectedOperators, PluginSet.WithInjector systemPlugins, PluginLoader dynamicPluginLoader, DynamicOperatorPluginInjectionModule dynamicLoaderModule) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(OperatorRegistry.buildTypeMap(OperatorRegistry.loadOperatorFactories(systemPlugins)));
        builder.putAll(OperatorRegistry.buildTypeMap(injectedOperators));
        this.map = builder.build();
        this.dynamicLoader = DynamicPluginLoader.build(dynamicPluginLoader, dynamicLoaderModule, plugins -> OperatorRegistry.buildTypeMap(OperatorRegistry.loadOperatorFactories(plugins)), 10);
    }

    public OperatorFactory get(TaskRequest request, String type) {
        OperatorFactory factory = this.map.get(type);
        if (factory != null) {
            return factory;
        }
        return this.dynamicLoader.load(OperatorRegistry.getSpec(request)).get(type);
    }

    private static Spec getSpec(TaskRequest request) {
        Config params = request.getConfig().mergeDefault(request.getConfig().getNestedOrGetEmpty("plugin"));
        List repositories = params.getListOrEmpty("repositories", String.class);
        List dependencies = params.getListOrEmpty("dependencies", String.class);
        return Spec.of(repositories, dependencies);
    }

    private static List<OperatorFactory> loadOperatorFactories(PluginSet.WithInjector plugins) {
        return plugins.getServiceProviders(OperatorProvider.class).stream().flatMap(operatorProvider -> operatorProvider.get().stream()).collect(Collectors.toList());
    }

    private static Map<String, OperatorFactory> buildTypeMap(Collection<OperatorFactory> factories) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (OperatorFactory factory : factories) {
            builder.put((Object)factory.getType(), (Object)factory);
        }
        return builder.build();
    }

    public static class DynamicOperatorPluginInjectionModule
    implements Module {
        @Inject
        protected CommandExecutor commandExecutor;
        @Inject
        protected CommandLogger commandLogger;
        @Inject
        protected TemplateEngine templateEngine;
        @Inject
        protected ConfigFactory cf;
        @Inject
        protected Config systemConfig;
        @Inject
        @Environment
        protected Map<String, String> environment;

        public void configure(Binder binder) {
            binder.bind(CommandExecutor.class).toInstance((Object)this.commandExecutor);
            binder.bind(CommandLogger.class).toInstance((Object)this.commandLogger);
            binder.bind(TemplateEngine.class).toInstance((Object)this.templateEngine);
            binder.bind(ConfigFactory.class).toInstance((Object)this.cf);
            binder.bind(Config.class).toInstance((Object)this.systemConfig);
            binder.bind((TypeLiteral)new TypeLiteral<Map<String, String>>(){}).annotatedWith(Environment.class).toInstance(this.environment);
        }
    }
}

