/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.digdag.client.config.Config;
import io.digdag.core.agent.ConfigEvalEngine;
import io.digdag.metrics.DigdagTimed;
import io.digdag.spi.TemplateException;
import java.io.IOException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;

public class NashornJsEngine
implements ConfigEvalEngine.JsEngine {
    private final NashornScriptEngineFactory jsEngineFactory = new NashornScriptEngineFactory();

    public ConfigEvalEngine.JsEngine.Evaluator newEvaluator(Config params) {
        return (code, scopedParams, jsonMapper) -> this.invokeTemplate(this.newTemplateInvocable(params), code, scopedParams, jsonMapper);
    }

    @DigdagTimed(value="ceval_", category="agent", appendMethodName=true)
    protected Invocable newTemplateInvocable(Config params) {
        ScriptEngine scriptEngine = this.jsEngineFactory.getScriptEngine(new String[]{"--no-java", "--no-syntax-extensions", "-timezone=" + (String)params.get("timezone", String.class)});
        try {
            for (int i = 0; i < ConfigEvalEngine.LIBRARY_JS_CONTENTS.length; ++i) {
                scriptEngine.eval(ConfigEvalEngine.LIBRARY_JS_CONTENTS[i][1]);
            }
        }
        catch (ClassCastException | ScriptException ex) {
            throw new IllegalStateException("Unexpected script evaluation failure", ex);
        }
        return (Invocable)((Object)scriptEngine);
    }

    private String invokeTemplate(Invocable templateInvocable, String code, Config scopedParams, ObjectMapper jsonMapper) throws TemplateException {
        String paramsJson;
        try {
            paramsJson = jsonMapper.writeValueAsString((Object)scopedParams);
        }
        catch (IOException | RuntimeException ex) {
            throw new TemplateException("Failed to serialize parameters to JSON", (Throwable)ex);
        }
        try {
            return (String)templateInvocable.invokeFunction("template", code, paramsJson, false);
        }
        catch (ScriptException ex) {
            String message = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
            throw new TemplateException("Failed to evaluate a variable " + code + " (" + message + ")");
        }
        catch (NoSuchMethodException ex) {
            throw new TemplateException("Failed to evaluate JavaScript code: " + code, (Throwable)ex);
        }
    }
}

