/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.core.agent.AgentId;
import io.digdag.core.agent.TaskCallbackApi;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.log.LogServerManager;
import io.digdag.core.log.TaskLogger;
import io.digdag.core.queue.TaskQueueServerManager;
import io.digdag.core.repository.ProjectStore;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceLimitExceededException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.repository.StoredWorkflowDefinitionWithProject;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.session.StoredSessionAttempt;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.core.storage.ArchiveManager;
import io.digdag.core.workflow.AttemptBuilder;
import io.digdag.core.workflow.AttemptRequest;
import io.digdag.core.workflow.SessionAttemptConflictException;
import io.digdag.core.workflow.WorkflowExecutor;
import io.digdag.spi.LogFilePrefix;
import io.digdag.spi.OperatorContext;
import io.digdag.spi.ScheduleTime;
import io.digdag.spi.StorageFileNotFoundException;
import io.digdag.spi.StorageObject;
import io.digdag.spi.TaskQueueClient;
import io.digdag.spi.TaskRequest;
import io.digdag.spi.TaskResult;
import io.digdag.spi.ac.AccessController;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcessTaskCallbackApi
implements TaskCallbackApi {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProjectStoreManager pm;
    private final SessionStoreManager sm;
    private final ArchiveManager archiveManager;
    private final LogServerManager lm;
    private final AttemptBuilder attemptBuilder;
    private final AgentId agentId;
    private final WorkflowExecutor exec;
    private final TransactionManager tm;
    private final TaskQueueClient queueClient;
    private final AccessController ac;

    @Inject
    public InProcessTaskCallbackApi(ProjectStoreManager pm, SessionStoreManager sm, ArchiveManager archiveManager, TaskQueueServerManager qm, LogServerManager lm, AgentId agentId, AttemptBuilder attemptBuilder, WorkflowExecutor exec, TransactionManager tm, AccessController ac) {
        this.pm = pm;
        this.sm = sm;
        this.archiveManager = archiveManager;
        this.lm = lm;
        this.agentId = agentId;
        this.attemptBuilder = attemptBuilder;
        this.exec = exec;
        this.tm = tm;
        this.queueClient = qm.getInProcessTaskQueueClient();
        this.ac = ac;
    }

    @Override
    public TaskLogger newTaskLogger(TaskRequest request) {
        LogFilePrefix prefix;
        long attemptId = request.getAttemptId();
        String taskName = request.getTaskName();
        try {
            StoredSessionAttemptWithSession attempt = this.tm.begin(() -> this.sm.getSessionStore(request.getSiteId()).getAttemptById(attemptId), ResourceNotFoundException.class);
            prefix = LogServerManager.logFilePrefixFromSessionAttempt(attempt);
        }
        catch (ResourceNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return this.lm.newInProcessTaskLogger(this.agentId, prefix, taskName);
    }

    @Override
    public void taskHeartbeat(int siteId, List<TaskRequest> requests, AgentId agentId, int lockSeconds) {
        List lockedIds = requests.stream().collect(Collectors.mapping(TaskRequest::getLockId, Collectors.toList()));
        this.tm.begin(() -> this.queueClient.taskHeartbeat(siteId, lockedIds, agentId.toString(), lockSeconds));
    }

    @Override
    public Optional<StorageObject> openArchive(TaskRequest request) {
        if (!request.getRevision().isPresent()) {
            return Optional.absent();
        }
        String revision = (String)request.getRevision().get();
        try {
            return this.tm.begin(() -> this.archiveManager.openArchive(this.pm.getProjectStore(request.getSiteId()), request.getProjectId(), revision), ResourceNotFoundException.class, StorageFileNotFoundException.class);
        }
        catch (ResourceNotFoundException ex) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Archive data for project id=%d revision='%s' is not found in database", request.getProjectId(), request.getRevision().or((Object)"")), ex);
        }
        catch (StorageFileNotFoundException ex) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Archive file for project id=%d revision='%s' is not found", request.getProjectId(), request.getRevision().or((Object)"")), ex);
        }
    }

    @Override
    public void taskSucceeded(TaskRequest request, AgentId agentId, TaskResult result) {
        this.tm.begin(() -> this.exec.taskSucceeded(request.getSiteId(), request.getTaskId(), request.getLockId(), agentId, result));
    }

    @Override
    public void taskFailed(TaskRequest request, AgentId agentId, Config error) {
        this.tm.begin(() -> this.exec.taskFailed(request.getSiteId(), request.getTaskId(), request.getLockId(), agentId, error));
    }

    @Override
    public void retryTask(TaskRequest request, AgentId agentId, int retryInterval, Config retryStateParams, Optional<Config> error) {
        this.tm.begin(() -> this.exec.retryTask(request.getSiteId(), request.getTaskId(), request.getLockId(), agentId, retryInterval, retryStateParams, error));
    }

    @Override
    public StoredSessionAttempt startSession(OperatorContext context, int siteId, TaskCallbackApi.ProjectIdentifier projectIdentifier, String workflowName, Instant instant, Optional<String> retryAttemptName, Config overrideParams) throws ResourceNotFoundException, ResourceLimitExceededException, SessionAttemptConflictException {
        return this.tm.begin(() -> {
            ProjectStore projectStore = this.pm.getProjectStore(siteId);
            StoredProject proj = projectIdentifier.byId() ? projectStore.getProjectById(projectIdentifier.getId()) : projectStore.getProjectByName(projectIdentifier.getName());
            StoredWorkflowDefinitionWithProject def = projectStore.getLatestWorkflowDefinitionByName(proj.getId(), workflowName);
            AttemptRequest ar = this.attemptBuilder.buildFromStoredWorkflow(def, overrideParams, ScheduleTime.runNow((Instant)instant), retryAttemptName, (Optional<Long>)Optional.absent(), (List<Long>)ImmutableList.of(), (Optional<Instant>)Optional.absent());
            StoredSessionAttemptWithSession attempt = this.exec.submitWorkflow(siteId, ar, def);
            return attempt;
        }, ResourceNotFoundException.class, ResourceLimitExceededException.class, SessionAttemptConflictException.class);
    }
}

