/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.digdag.client.config.Config;
import io.digdag.core.agent.ConfigEvalEngine;
import io.digdag.spi.TemplateException;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Optional;
import java.util.function.Supplier;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraalJsEngine
implements ConfigEvalEngine.JsEngine {
    private final Source[] libraryJsSources;
    private final boolean extendedSyntax;
    private final Engine sharedEngine;
    private static final HostAccess hostAccess = HostAccess.newBuilder().allowPublicAccess(true).build();

    public GraalJsEngine(boolean extendedSyntax) {
        this.extendedSyntax = extendedSyntax;
        try {
            this.libraryJsSources = new Source[ConfigEvalEngine.LIBRARY_JS_CONTENTS.length];
            for (int i = 0; i < ConfigEvalEngine.LIBRARY_JS_CONTENTS.length; ++i) {
                this.libraryJsSources[i] = Source.newBuilder((String)"js", (CharSequence)ConfigEvalEngine.LIBRARY_JS_CONTENTS[i][1], (String)ConfigEvalEngine.LIBRARY_JS_CONTENTS[i][0]).build();
            }
            this.sharedEngine = GraalJsEngine.createEngine();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ConfigEvalEngine.JsEngine.Evaluator newEvaluator(Config params) {
        GraalEvaluatorWithRetry evaluator = new GraalEvaluatorWithRetry(params, this.sharedEngine, this.extendedSyntax, this.libraryJsSources);
        return evaluator;
    }

    private static Engine createEngine() {
        return Engine.newBuilder().allowExperimentalOptions(true).option("js.nashorn-compat", "true").option("js.ecmascript-version", "5").option("js.syntax-extensions", "false").option("js.console", "false").option("js.load", "true").option("js.load-from-url", "false").build();
    }

    private static Supplier<Context> createContextSupplier(Optional<Engine> sharedEngine, Config params, Source[] libraryJsSources) {
        Engine engine = sharedEngine.isPresent() ? sharedEngine.get() : GraalJsEngine.createEngine();
        return () -> {
            Context.Builder contextBuilder = Context.newBuilder((String[])new String[0]).engine(engine).allowAllAccess(false).allowHostAccess(hostAccess).allowHostClassLookup(className -> className.matches("java\\.lang\\.String")).timeZone(GraalJsEngine.getWorkflowZoneId(params));
            Context context = contextBuilder.build();
            try {
                for (Source lib : libraryJsSources) {
                    context.eval(lib);
                }
            }
            catch (RuntimeException ex) {
                context.close();
                throw ex;
            }
            return context;
        };
    }

    private static ZoneId getWorkflowZoneId(Config params) {
        return ZoneId.of((String)params.get("timezone", String.class));
    }

    private static class GraalEvaluator
    implements ConfigEvalEngine.JsEngine.Evaluator {
        private final Supplier<Context> contextSupplier;
        private final boolean extendedSyntax;
        private static Logger logger = LoggerFactory.getLogger(GraalEvaluator.class);

        GraalEvaluator(Supplier<Context> contextSupplier, boolean extendedSyntax) {
            this.contextSupplier = contextSupplier;
            this.extendedSyntax = extendedSyntax;
        }

        @Override
        public String evaluate(String code, Config scopedParams, ObjectMapper jsonMapper) throws TemplateException {
            Throwable throwable = null;
            try (Context context = this.contextSupplier.get();){
                String paramsJson;
                try {
                    paramsJson = jsonMapper.writeValueAsString((Object)scopedParams);
                }
                catch (IOException | RuntimeException ex) {
                    throw new TemplateException("Failed to serialize parameters to JSON", (Throwable)ex);
                }
                try {
                    Value result = context.getBindings("js").getMember("template").execute(new Object[]{code, paramsJson, this.extendedSyntax});
                    String string = result.asString();
                    return string;
                }
                catch (PolyglotException ex) {
                    try {
                        logger.debug("GraalJS threw an exception: {} {}", (Object)ex.toString(), (Object)ConfigEvalEngine.stackTraceAsString(ex));
                        String message = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
                        throw new TemplateException("Failed to evaluate a variable " + code + " (" + message + ")");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
    }

    private static class GraalEvaluatorWithRetry
    implements ConfigEvalEngine.JsEngine.Evaluator {
        private static Logger logger = LoggerFactory.getLogger(GraalEvaluatorWithRetry.class);
        private final Config params;
        private final Engine sharedEngine;
        private final boolean extendedSyntax;
        private final Source[] libraryJsSources;

        public GraalEvaluatorWithRetry(Config params, Engine sharedEngine, boolean extendedSyntax, Source[] libraryJsSources) {
            this.params = params;
            this.sharedEngine = sharedEngine;
            this.extendedSyntax = extendedSyntax;
            this.libraryJsSources = libraryJsSources;
        }

        @Override
        public String evaluate(String code, Config scopedParams, ObjectMapper jsonMapper) throws TemplateException {
            try {
                return new GraalEvaluator(GraalJsEngine.createContextSupplier(Optional.empty(), this.params, this.libraryJsSources), this.extendedSyntax).evaluate(code, scopedParams, jsonMapper);
            }
            catch (IllegalStateException e) {
                if (e.getMessage().equals("Engine is already closed.")) {
                    logger.debug("Engine is already closed. Retry with new engine");
                    return new GraalEvaluator(GraalJsEngine.createContextSupplier(Optional.empty(), this.params, this.libraryJsSources), this.extendedSyntax).evaluate(code, scopedParams, jsonMapper);
                }
                throw e;
            }
        }
    }
}

