/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.digdag.client.config.Config;
import io.digdag.core.agent.ImmutableAgentConfig;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableAgentConfig.class)
@JsonDeserialize(as=ImmutableAgentConfig.class)
@Value.Immutable
public interface AgentConfig {
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 60;
    public static final int DEFAULT_LOCK_RETENTION_TIME = 300;
    public static final int DEFAULT_MAX_TASK_THREADS = 0;

    public boolean getEnabled();

    public int getHeartbeatInterval();

    public int getLockRetentionTime();

    public int getMaxThreads();

    public static ImmutableAgentConfig.Builder defaultBuilder() {
        return ImmutableAgentConfig.builder().enabled(true).heartbeatInterval(60).lockRetentionTime(300).maxThreads(0);
    }

    public static AgentConfig convertFrom(Config config) {
        return AgentConfig.defaultBuilder().enabled((Boolean)config.get("agent.enabled", Boolean.TYPE, (Object)true)).heartbeatInterval((Integer)config.get("agent.heartbeat-interval", Integer.TYPE, (Object)60)).lockRetentionTime((Integer)config.get("agent.lock-retention-time", Integer.TYPE, (Object)300)).maxThreads((Integer)config.get("agent.max-task-threads", Integer.TYPE, (Object)0)).build();
    }
}

