/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core;

import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class TempFileManager {
    private final Path dir;

    @Inject
    public TempFileManager() {
        try {
            this.dir = Files.createTempDirectory("temp", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new AllocationException(ex);
        }
    }

    public TempFileManager(Path dir) {
        this.dir = dir;
    }

    public TempFile createTempFile() {
        return this.createTempFile("tmp");
    }

    public TempFile createTempFile(String suffix) {
        return this.createTempFile(Thread.currentThread().getName() + "_", suffix);
    }

    public TempFile createTempFile(String prefix, String suffix) {
        try {
            Files.createDirectories(this.dir, new FileAttribute[0]);
            return new TempFile(Files.createTempFile(this.dir, prefix, suffix, new FileAttribute[0]));
        }
        catch (IOException ex) {
            throw new AllocationException(ex);
        }
    }

    public TempFile createTempFile(String subdirName, String prefix, String suffix) {
        try {
            Path subdir = this.dir.resolve(subdirName);
            Files.createDirectories(subdir, new FileAttribute[0]);
            return new TempFile(Files.createTempFile(subdir, prefix, suffix, new FileAttribute[0]));
        }
        catch (IOException ex) {
            throw new AllocationException(ex);
        }
    }

    public TempDir createTempDir() {
        return this.createTempDir(Thread.currentThread().getName() + "_");
    }

    public TempDir createTempDir(String prefix) {
        try {
            Files.createDirectories(this.dir, new FileAttribute[0]);
            return new TempDir(Files.createTempDirectory(this.dir, prefix + "_", new FileAttribute[0]));
        }
        catch (IOException ex) {
            throw new AllocationException(ex);
        }
    }

    public TempDir createTempDir(String subdirName, String prefix) {
        try {
            Path subdir = this.dir.resolve(subdirName);
            Files.createDirectories(subdir, new FileAttribute[0]);
            return new TempDir(Files.createTempDirectory(subdir, prefix + "_", new FileAttribute[0]));
        }
        catch (IOException ex) {
            throw new AllocationException(ex);
        }
    }

    public static void deleteFilesIfExistsRecursively(Path dir) {
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        Files.deleteIfExists(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    try {
                        Files.deleteIfExists(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class TempDir
    implements Closeable {
        private final Path path;

        TempDir(Path path) {
            this.path = path;
        }

        public Path get() {
            return this.path;
        }

        public Path child(String child) {
            return this.path.resolve(child);
        }

        @Override
        public void close() {
            TempFileManager.deleteFilesIfExistsRecursively(this.path);
        }
    }

    public static class TempFile
    implements Closeable {
        private final Path path;

        TempFile(Path path) {
            this.path = path;
        }

        public Path get() {
            return this.path;
        }

        @Override
        public void close() {
            TempFileManager.deleteFilesIfExistsRecursively(this.path);
        }
    }

    public static class AllocationException
    extends RuntimeException {
        public AllocationException(IOException cause) {
            super(cause);
        }

        @Override
        public IOException getCause() {
            return (IOException)super.getCause();
        }
    }
}

