/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.digdag.client.config.ConfigFactory;
import io.digdag.core.archive.ArchiveMetadata;
import io.digdag.core.repository.ArchiveType;
import io.digdag.core.repository.Project;
import io.digdag.core.repository.ProjectControl;
import io.digdag.core.repository.ProjectStore;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.Revision;
import io.digdag.core.repository.StoredRevision;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.repository.WorkflowDefinitionList;
import io.digdag.core.schedule.SchedulerManager;
import io.digdag.core.session.SessionStore;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.core.workflow.AttemptBuilder;
import io.digdag.core.workflow.AttemptLimitExceededException;
import io.digdag.core.workflow.AttemptRequest;
import io.digdag.core.workflow.SessionAttemptConflictException;
import io.digdag.core.workflow.TaskLimitExceededException;
import io.digdag.core.workflow.WorkflowCompiler;
import io.digdag.core.workflow.WorkflowExecutor;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSite {
    private static Logger logger = LoggerFactory.getLogger(LocalSite.class);
    private final WorkflowCompiler compiler;
    private final ProjectStore projectStore;
    private final SessionStore sessionStore;
    private final AttemptBuilder attemptBuilder;
    private final WorkflowExecutor exec;
    private final SchedulerManager srm;
    private final ConfigFactory cf;

    @Inject
    public LocalSite(WorkflowCompiler compiler, ProjectStoreManager projectStoreManager, SessionStoreManager sessionStoreManager, AttemptBuilder attemptBuilder, WorkflowExecutor exec, SchedulerManager srm, ConfigFactory cf) {
        this.compiler = compiler;
        this.projectStore = projectStoreManager.getProjectStore(0);
        this.sessionStore = sessionStoreManager.getSessionStore(0);
        this.attemptBuilder = attemptBuilder;
        this.exec = exec;
        this.srm = srm;
        this.cf = cf;
    }

    public AttemptBuilder getAttemptBuilder() {
        return this.attemptBuilder;
    }

    public ProjectStore getProjectStore() {
        return this.projectStore;
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    private StoreWorkflowResult storeLocalWorkflowsImpl(String projectName, Revision revision, WorkflowDefinitionList defs, Optional<Instant> currentTimeToSchedule) throws ResourceConflictException {
        defs.get().stream().forEach(workflowSource -> this.compiler.compile(workflowSource.getName(), workflowSource.getConfig()));
        return this.projectStore.putAndLockProject(Project.of(projectName), (store, storedProject) -> {
            ProjectControl lockedProj = new ProjectControl(store, storedProject);
            StoredRevision rev = lockedProj.insertRevision(revision);
            List<StoredWorkflowDefinition> storedDefs = currentTimeToSchedule.isPresent() ? lockedProj.insertWorkflowDefinitions(rev, defs.get(), this.srm, (Instant)currentTimeToSchedule.get()) : lockedProj.insertWorkflowDefinitionsWithoutSchedules(rev, defs.get());
            return new StoreWorkflowResult(rev, storedDefs);
        });
    }

    public StoreWorkflowResult storeLocalWorkflowsWithoutSchedule(String projectName, String revisionName, ArchiveMetadata archive) throws ResourceConflictException {
        return this.storeLocalWorkflowsImpl(projectName, Revision.builderFromArchive(revisionName, archive, this.cf.create()).archiveType(ArchiveType.NONE).build(), archive.getWorkflowList(), (Optional<Instant>)Optional.absent());
    }

    public StoreWorkflowResult storeLocalWorkflows(String projectName, String revisionName, ArchiveMetadata archive, Instant currentTimeForSchedule) throws ResourceConflictException, ResourceNotFoundException {
        return this.storeLocalWorkflowsImpl(projectName, Revision.builderFromArchive(revisionName, archive, this.cf.create()).archiveType(ArchiveType.NONE).build(), archive.getWorkflowList(), (Optional<Instant>)Optional.of((Object)currentTimeForSchedule));
    }

    public StoredSessionAttemptWithSession submitWorkflow(AttemptRequest ar, WorkflowDefinition def) throws ResourceNotFoundException, SessionAttemptConflictException, AttemptLimitExceededException, TaskLimitExceededException {
        return this.exec.submitWorkflow(0, ar, def);
    }

    public void run() throws InterruptedException {
        this.exec.run();
    }

    public StoredSessionAttemptWithSession runUntilDone(long attemptId) throws ResourceNotFoundException, InterruptedException {
        return this.exec.runUntilDone(attemptId);
    }

    public void runUntilAllDone() throws InterruptedException {
        this.exec.runUntilAllDone();
    }

    public boolean killAttempt(long attemptId) throws ResourceNotFoundException {
        return this.exec.killAttemptById(0, attemptId);
    }

    public static class StoreWorkflowResult {
        private final StoredRevision revision;
        private final List<StoredWorkflowDefinition> workflowDefinitions;

        public StoreWorkflowResult(StoredRevision revision, List<StoredWorkflowDefinition> workflowDefinitions) {
            this.revision = revision;
            this.workflowDefinitions = workflowDefinitions;
        }

        public StoredRevision getRevision() {
            return this.revision;
        }

        public List<StoredWorkflowDefinition> getWorkflowDefinitions() {
            return this.workflowDefinitions;
        }
    }
}

