/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.google.common.base.Optional;
import io.digdag.core.Limits;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ProjectStore;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.session.Session;
import io.digdag.core.session.SessionAttempt;
import io.digdag.core.session.SessionStore;
import io.digdag.core.session.SessionTransaction;
import io.digdag.core.session.StoredSessionAttempt;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.core.workflow.AttemptLimitExceededException;
import io.digdag.core.workflow.AttemptRequest;
import io.digdag.core.workflow.SessionAttemptConflictException;
import io.digdag.core.workflow.TaskConfig;
import java.time.Instant;
import java.util.Locale;

public class WorkflowSubmitter {
    private final int siteId;
    private final SessionTransaction transaction;
    private final ProjectStore projectStore;
    private final SessionStore sessionStore;
    private final TransactionManager transactionManager;
    private final Limits limits;

    WorkflowSubmitter(int siteId, SessionTransaction transaction, ProjectStore projectStore, SessionStore sessionStore, TransactionManager transactionManager, Limits limits) {
        this.siteId = siteId;
        this.transaction = transaction;
        this.projectStore = projectStore;
        this.sessionStore = sessionStore;
        this.transactionManager = transactionManager;
        this.limits = limits;
    }

    public StoredSessionAttemptWithSession submitDelayedAttempt(AttemptRequest ar, Optional<Long> dependentSessionId) throws ResourceNotFoundException, AttemptLimitExceededException, SessionAttemptConflictException {
        int projId = ar.getStored().getProjectId();
        Session session = Session.of(projId, ar.getWorkflowName(), ar.getSessionTime());
        SessionAttempt attempt = SessionAttempt.of(ar.getRetryAttemptName(), ar.getSessionParams(), ar.getTimeZone(), (Optional<Long>)Optional.of((Object)ar.getStored().getWorkflowDefinitionId()));
        TaskConfig.validateAttempt(attempt);
        try {
            long activeAttempts = this.transaction.getActiveAttemptCount();
            if (activeAttempts + 1L > this.limits.maxAttempts()) {
                throw new AttemptLimitExceededException("Too many attempts running. Limit: " + this.limits.maxAttempts() + ", Current: " + activeAttempts);
            }
            return this.transaction.putAndLockSession(session, (store, storedSession) -> {
                StoredProject proj = this.projectStore.getProjectById(projId);
                if (proj.getDeletedAt().isPresent()) {
                    throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "Project id={} name={} is already deleted", proj.getId(), proj.getName()));
                }
                StoredSessionAttempt storedAttempt = store.insertDelayedAttempt(storedSession.getId(), projId, attempt, dependentSessionId);
                return StoredSessionAttemptWithSession.of(this.siteId, storedSession, storedAttempt);
            });
        }
        catch (ResourceConflictException sessionAlreadyExists) {
            this.transactionManager.reset();
            StoredSessionAttemptWithSession conflicted = ar.getRetryAttemptName().isPresent() ? this.sessionStore.getAttemptByName(session.getProjectId(), session.getWorkflowName(), session.getSessionTime(), (String)ar.getRetryAttemptName().get()) : this.sessionStore.getLastAttemptByName(session.getProjectId(), session.getWorkflowName(), session.getSessionTime());
            throw new SessionAttemptConflictException("Session already exists", sessionAlreadyExists, conflicted);
        }
    }

    public Optional<Instant> getLastExecutedSessionTime(int projectId, String workflowName, Instant beforeThisSessionTime) {
        return this.transaction.getLastExecutedSessionTime(projectId, workflowName, beforeThisSessionTime);
    }
}

