/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.core.Limits;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.session.ImmutableTask;
import io.digdag.core.session.ResumingTask;
import io.digdag.core.session.SessionStore;
import io.digdag.core.session.StoredTask;
import io.digdag.core.session.Task;
import io.digdag.core.session.TaskControlStore;
import io.digdag.core.session.TaskStateCode;
import io.digdag.core.session.TaskStateFlags;
import io.digdag.core.workflow.IllegalResumeException;
import io.digdag.core.workflow.TaskConfig;
import io.digdag.core.workflow.TaskLimitExceededException;
import io.digdag.core.workflow.WorkflowTask;
import io.digdag.core.workflow.WorkflowTaskList;
import io.digdag.spi.TaskResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TaskControl {
    private final TaskControlStore store;
    private final StoredTask task;
    private TaskStateCode state;
    private final Limits limits;

    public TaskControl(TaskControlStore store, StoredTask task, Limits limits) {
        this.store = store;
        this.task = task;
        this.state = task.getState();
        this.limits = limits;
    }

    public StoredTask get() {
        return this.task;
    }

    public long getId() {
        return this.task.getId();
    }

    public TaskStateCode getState() {
        return this.state;
    }

    public static long addInitialTasksExceptingRootTask(TaskControlStore store, long attemptId, long rootTaskId, WorkflowTaskList tasks, List<ResumingTask> resumingTasks, Limits limits) throws TaskLimitExceededException {
        TaskControl.checkTaskLimit(store, attemptId, tasks, limits);
        long taskId = TaskControl.addTasks(store, attemptId, rootTaskId, tasks, (List<Long>)ImmutableList.of(), false, true, true, resumingTasks);
        TaskControl.addResumingTasks(store, attemptId, resumingTasks);
        return taskId;
    }

    public long addGeneratedSubtasks(WorkflowTaskList tasks, List<Long> rootUpstreamIds, boolean cancelSiblings, boolean isInitialTask) throws TaskLimitExceededException {
        TaskControl.checkTaskLimit(this.store, this.task.getAttemptId(), tasks, this.limits);
        return TaskControl.addTasks(this.store, this.task.getAttemptId(), this.task.getId(), tasks, rootUpstreamIds, cancelSiblings, false, isInitialTask, this.collectResumingTasks(this.task.getAttemptId(), tasks));
    }

    public long addGeneratedSubtasks(WorkflowTaskList tasks, List<Long> rootUpstreamIds, boolean cancelSiblings) throws TaskLimitExceededException {
        return this.addGeneratedSubtasks(tasks, rootUpstreamIds, cancelSiblings, false);
    }

    public long addGeneratedSubtasksWithoutLimit(WorkflowTaskList tasks, List<Long> rootUpstreamIds, boolean cancelSiblings) {
        return TaskControl.addTasks(this.store, this.task.getAttemptId(), this.task.getId(), tasks, rootUpstreamIds, cancelSiblings, false, false, this.collectResumingTasks(this.task.getAttemptId(), tasks));
    }

    private static void checkTaskLimit(TaskControlStore store, long attemptId, WorkflowTaskList tasks, Limits limits) throws TaskLimitExceededException {
        long taskCount = store.getTaskCountOfAttempt(attemptId);
        if (taskCount + (long)tasks.size() > limits.maxWorkflowTasks()) {
            throw new TaskLimitExceededException("Too many tasks. Limit: " + limits.maxWorkflowTasks() + ", Current: " + taskCount + ", Adding: " + tasks.size());
        }
    }

    private static long addTasks(TaskControlStore store, long attemptId, long parentTaskId, WorkflowTaskList tasks, List<Long> rootUpstreamIds, boolean cancelSiblings, boolean firstTaskIsRootStoredParentTask, boolean isInitialTask, List<ResumingTask> resumingTasks) {
        ArrayList<Long> indexToId = new ArrayList<Long>();
        Long rootTaskId = firstTaskIsRootStoredParentTask ? Long.valueOf(parentTaskId) : null;
        Map<String, ResumingTask> resumingTaskMap = resumingTasks.stream().collect(Collectors.toMap(t -> t.getFullName(), t -> t));
        boolean firstTask = true;
        for (WorkflowTask wt : tasks) {
            long id;
            if (firstTask && firstTaskIsRootStoredParentTask) {
                indexToId.add(rootTaskId);
                firstTask = false;
                continue;
            }
            if (!firstTask || cancelSiblings) {
                // empty if block
            }
            long parentId = (Long)wt.getParentIndex().transform(index -> (Long)indexToId.get((int)index)).or((Object)parentTaskId);
            if (resumingTaskMap.containsKey(wt.getFullName())) {
                id = store.addResumedSubtask(attemptId, parentId, wt.getTaskType(), TaskStateCode.SUCCESS, isInitialTask ? TaskStateFlags.empty().withInitialTask() : TaskStateFlags.empty(), resumingTaskMap.get(wt.getFullName()));
            } else {
                ImmutableTask task = Task.taskBuilder().parentId((Optional<Long>)Optional.of((Object)parentId)).fullName(wt.getFullName()).config(TaskConfig.validate(wt.getConfig())).taskType(wt.getTaskType()).state(TaskStateCode.BLOCKED).stateFlags(isInitialTask ? TaskStateFlags.empty().withInitialTask() : TaskStateFlags.empty()).build();
                id = store.addSubtask(attemptId, task);
            }
            indexToId.add(id);
            if (!wt.getUpstreamIndexes().isEmpty()) {
                store.addDependencies(id, wt.getUpstreamIndexes().stream().map(index -> (Long)indexToId.get((int)index)).collect(Collectors.toList()));
            }
            if (firstTask) {
                store.addDependencies(id, rootUpstreamIds);
                rootTaskId = id;
            }
            firstTask = false;
        }
        return rootTaskId;
    }

    private static void addResumingTasks(TaskControlStore store, long attemptId, List<ResumingTask> resumingTasks) {
        List filtered = resumingTasks.stream().filter(task -> task.getFullName().contains("^")).collect(Collectors.toList());
        if (!filtered.isEmpty()) {
            store.addResumingTasks(attemptId, resumingTasks);
        }
    }

    private List<ResumingTask> collectResumingTasks(long attemptId, WorkflowTaskList tasks) {
        if (tasks.isEmpty()) {
            return ImmutableList.of();
        }
        String commonPrefix = tasks.stream().map(t -> t.getFullName()).reduce(tasks.get(0).getFullName(), (name1, name2) -> Strings.commonPrefix((CharSequence)name1, (CharSequence)name2));
        return this.store.getResumingTasksByNamePrefix(attemptId, commonPrefix);
    }

    static List<ResumingTask> buildResumingTaskMap(SessionStore store, long attemptId, List<Long> resumingTaskIds) throws ResourceNotFoundException {
        HashSet<Long> idSet = new HashSet<Long>(resumingTaskIds);
        List<ResumingTask> resumingTasks = store.getTasksOfAttempt(attemptId).stream().filter(archived -> {
            if (idSet.remove(archived.getId())) {
                if (archived.getState() != TaskStateCode.SUCCESS) {
                    throw new IllegalResumeException("Resuming non-successful tasks is not allowed: task_id=" + archived.getId());
                }
                return true;
            }
            return false;
        }).map(archived -> ResumingTask.of(archived)).collect(Collectors.toList());
        if (!idSet.isEmpty()) {
            throw new ResourceNotFoundException("Resuming tasks are not the members of resuming attempt: id list=" + idSet);
        }
        return resumingTasks;
    }

    public boolean isAnyProgressibleChild() {
        return this.store.isAnyProgressibleChild(this.getId());
    }

    public boolean isAnyErrorChild() {
        return this.store.isAnyErrorChild(this.getId());
    }

    public List<Config> collectChildrenErrors() {
        return this.store.collectChildrenErrors(this.getId());
    }

    public boolean setReadyToRunning() {
        if (this.store.setStartedState(this.getId(), TaskStateCode.READY, TaskStateCode.RUNNING)) {
            this.state = TaskStateCode.RUNNING;
            return true;
        }
        return false;
    }

    public boolean setToCanceled() {
        if (this.store.setDoneState(this.getId(), this.state, TaskStateCode.CANCELED)) {
            this.state = TaskStateCode.CANCELED;
            return true;
        }
        return false;
    }

    public boolean setPlannedToSuccess() {
        if (this.store.setDoneState(this.getId(), TaskStateCode.PLANNED, TaskStateCode.SUCCESS)) {
            this.state = TaskStateCode.SUCCESS;
            return true;
        }
        return false;
    }

    public boolean setPlannedToError() {
        if (this.store.setDoneState(this.getId(), TaskStateCode.PLANNED, TaskStateCode.ERROR)) {
            this.state = TaskStateCode.ERROR;
            return true;
        }
        return false;
    }

    public boolean setRunningToShortCircuitError(Config error) {
        if (this.store.setErrorStateShortCircuit(this.getId(), TaskStateCode.RUNNING, TaskStateCode.ERROR, error)) {
            this.state = TaskStateCode.ERROR;
            return true;
        }
        return false;
    }

    public boolean setPlannedToPlannedWithDelayedGroupError() {
        if (this.store.setPlannedStateWithDelayedError(this.getId(), TaskStateCode.PLANNED, TaskStateCode.PLANNED, 4, (Optional<Config>)Optional.absent())) {
            this.state = TaskStateCode.PLANNED;
            return true;
        }
        return false;
    }

    public boolean setPlannedToGroupError() {
        if (this.store.setDoneState(this.getId(), TaskStateCode.PLANNED, TaskStateCode.GROUP_ERROR)) {
            this.state = TaskStateCode.GROUP_ERROR;
            return true;
        }
        return false;
    }

    public boolean setPlannedToGroupRetryWaiting(Config stateParams, int retryInterval) {
        if (this.store.setRetryWaitingState(this.getId(), TaskStateCode.PLANNED, TaskStateCode.GROUP_RETRY_WAITING, retryInterval, stateParams, (Optional<Config>)Optional.absent())) {
            this.state = TaskStateCode.GROUP_RETRY_WAITING;
            return true;
        }
        return false;
    }

    public boolean copyInitialTasksForRetry(String parentFullName, List<Long> recursiveChildrenIdList) {
        return this.store.copyInitialTasksForRetry(recursiveChildrenIdList, (Optional<String>)Optional.of((Object)parentFullName));
    }

    public boolean setGroupRetryReadyToPlanned() {
        if (this.store.setPlannedStateSuccessful(this.getId(), TaskStateCode.READY, TaskStateCode.PLANNED, TaskResult.empty((ConfigFactory)this.task.getStateParams().getFactory()))) {
            this.state = TaskStateCode.PLANNED;
            return true;
        }
        return false;
    }

    public boolean setRunningToPlannedSuccessful(TaskResult result) {
        if (this.store.setPlannedStateSuccessful(this.getId(), TaskStateCode.RUNNING, TaskStateCode.PLANNED, result)) {
            this.state = TaskStateCode.PLANNED;
            return true;
        }
        return false;
    }

    public boolean setRunningToShortCircuitSuccess(TaskResult result) {
        if (this.store.setSuccessStateShortCircuit(this.getId(), TaskStateCode.RUNNING, TaskStateCode.SUCCESS, result)) {
            this.state = TaskStateCode.SUCCESS;
            return true;
        }
        return false;
    }

    public boolean setRunningToPlannedWithDelayedError(Config error) {
        if (this.store.setPlannedStateWithDelayedError(this.getId(), TaskStateCode.RUNNING, TaskStateCode.PLANNED, 2, (Optional<Config>)Optional.of((Object)error))) {
            this.state = TaskStateCode.PLANNED;
            return true;
        }
        return false;
    }

    public boolean setRunningToRetryWaiting(Config stateParams, int retryInterval, Config error) {
        if (this.store.setRetryWaitingState(this.getId(), TaskStateCode.RUNNING, TaskStateCode.RETRY_WAITING, retryInterval, stateParams, (Optional<Config>)Optional.of((Object)error))) {
            this.state = TaskStateCode.RETRY_WAITING;
            return true;
        }
        return false;
    }

    public boolean setRunningToRetryWaiting(Config stateParams, int retryInterval) {
        if (this.store.setRetryWaitingState(this.getId(), TaskStateCode.RUNNING, TaskStateCode.RETRY_WAITING, retryInterval, stateParams, (Optional<Config>)Optional.absent())) {
            this.state = TaskStateCode.RETRY_WAITING;
            return true;
        }
        return false;
    }
}

