/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class SlaCalculator {
    @Inject
    public SlaCalculator() {
    }

    public Instant getTriggerTime(Config slaConfig, Instant currentTime, ZoneId timeZone) {
        TriggerCalculator calc = this.getCalculator(slaConfig);
        return calc.calculateTime(currentTime, timeZone);
    }

    private TriggerCalculator getCalculator(Config slaConfig) {
        Integer second;
        Integer minute;
        Integer hour;
        Optional time = slaConfig.getOptional("time", String.class);
        Optional duration = slaConfig.getOptional("duration", String.class);
        if (time.isPresent() == duration.isPresent()) {
            throw new ConfigException("SLA must be specified using either the 'time' or 'duration' option");
        }
        String option = time.isPresent() ? "time" : "duration";
        String value = time.isPresent() ? (String)time.get() : (String)duration.get();
        String[] fragments = value.split(":");
        try {
            switch (fragments.length) {
                case 3: {
                    hour = Integer.parseInt(fragments[0]);
                    minute = Integer.parseInt(fragments[1]);
                    second = Integer.parseInt(fragments[2]);
                    break;
                }
                case 2: {
                    hour = Integer.parseInt(fragments[0]);
                    minute = Integer.parseInt(fragments[1]);
                    second = 0;
                    break;
                }
                default: {
                    throw new ConfigException("SLA " + option + " option needs to be HH:MM or HH:MM:SS format: " + time);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new ConfigException("SLA " + option + " option needs to be HH:MM or HH:MM:SS format: " + time);
        }
        if (time.isPresent()) {
            return new TimeCalculator(hour, minute, second);
        }
        return new DurationCalculator(hour, minute, second);
    }

    private static class DurationCalculator
    implements TriggerCalculator {
        private final Integer hour;
        private final Integer minute;
        private final Integer second;

        private DurationCalculator(Integer hour, Integer minute, Integer second) {
            this.hour = hour;
            this.minute = minute;
            this.second = second;
        }

        @Override
        public Instant calculateTime(Instant time, ZoneId timeZone) {
            Duration duration = Duration.ofHours(this.hour.intValue()).plusMinutes(this.minute.intValue()).plusSeconds(this.second.intValue());
            Instant deadline = time.plus(duration);
            return deadline;
        }
    }

    private static class TimeCalculator
    implements TriggerCalculator {
        private final Integer hour;
        private final Integer minute;
        private final Integer second;

        private TimeCalculator(Integer hour, Integer minute, Integer second) {
            this.hour = hour;
            this.minute = minute;
            this.second = second;
        }

        @Override
        public Instant calculateTime(Instant time, ZoneId timeZone) {
            Instant result;
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timeZone), Locale.ENGLISH);
            cal.setTime(Date.from(time));
            if (this.hour != null) {
                cal.set(11, this.hour);
            }
            if (this.minute != null) {
                cal.set(12, this.minute);
            }
            if (this.second != null) {
                cal.set(13, this.second);
            }
            if ((result = cal.getTime().toInstant()).isBefore(time)) {
                result = result.plus(1L, ChronoUnit.DAYS);
            }
            return result;
        }
    }

    private static interface TriggerCalculator {
        public Instant calculateTime(Instant var1, ZoneId var2);
    }
}

