/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;

public class TaskType {
    public static final int GROUPING_ONLY = 1;
    private final int flags;

    @JsonCreator
    public static TaskType of(int flags) {
        return new TaskType(flags);
    }

    public TaskType(int flags) {
        Preconditions.checkArgument((flags >= 0 && flags < Short.MAX_VALUE ? 1 : 0) != 0, (Object)"TaskType must be positive 16-bit signed integer");
        Preconditions.checkArgument(((flags & 0xFFFFFFFE) == 0 ? 1 : 0) != 0, (Object)"Unknown TaskType is set");
        this.flags = flags;
    }

    @JsonValue
    public int get() {
        return this.flags;
    }

    public boolean isGroupingOnly() {
        return (this.flags & 1) != 0;
    }

    public int hashCode() {
        return this.flags;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof TaskType && ((TaskType)another).flags == this.flags;
    }

    public String toString() {
        if ((this.flags & 1) != 0) {
            return "TaskType{GROUPING_ONLY}";
        }
        return "TaskType{}";
    }

    public static class Builder {
        private int flags = 0;

        public Builder groupingOnly(boolean v) {
            this.flags = v ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
            return this;
        }

        public TaskType build() {
            return new TaskType(this.flags);
        }
    }
}

