/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import io.digdag.core.session.ImmutableTaskRelation;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableTaskRelation.class)
@JsonDeserialize(as=ImmutableTaskRelation.class)
@Value.Immutable
public abstract class TaskRelation {
    public abstract long getId();

    public abstract Optional<Long> getParentId();

    public abstract List<Long> getUpstreams();

    public static TaskRelation ofRoot(long id) {
        return TaskRelation.of(id, (Optional<Long>)Optional.absent(), (List<Long>)ImmutableList.of());
    }

    public static TaskRelation of(long id, long parentId, List<Long> upstreams) {
        return TaskRelation.of(id, (Optional<Long>)Optional.of((Object)parentId), upstreams);
    }

    public static TaskRelation of(long id, Optional<Long> parentId, List<Long> upstreams) {
        return ImmutableTaskRelation.builder().id(id).parentId(parentId).upstreams(upstreams).build();
    }
}

