/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;

public class AttemptStateFlags {
    public static final int CANCEL_REQUESTED_CODE = 1;
    public static final int DONE_CODE = 2;
    public static final int SUCCESS_CODE = 4;
    private final int flags;

    @JsonCreator
    public static AttemptStateFlags of(int flags) {
        return new AttemptStateFlags(flags);
    }

    public static AttemptStateFlags empty() {
        return AttemptStateFlags.of(0);
    }

    private AttemptStateFlags(int flags) {
        Preconditions.checkArgument((flags >= 0 && flags < Short.MAX_VALUE ? 1 : 0) != 0, (Object)"AttemptStateFlags must be positive 16-bit signed integer");
        int unknown = flags & 0xFFFFFFFE & 0xFFFFFFFD & 0xFFFFFFFB;
        Preconditions.checkArgument((unknown == 0 ? 1 : 0) != 0, (Object)"Unknown AttemptStateFlags is set");
        this.flags = flags;
    }

    @JsonValue
    public int get() {
        return this.flags;
    }

    public AttemptStateFlags withCancelRequested() {
        return AttemptStateFlags.of(this.flags | 1);
    }

    public boolean isCancelRequested() {
        return (this.flags & 1) != 0;
    }

    public AttemptStateFlags withDone() {
        return AttemptStateFlags.of(this.flags | 2);
    }

    public boolean isDone() {
        return (this.flags & 2) != 0;
    }

    public AttemptStateFlags withSuccess() {
        return AttemptStateFlags.of(this.flags | 4);
    }

    public boolean isSuccess() {
        return (this.flags & 4) != 0;
    }

    public int hashCode() {
        return this.flags;
    }

    public boolean equals(Object another) {
        return this == another || another instanceof AttemptStateFlags && ((AttemptStateFlags)another).flags == this.flags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.isCancelRequested()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("CANCEL_REQUESTED");
        }
        if (this.isDone()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("DONE");
        }
        if (this.isSuccess()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("SUCCESS");
        }
        return "AttemptStateFlags{" + sb.toString() + "}";
    }
}

