/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.schedule;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.core.agent.CheckedConfig;
import io.digdag.core.agent.EditDistance;
import io.digdag.core.repository.Revision;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.StoredWorkflowDefinitionWithProject;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.schedule.ScheduleExecutor;
import io.digdag.core.schedule.UnusedConfigException;
import io.digdag.spi.Scheduler;
import io.digdag.spi.SchedulerFactory;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerManager {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerManager.class);
    private final Map<String, SchedulerFactory> types;

    private static com.google.common.base.Optional<Config> tryGetScheduleConfig(WorkflowDefinition def) {
        return def.getConfig().getOptional("schedule", Config.class);
    }

    public static Config getScheduleConfig(WorkflowDefinition def) {
        return def.getConfig().getNested("schedule");
    }

    @Inject
    public SchedulerManager(Set<SchedulerFactory> factories) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SchedulerFactory factory : factories) {
            builder.put((Object)factory.getType(), (Object)factory);
        }
        this.types = builder.build();
    }

    public com.google.common.base.Optional<Scheduler> tryGetScheduler(Revision rev, WorkflowDefinition def) {
        return SchedulerManager.tryGetScheduleConfig(def).transform(it -> this.getScheduler((Config)it, def.getTimeZone(), false));
    }

    public com.google.common.base.Optional<Scheduler> tryGetScheduler(StoredWorkflowDefinitionWithProject def) {
        return SchedulerManager.tryGetScheduleConfig(def).transform(it -> this.getScheduler((Config)it, def.getTimeZone(), false));
    }

    public com.google.common.base.Optional<Scheduler> tryGetScheduler(Revision rev, WorkflowDefinition def, boolean throwUnusedKeys) {
        return SchedulerManager.tryGetScheduleConfig(def).transform(it -> this.getScheduler((Config)it, def.getTimeZone(), throwUnusedKeys));
    }

    Scheduler getScheduler(StoredWorkflowDefinition def) {
        return this.getScheduler(SchedulerManager.getScheduleConfig(def), def.getTimeZone(), false);
    }

    private Scheduler getScheduler(Config schedulerConfig, ZoneId workflowTimeZone, boolean throwUnusedKeys) {
        String type;
        HashSet shouldBeUsedKeys = new HashSet(schedulerConfig.getKeys());
        CheckedConfig.UsedKeysSet usedKeys = new CheckedConfig.UsedKeysSet();
        CheckedConfig c = new CheckedConfig(schedulerConfig, usedKeys);
        if (c.has("_type")) {
            type = (String)c.get("_type", String.class);
        } else {
            Optional<String> operatorKey = c.getKeys().stream().filter(key -> key.endsWith(">")).findFirst();
            if (!operatorKey.isPresent()) {
                throw new ConfigException("Schedule config requires 'type>: at' parameter: " + (Object)((Object)c));
            }
            type = ((String)operatorKey.get()).substring(0, ((String)operatorKey.get()).length() - 1);
            Object command = c.get((String)operatorKey.get(), Object.class);
            c.set("_type", type);
            c.set("_command", command);
        }
        for (String param : ScheduleExecutor.BUILT_IN_SCHEDULE_PARAMS) {
            usedKeys.add(param);
        }
        SchedulerFactory factory = this.types.get(type);
        if (factory == null) {
            throw new ConfigException("Unknown scheduler type: " + type);
        }
        if (!usedKeys.isAllUsed()) {
            shouldBeUsedKeys.removeAll(usedKeys);
            if (!shouldBeUsedKeys.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (String key2 : shouldBeUsedKeys) {
                    buf.append(this.getWarnUnusedKey(key2, usedKeys));
                    buf.append("\n");
                }
                if (throwUnusedKeys) {
                    throw new UnusedConfigException(buf.toString());
                }
                logger.error(buf.toString());
            }
        }
        return factory.newScheduler((Config)c, workflowTimeZone);
    }

    private String getWarnUnusedKey(String shouldBeUsedButNotUsedKey, Collection<String> candidateKeys) {
        StringBuilder buf = new StringBuilder();
        buf.append("Parameter '");
        buf.append(shouldBeUsedButNotUsedKey);
        buf.append("' is not used at schedule. ");
        List<String> suggestions = EditDistance.suggest(shouldBeUsedButNotUsedKey, candidateKeys, 0.5);
        if (!suggestions.isEmpty()) {
            buf.append("> Did you mean '");
            buf.append(suggestions);
            buf.append("'?");
        }
        return buf.toString();
    }
}

