/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.google.common.base.Optional;
import io.digdag.core.repository.Project;
import io.digdag.core.repository.ProjectControlStore;
import io.digdag.core.repository.ProjectMap;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.repository.StoredProjectWithRevision;
import io.digdag.core.repository.StoredRevision;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.StoredWorkflowDefinitionWithProject;
import io.digdag.core.repository.TimeZoneMap;
import io.digdag.spi.ac.AccessController;
import java.util.List;

public interface ProjectStore {
    public List<StoredProject> getProjects(int var1, Optional<Integer> var2, Optional<String> var3, AccessController.ListFilter var4);

    public List<StoredProjectWithRevision> getProjectsWithLatestRevision(int var1, Optional<Integer> var2, Optional<String> var3, AccessController.ListFilter var4);

    public ProjectMap getProjectsByIdList(List<Integer> var1);

    public StoredProject getProjectById(int var1) throws ResourceNotFoundException;

    public StoredProject getProjectByName(String var1) throws ResourceNotFoundException;

    public <T> T putAndLockProject(Project var1, ProjectLockAction<T> var2) throws ResourceConflictException;

    public <T> T deleteProject(int var1, ProjectObsoleteAction<T> var2) throws ResourceNotFoundException;

    public StoredRevision getRevisionById(int var1) throws ResourceNotFoundException;

    public StoredRevision getRevisionByName(int var1, String var2) throws ResourceNotFoundException;

    public StoredRevision getLatestRevision(int var1) throws ResourceNotFoundException;

    public List<StoredRevision> getRevisions(int var1, int var2, Optional<Integer> var3);

    public byte[] getRevisionArchiveData(int var1) throws ResourceNotFoundException;

    public List<StoredWorkflowDefinition> getWorkflowDefinitions(int var1, int var2, Optional<Long> var3, AccessController.ListFilter var4);

    public StoredWorkflowDefinition getWorkflowDefinitionByName(int var1, String var2) throws ResourceNotFoundException;

    public StoredWorkflowDefinitionWithProject getWorkflowDefinitionById(long var1) throws ResourceNotFoundException;

    public StoredWorkflowDefinitionWithProject getLatestWorkflowDefinitionByName(int var1, String var2) throws ResourceNotFoundException;

    default public List<StoredWorkflowDefinitionWithProject> getLatestActiveWorkflowDefinitions(int pageSize, Optional<Long> lastId, Optional<String> namePattern, AccessController.ListFilter acFilter) throws ResourceNotFoundException {
        return this.getLatestActiveWorkflowDefinitions(pageSize, lastId, true, namePattern, false, acFilter);
    }

    public List<StoredWorkflowDefinitionWithProject> getLatestActiveWorkflowDefinitions(int var1, Optional<Long> var2, boolean var3, Optional<String> var4, boolean var5, AccessController.ListFilter var6) throws ResourceNotFoundException;

    public TimeZoneMap getWorkflowTimeZonesByIdList(List<Long> var1);

    public static interface ProjectObsoleteAction<T> {
        public T call(ProjectControlStore var1, StoredProject var2) throws ResourceNotFoundException;
    }

    public static interface ProjectLockAction<T> {
        public T call(ProjectControlStore var1, StoredProject var2) throws ResourceConflictException;
    }
}

