/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import io.digdag.core.repository.ModelValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModelValidator {
    private static final Pattern FIRST_NUMBER_CHAR = Pattern.compile("^[0-9]");
    private static final Pattern RESTRICTED_SYMBOL_CHAR = Pattern.compile("^[\\+\\^\\@\\/\\\\\\:\\*\\?\\\"\\<\\>\\|]");
    private static final Pattern RAW_TASK_NAME_CHARS = Pattern.compile("[^a-zA-Z_0-9\\-\\=\\[\\]\\{\\}\\%\\&\\@\\`\\,\\.\\^]");
    private final List<ModelValidationException.Failure> failures = new ArrayList<ModelValidationException.Failure>();

    public static ModelValidator builder() {
        return new ModelValidator();
    }

    private ModelValidator() {
    }

    public ModelValidator error(String fieldName, Object object, String errorMessage) {
        this.failures.add(new ModelValidationException.Failure(fieldName, object, errorMessage));
        return this;
    }

    public ModelValidator check(String fieldName, Object object, boolean expression, String errorMessage) {
        if (!expression) {
            this.error(fieldName, object, errorMessage);
        }
        return this;
    }

    public ModelValidator checkNotEmpty(String fieldName, String value) {
        return this.check(fieldName, value, !value.isEmpty(), "must not be blank");
    }

    public ModelValidator checkMaxLength(String fieldName, String value, int max) {
        return this.check(fieldName, value, value.length() <= max, "must not be longer than " + max + " characters");
    }

    public ModelValidator checkProjectName(String fieldName, String value) {
        this.checkNotEmpty(fieldName, value);
        this.check(fieldName, value, !FIRST_NUMBER_CHAR.matcher(value).find(), "must not start with a numeric digit (0-9)");
        this.check(fieldName, value, !RESTRICTED_SYMBOL_CHAR.matcher(value).find(), "must not include special symbols (+ ^ @ / \\ / : * ? \" < > |)");
        this.check(fieldName, value, !value.endsWith(".dig"), "must not end with .dig");
        this.checkMaxLength(fieldName, value, 255);
        return this;
    }

    public ModelValidator checkWorkflowName(String fieldName, String value) {
        return this.checkProjectName(fieldName, value);
    }

    public ModelValidator checkIdentifierName(String fieldName, String value) {
        this.checkNotEmpty(fieldName, value);
        this.checkMaxLength(fieldName, value, 255);
        return this;
    }

    public ModelValidator checkTaskName(String fieldName, String value) {
        this.check(fieldName, value, value.startsWith("+"), "must start with '+'");
        this.check(fieldName, value, !value.contains("^"), "must not contain ^ character");
        this.checkRawTaskName(fieldName, value);
        return this;
    }

    public ModelValidator checkRawTaskName(String fieldName, String value) {
        Matcher m;
        this.checkNotEmpty(fieldName, value);
        this.check(fieldName, value, !FIRST_NUMBER_CHAR.matcher(value).find(), "must not start with a digit (0-9)");
        this.check(fieldName, value, value.startsWith("+") || value.startsWith("^"), "must start with '+' or '^'");
        if (!value.isEmpty() && (m = RAW_TASK_NAME_CHARS.matcher(value.substring(1))).find()) {
            this.check(fieldName, value, false, "must not contain character '" + m.group() + "'");
        }
        this.checkMaxLength(fieldName, value, 255);
        return this;
    }

    public ModelValidator check(Object modelObject, String fieldName, Object object, boolean expression, String errorMessageFormat, Object ... objects) {
        if (!expression) {
            this.error(fieldName, object, String.format(Locale.ENGLISH, errorMessageFormat, objects));
        }
        return this;
    }

    public void validate(String modelType, Object modelObject) {
        if (!this.failures.isEmpty()) {
            throw new ModelValidationException("Validating " + modelType + " failed", modelObject, this.failures);
        }
    }
}

