/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.queue;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.spi.TaskQueueClient;
import io.digdag.spi.TaskQueueFactory;
import io.digdag.spi.TaskQueueServer;
import java.util.Set;

public class TaskQueueServerManager {
    private final TaskQueueServer taskQueueServer;

    @Inject
    public TaskQueueServerManager(Config systemConfig, Set<TaskQueueFactory> factories) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TaskQueueFactory factory : factories) {
            builder.put((Object)factory.getType(), (Object)factory);
        }
        ImmutableMap queueTypes = builder.build();
        String type = (String)systemConfig.get("queue-server.type", String.class, (Object)"database");
        TaskQueueFactory factory = (TaskQueueFactory)queueTypes.get(type);
        this.taskQueueServer = factory.newServer(systemConfig);
    }

    public TaskQueueServer getTaskQueueServer() {
        return this.taskQueueServer;
    }

    public TaskQueueClient getInProcessTaskQueueClient() {
        return this.getTaskQueueServer();
    }
}

