/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.queue;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.queue.QueueSetting;
import io.digdag.core.queue.StoredQueueSetting;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredQueueSetting
extends StoredQueueSetting {
    private final long id;
    private final int siteId;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String name;
    private final Config config;

    private ImmutableStoredQueueSetting(long id, int siteId, Instant createdAt, Instant updatedAt, String name, Config config) {
        this.id = id;
        this.siteId = siteId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.name = name;
        this.config = config;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="siteId")
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    public final ImmutableStoredQueueSetting withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableStoredQueueSetting(value, this.siteId, this.createdAt, this.updatedAt, this.name, this.config);
    }

    public final ImmutableStoredQueueSetting withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableStoredQueueSetting(this.id, value, this.createdAt, this.updatedAt, this.name, this.config);
    }

    public final ImmutableStoredQueueSetting withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableStoredQueueSetting(this.id, this.siteId, newValue, this.updatedAt, this.name, this.config);
    }

    public final ImmutableStoredQueueSetting withUpdatedAt(Instant value) {
        if (this.updatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return new ImmutableStoredQueueSetting(this.id, this.siteId, this.createdAt, newValue, this.name, this.config);
    }

    public final ImmutableStoredQueueSetting withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableStoredQueueSetting(this.id, this.siteId, this.createdAt, this.updatedAt, newValue, this.config);
    }

    public final ImmutableStoredQueueSetting withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return new ImmutableStoredQueueSetting(this.id, this.siteId, this.createdAt, this.updatedAt, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredQueueSetting && this.equalTo((ImmutableStoredQueueSetting)another);
    }

    private boolean equalTo(ImmutableStoredQueueSetting another) {
        return this.id == another.id && this.siteId == another.siteId && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.name.equals(another.name) && this.config.equals((Object)another.config);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + this.siteId;
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.updatedAt.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.config.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredQueueSetting").omitNullValues().add("id", this.id).add("siteId", this.siteId).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).add("name", (Object)this.name).add("config", (Object)this.config).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredQueueSetting fromJson(Json json) {
        Builder builder = ImmutableStoredQueueSetting.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.siteIdIsSet) {
            builder.siteId(json.siteId);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        return builder.build();
    }

    public static ImmutableStoredQueueSetting copyOf(StoredQueueSetting instance) {
        if (instance instanceof ImmutableStoredQueueSetting) {
            return (ImmutableStoredQueueSetting)instance;
        }
        return ImmutableStoredQueueSetting.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SITE_ID = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_NAME = 16L;
        private static final long INIT_BIT_CONFIG = 32L;
        private long initBits = 63L;
        private long id;
        private int siteId;
        @Nullable
        private Instant createdAt;
        @Nullable
        private Instant updatedAt;
        @Nullable
        private String name;
        @Nullable
        private Config config;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredQueueSetting instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(QueueSetting instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            QueueSetting instance;
            if (object instanceof StoredQueueSetting) {
                instance = (StoredQueueSetting)object;
                this.createdAt(((StoredQueueSetting)instance).getCreatedAt());
                this.siteId(((StoredQueueSetting)instance).getSiteId());
                this.id(((StoredQueueSetting)instance).getId());
                this.updatedAt(((StoredQueueSetting)instance).getUpdatedAt());
            }
            if (object instanceof QueueSetting) {
                instance = (QueueSetting)object;
                this.name(instance.getName());
                this.config(instance.getConfig());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="siteId")
        @CanIgnoreReturnValue
        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="updatedAt")
        @CanIgnoreReturnValue
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = (Instant)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableStoredQueueSetting build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoredQueueSetting(this.id, this.siteId, this.createdAt, this.updatedAt, this.name, this.config);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("config");
            }
            return "Cannot build StoredQueueSetting, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredQueueSetting {
        long id;
        boolean idIsSet;
        int siteId;
        boolean siteIdIsSet;
        @Nullable
        Instant createdAt;
        @Nullable
        Instant updatedAt;
        @Nullable
        String name;
        @Nullable
        Config config;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="siteId")
        public void setSiteId(int siteId) {
            this.siteId = siteId;
            this.siteIdIsSet = true;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSiteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }
    }
}

