/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.plugin;

import com.google.common.collect.ImmutableList;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.plugin.LocalPluginLoader;
import io.digdag.core.plugin.PluginClassLoader;
import io.digdag.core.plugin.PluginLoader;
import io.digdag.core.plugin.PluginSet;
import io.digdag.core.plugin.Spec;
import io.digdag.spi.Plugin;
import io.digdag.util.RetryExecutor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePluginLoader
implements PluginLoader {
    private static final Logger logger = LoggerFactory.getLogger(RemotePluginLoader.class);
    private static final int EXTRACT_RETRIES = 3;
    private static final int EXTRACT_MIN_RETRY_WAIT_MS = 1000;
    private static final int EXTRACT_MAX_RETRY_WAIT_MS = 10000;
    private static final List<RemoteRepository> DEFAULT_REPOSITORIES = ImmutableList.copyOf((Object[])new RemoteRepository[]{new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build(), new RemoteRepository.Builder("jcenter", "default", "https://jcenter.bintray.com/").build()});
    private static final List<String> PARENT_FIRST_PACKAGES = ImmutableList.copyOf((Object[])new String[]{"io.digdag.spi", "io.digdag.client", "org.slf4j", "javax.inject", "com.google.common", "com.fasterxml.jackson.databind.annotation"});
    private static final List<String> PARENT_FIRST_RESOURCES = ImmutableList.copyOf((Object[])new String[0]);
    private final RepositorySystem system = RemotePluginLoader.newRepositorySystem();
    private final RepositorySystemSession session;

    private static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static RepositorySystemSession newRepositorySystemSession(RepositorySystem system, Path localRepositoryPath) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localRepositoryPath.toString());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    public RemotePluginLoader(Path localRepositoryPath) {
        this.session = RemotePluginLoader.newRepositorySystemSession(this.system, localRepositoryPath);
    }

    @Override
    public PluginSet load(Spec spec) {
        if (spec.getDependencies().isEmpty()) {
            return PluginSet.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        List<RemoteRepository> repositories = this.getRepositories(spec);
        for (String dep : spec.getDependencies()) {
            logger.debug("Loading plugin {}", (Object)dep);
            List<ArtifactResult> artifactResults = this.resolveArtifacts(repositories, dep);
            logger.debug("Classpath of plugin {}: {}", (Object)dep, (Object)artifactResults.stream().map(a -> a.getArtifact().getFile().toString()).collect(Collectors.joining(File.pathSeparator)));
            ClassLoader pluginClassLoader = this.buildPluginClassLoader(artifactResults);
            try {
                List<Plugin> plugins = LocalPluginLoader.lookupPlugins(pluginClassLoader);
                if (plugins.isEmpty()) {
                    logger.warn("No plugins found from a dependency '" + dep + "'");
                    continue;
                }
                builder.addAll(plugins);
            }
            catch (ServiceConfigurationError ex) {
                throw new RuntimeException("Failed to lookup io.digdag.spi.Plugin service from a dependency '" + dep + "'", ex);
            }
        }
        return new PluginSet((List<Plugin>)builder.build());
    }

    private ClassLoader buildPluginClassLoader(List<ArtifactResult> artifactResults) {
        ImmutableList.Builder urls = ImmutableList.builder();
        for (ArtifactResult artifactResult : artifactResults) {
            URL url;
            try {
                url = artifactResult.getArtifact().getFile().toPath().toUri().toURL();
            }
            catch (MalformedURLException ex) {
                throw ThrowablesUtil.propagate((Throwable)ex);
            }
            urls.add((Object)url);
        }
        return new PluginClassLoader((Collection<? extends URL>)urls.build(), RemotePluginLoader.class.getClassLoader(), PARENT_FIRST_PACKAGES, PARENT_FIRST_RESOURCES);
    }

    private List<ArtifactResult> resolveArtifacts(List<RemoteRepository> repositories, String dep) {
        DependencyRequest depRequest = RemotePluginLoader.buildDependencyRequest(repositories, dep, "runtime");
        try {
            return (List)RetryExecutor.retryExecutor().retryIf(exception -> true).withInitialRetryWait(1000).withMaxRetryWait(10000).onRetry((exception, retryCount, retryLimit, retryWait) -> logger.warn("Failed to resolve artifacts: retry {} of {}", new Object[]{retryCount, retryLimit, exception})).withRetryLimit(3).run(() -> this.system.resolveDependencies(this.session, depRequest).getArtifactResults());
        }
        catch (RetryExecutor.RetryGiveupException e) {
            throw ThrowablesUtil.propagate((Throwable)e.getCause());
        }
    }

    private List<RemoteRepository> getRepositories(Spec spec) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(DEFAULT_REPOSITORIES);
        int i = 1;
        for (String repo : spec.getRepositories()) {
            builder.add((Object)new RemoteRepository.Builder("repository-" + i, "default", repo).build());
            ++i;
        }
        return builder.build();
    }

    private static DependencyRequest buildDependencyRequest(List<RemoteRepository> repositories, String identifier, String scope) {
        DefaultArtifact artifact = new DefaultArtifact(identifier);
        DependencyFilter classpathFlter = DependencyFilterUtils.classpathFilter((String[])new String[]{scope});
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, scope));
        collectRequest.setRepositories(repositories);
        return new DependencyRequest(collectRequest, classpathFlter);
    }
}

