/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.plugin;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.digdag.spi.Plugin;
import java.util.List;

public class PluginSet {
    private final List<Plugin> plugins;

    public static PluginSet empty() {
        return new PluginSet((List<Plugin>)ImmutableList.of());
    }

    public PluginSet(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    public PluginSet withPlugins(Plugin ... plugins) {
        return this.withPlugins((List<Plugin>)ImmutableList.copyOf((Object[])plugins));
    }

    public PluginSet withPlugins(List<Plugin> plugins) {
        return new PluginSet((List<Plugin>)FluentIterable.from(this.plugins).append(plugins).toList());
    }

    public PluginSet withPlugins(PluginSet another) {
        return this.withPlugins(another.plugins);
    }

    public WithInjector withInjector(Injector injector) {
        return new WithInjector(injector);
    }

    public class WithInjector {
        private final Injector injector;

        private WithInjector(Injector injector) {
            this.injector = injector;
        }

        public <T> List<T> getServiceProviders(Class<T> type) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Plugin plugin : PluginSet.this.plugins) {
                Class providerClass = plugin.getServiceProvider(type);
                if (providerClass == null) continue;
                builder.add(this.getServiceProvider(providerClass, type, plugin));
            }
            return builder.build();
        }

        private <T, E extends T> E getServiceProvider(Class<E> providerClass, Class<T> type, Plugin plugin) {
            return (E)this.injector.createChildInjector(new Module[]{binder -> {
                plugin.configureBinder(providerClass, binder);
                binder.bind(providerClass);
            }}).getInstance(providerClass);
        }
    }
}

