/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.plugin;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.plugin.Spec;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableSpec
implements Spec {
    private final ImmutableList<String> repositories;
    private final ImmutableList<String> dependencies;

    private ImmutableSpec(ImmutableList<String> repositories, ImmutableList<String> dependencies) {
        this.repositories = repositories;
        this.dependencies = dependencies;
    }

    @JsonProperty(value="repositories")
    public ImmutableList<String> getRepositories() {
        return this.repositories;
    }

    @JsonProperty(value="dependencies")
    public ImmutableList<String> getDependencies() {
        return this.dependencies;
    }

    public final ImmutableSpec withRepositories(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSpec((ImmutableList<String>)newValue, this.dependencies);
    }

    public final ImmutableSpec withRepositories(Iterable<String> elements) {
        if (this.repositories == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSpec((ImmutableList<String>)newValue, this.dependencies);
    }

    public final ImmutableSpec withDependencies(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSpec(this.repositories, (ImmutableList<String>)newValue);
    }

    public final ImmutableSpec withDependencies(Iterable<String> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSpec(this.repositories, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSpec && this.equalTo((ImmutableSpec)another);
    }

    private boolean equalTo(ImmutableSpec another) {
        return this.repositories.equals(another.repositories) && this.dependencies.equals(another.dependencies);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.repositories.hashCode();
        h = h * 17 + this.dependencies.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Spec").omitNullValues().add("repositories", this.repositories).add("dependencies", this.dependencies).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSpec fromJson(Json json) {
        Builder builder = ImmutableSpec.builder();
        if (json.repositories != null) {
            builder.addAllRepositories(json.repositories);
        }
        if (json.dependencies != null) {
            builder.addAllDependencies(json.dependencies);
        }
        return builder.build();
    }

    public static ImmutableSpec copyOf(Spec instance) {
        if (instance instanceof ImmutableSpec) {
            return (ImmutableSpec)instance;
        }
        return ImmutableSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> repositories = ImmutableList.builder();
        private ImmutableList.Builder<String> dependencies = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Spec instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllRepositories(instance.getRepositories());
            this.addAllDependencies(instance.getDependencies());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepositories(String element) {
            this.repositories.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepositories(String ... elements) {
            this.repositories.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="repositories")
        @CanIgnoreReturnValue
        public final Builder repositories(Iterable<String> elements) {
            this.repositories = ImmutableList.builder();
            return this.addAllRepositories(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRepositories(Iterable<String> elements) {
            this.repositories.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDependencies(String element) {
            this.dependencies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDependencies(String ... elements) {
            this.dependencies.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="dependencies")
        @CanIgnoreReturnValue
        public final Builder dependencies(Iterable<String> elements) {
            this.dependencies = ImmutableList.builder();
            return this.addAllDependencies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDependencies(Iterable<String> elements) {
            this.dependencies.addAll(elements);
            return this;
        }

        public ImmutableSpec build() {
            return new ImmutableSpec(this.repositories.build(), this.dependencies.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Spec {
        List<String> repositories = ImmutableList.of();
        List<String> dependencies = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="repositories")
        public void setRepositories(List<String> repositories) {
            this.repositories = repositories;
        }

        @JsonProperty(value="dependencies")
        public void setDependencies(List<String> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public List<String> getRepositories() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getDependencies() {
            throw new UnsupportedOperationException();
        }
    }
}

