/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import java.util.HashSet;
import java.util.Set;

public class LocalLockMap {
    private final Block[] blocks = new Block[256];

    public LocalLockMap() {
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = new Block();
        }
    }

    public boolean tryLock(int queueId, long maxTimeout) throws InterruptedException {
        return this.blocks[queueId % this.blocks.length].tryLock(queueId, maxTimeout);
    }

    public void unlock(int queueId) {
        this.blocks[queueId % this.blocks.length].unlock(queueId);
    }

    private static class Block {
        private final Set<Integer> set = new HashSet<Integer>();

        private Block() {
        }

        public synchronized boolean tryLock(int queueId, long maxTimeout) throws InterruptedException {
            Integer i = queueId;
            if (this.set.add(i)) {
                return true;
            }
            this.wait(maxTimeout);
            return this.set.add(i);
        }

        public synchronized void unlock(int queueId) {
            this.set.remove(queueId);
            this.notifyAll();
        }
    }
}

