/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.inject.Inject;
import io.digdag.core.crypto.SecretCrypto;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.DatabaseSecretControlStore;
import io.digdag.core.database.TransactionManager;
import io.digdag.spi.SecretControlStore;
import io.digdag.spi.SecretControlStoreManager;

public class DatabaseSecretControlStoreManager
implements SecretControlStoreManager {
    private final DatabaseConfig config;
    private final TransactionManager tm;
    private final ConfigMapper cfm;
    private final SecretCrypto crypto;

    @Inject
    public DatabaseSecretControlStoreManager(DatabaseConfig config, TransactionManager tm, ConfigMapper cfm, SecretCrypto crypto) {
        this.config = config;
        this.tm = tm;
        this.cfm = cfm;
        this.crypto = crypto;
    }

    public SecretControlStore getSecretControlStore(int siteId) {
        return new DatabaseSecretControlStore(this.config, this.tm, this.cfm, siteId, this.crypto);
    }
}

