/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.database;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.digdag.core.database.BasicDatabaseStoreManager;
import io.digdag.core.database.ConfigMapper;
import io.digdag.core.database.DatabaseConfig;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.queue.ImmutableStoredQueueSetting;
import io.digdag.core.queue.QueueSettingStore;
import io.digdag.core.queue.QueueSettingStoreManager;
import io.digdag.core.queue.StoredQueueSetting;
import io.digdag.core.repository.ResourceNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class DatabaseQueueSettingStoreManager
extends BasicDatabaseStoreManager<Dao>
implements QueueSettingStoreManager {
    @Inject
    public DatabaseQueueSettingStoreManager(TransactionManager transactionManager, DatabaseConfig config, ConfigMapper cfm) {
        super(config.getType(), Dao.class, transactionManager, cfm);
    }

    @Override
    public QueueSettingStore getQueueSettingStore(int siteId) {
        return new DatabaseQueueSettingStore(siteId);
    }

    @Override
    public int getQueueIdByName(int siteId, String name) throws ResourceNotFoundException {
        return this.requiredResource((handle, dao) -> dao.getQueueIdByName(siteId, name), "queue name=%d", new Object[]{name});
    }

    static class StoredQueueSettingMapper
    implements ResultSetMapper<StoredQueueSetting> {
        private final ConfigMapper cfm;

        public StoredQueueSettingMapper(ConfigMapper cfm) {
            this.cfm = cfm;
        }

        public StoredQueueSetting map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return ImmutableStoredQueueSetting.builder().id(r.getInt("id")).siteId(r.getInt("site_id")).createdAt(BasicDatabaseStoreManager.getTimestampInstant(r, "created_at")).updatedAt(BasicDatabaseStoreManager.getTimestampInstant(r, "updated_at")).name(r.getString("name")).config(this.cfm.fromResultSetOrEmpty(r, "config")).build();
        }
    }

    public static interface Dao {
        @SqlQuery(value="select * from queue_settings where site_id = :siteId and id > :lastId order by id desc limit :limit")
        public List<StoredQueueSetting> getQueueSettings(@Bind(value="siteId") int var1, @Bind(value="limit") int var2, @Bind(value="lastId") long var3);

        @SqlQuery(value="select * from queue_settings where site_id = :siteId and id = :id limit 1")
        public StoredQueueSetting getQueueSettingById(@Bind(value="siteId") int var1, @Bind(value="id") long var2);

        @SqlQuery(value="select * from queue_settings where site_id = :siteId and name = :name limit 1")
        public StoredQueueSetting getQueueSettingByName(@Bind(value="siteId") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id from queue_settings where site_id = :siteId and name = :name limit 1")
        public Integer getQueueIdByName(@Bind(value="siteId") int var1, @Bind(value="name") String var2);

        @SqlUpdate(value="insert into queue_settings (site_id, name, config, created_at, updated_at) values (:siteId, :name, NULL, now(), now())")
        @GetGeneratedKeys
        public int insertDefaultQueueSetting(@Bind(value="siteId") int var1, @Bind(value="name") String var2);

        @SqlUpdate(value="insert into queues (id, max_concurrency) values (:id, :maxConcurrency)")
        public int insertQueue(@Bind(value="id") int var1, @Bind(value="maxConcurrency") int var2);
    }

    private class DatabaseQueueSettingStore
    implements QueueSettingStore {
        private final int siteId;

        public DatabaseQueueSettingStore(int siteId) {
            this.siteId = siteId;
        }

        @Override
        public List<StoredQueueSetting> getQueueSettings(int pageSize, Optional<Long> lastId) {
            return DatabaseQueueSettingStoreManager.this.autoCommit((handle, dao) -> dao.getQueueSettings(this.siteId, pageSize, (Long)lastId.or((Object)0L)));
        }

        @Override
        public StoredQueueSetting getQueueSettingById(long qId) throws ResourceNotFoundException {
            return DatabaseQueueSettingStoreManager.this.requiredResource((handle, dao) -> dao.getQueueSettingById(this.siteId, qId), "queue id=%d", new Object[]{qId});
        }

        @Override
        public StoredQueueSetting getQueueSettingByName(String name) throws ResourceNotFoundException {
            return DatabaseQueueSettingStoreManager.this.requiredResource((handle, dao) -> dao.getQueueSettingByName(this.siteId, name), "queue name=%s", new Object[]{name});
        }
    }
}

