/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.archive;

import com.fasterxml.jackson.databind.JsonNode;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.core.repository.ModelValidator;
import io.digdag.core.repository.WorkflowDefinition;
import java.time.ZoneId;

public class WorkflowFile {
    private static final String[] TOP_LEVEL_CONFIG = new String[]{"schedule", "sla", "_error", "_check", "_retry", "_parallel"};
    private final String workflowName;
    private final Config tasks;
    private final ZoneId timeZone;
    private final Config topLevelExport;
    private final Config otherTopLevelConfig;

    private WorkflowFile(String workflowName, Config tasks, ZoneId timeZone, Config topLevelExport, Config otherTopLevelConfig) {
        this.workflowName = workflowName;
        this.tasks = tasks;
        this.timeZone = timeZone;
        this.topLevelExport = topLevelExport;
        this.otherTopLevelConfig = otherTopLevelConfig;
        this.check();
    }

    public void setBaseWorkdir(String base) {
        String workdir = (String)this.topLevelExport.getOptional("_workdir", String.class).transform(it -> base + "/" + it).or((Object)base);
        this.topLevelExport.set("_workdir", (Object)workdir);
    }

    protected void check() {
        ModelValidator validator = ModelValidator.builder();
        for (String taskName : this.tasks.getKeys()) {
            validator.checkTaskName("task name", taskName);
        }
        validator.checkWorkflowName("name", this.workflowName).validate("workflow", this);
    }

    public static WorkflowFile fromConfig(String workflowName, Config config) {
        Config copy = config.deepCopy();
        ZoneId timeZone = (ZoneId)copy.getOptional("timezone", ZoneId.class).or((Object)ZoneId.of("UTC"));
        copy.remove("timezone");
        Config topLevelExport = copy.getNestedOrGetEmpty("_export");
        copy.remove("_export");
        Config otherTopLevelConfig = copy.getFactory().create();
        for (String key : TOP_LEVEL_CONFIG) {
            if (!copy.has(key)) continue;
            otherTopLevelConfig.set(key, copy.get(key, JsonNode.class));
            copy.remove(key);
        }
        Config tasks = config.getFactory().create();
        for (String key : copy.getKeys()) {
            if (!key.startsWith("+")) continue;
            tasks.set(key, copy.get(key, JsonNode.class));
            copy.remove(key);
        }
        if (!copy.isEmpty()) {
            throw new ConfigException("Workflow '" + workflowName + "' includes unknown keys: " + copy.getKeys());
        }
        return new WorkflowFile(workflowName, tasks, timeZone, topLevelExport, otherTopLevelConfig);
    }

    public WorkflowDefinition toWorkflowDefinition() {
        Config config = this.tasks.getFactory().create();
        if (!this.topLevelExport.isEmpty()) {
            config.set("_export", (Object)this.topLevelExport);
        }
        config.setAll(this.otherTopLevelConfig);
        config.setAll(this.tasks);
        return WorkflowDefinition.of(this.workflowName, config, this.timeZone);
    }
}

