/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.archive;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.core.archive.ArchiveMetadata;
import io.digdag.core.archive.ProjectArchive;
import io.digdag.core.archive.WorkflowFile;
import io.digdag.core.archive.WorkflowResourceMatcher;
import io.digdag.core.config.ConfigLoaderManager;
import io.digdag.core.repository.ModelValidationException;
import io.digdag.core.repository.ModelValidator;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.repository.WorkflowDefinitionList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class ProjectArchiveLoader {
    private final ConfigLoaderManager configLoader;

    @Inject
    public ProjectArchiveLoader(ConfigLoaderManager configLoader) {
        this.configLoader = configLoader;
    }

    public ProjectArchive load(Path projectDirectory, WorkflowResourceMatcher matcher, Config overrideParams) throws IOException {
        Path projectPath = projectDirectory.normalize().toAbsolutePath();
        ModelValidator validator = ModelValidator.builder();
        ImmutableList.Builder errors = ImmutableList.builder();
        ImmutableList.Builder defs = ImmutableList.builder();
        ProjectArchive.listFiles(projectPath, (resourceName, path) -> {
            if (matcher.matches(resourceName, path)) {
                try {
                    WorkflowFile workflowFile = this.loadWorkflowFile(resourceName, path, overrideParams);
                    defs.add((Object)workflowFile.toWorkflowDefinition());
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (RuntimeException ex) {
                    validator.error("workflow " + path, null, ex.getMessage());
                    errors.add((Object)ex);
                }
            }
            return true;
        });
        try {
            validator.validate("project", projectDirectory);
        }
        catch (ModelValidationException ex) {
            for (Throwable error : errors.build()) {
                ex.addSuppressed(error);
            }
            throw ex;
        }
        ArchiveMetadata metadata = ArchiveMetadata.of(WorkflowDefinitionList.of((List<WorkflowDefinition>)defs.build()), overrideParams);
        return new ProjectArchive(projectPath, metadata);
    }

    private WorkflowFile loadWorkflowFile(String resourceName, Path path, Config overrideParams) throws IOException {
        String workflowName = ProjectArchive.resourceNameToWorkflowName(resourceName);
        WorkflowFile workflowFile = WorkflowFile.fromConfig(workflowName, this.configLoader.loadParameterizedFile(path.toFile(), overrideParams));
        int posSlash = workflowName.lastIndexOf(47);
        if (posSlash >= 0) {
            String workdir = workflowName.substring(0, posSlash);
            workflowFile.setBaseWorkdir(workdir);
        }
        return workflowFile;
    }

    public WorkflowFile loadWorkflowFileFromPath(Path projectPath, Path workflowPath, Config overrideParams) throws IOException {
        String resourceName = ProjectArchive.realPathToResourceName(projectPath.normalize().toAbsolutePath(), workflowPath.normalize().toAbsolutePath());
        return this.loadWorkflowFile(resourceName, workflowPath, overrideParams);
    }
}

