/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigKey;
import io.digdag.spi.PrivilegedVariables;
import io.digdag.spi.SecretAccessContext;
import io.digdag.spi.SecretProvider;
import io.digdag.spi.SecretStore;
import io.digdag.util.UserSecretTemplate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GrantedPrivilegedVariables
implements PrivilegedVariables {
    private final Map<String, VariableAccessor> variables;

    static SecretProvider privilegedSecretProvider(SecretAccessContext context, SecretStore store) {
        return key -> {
            Optional projectSecret = store.getSecret(context.projectId(), "project", key);
            if (projectSecret.isPresent()) {
                return projectSecret;
            }
            return store.getSecret(context.projectId(), "project-default", key);
        };
    }

    public static GrantedPrivilegedVariables empty() {
        return new GrantedPrivilegedVariables(new LinkedHashMap<String, VariableAccessor>());
    }

    public static GrantedPrivilegedVariables build(Config source, SecretProvider secretProvider) {
        LinkedHashMap<String, VariableAccessor> variables = new LinkedHashMap<String, VariableAccessor>();
        for (String key : source.getKeys()) {
            variables.put(key, GrantedPrivilegedVariables.buildAccessor((String)source.get(key, String.class), secretProvider));
        }
        return new GrantedPrivilegedVariables(variables);
    }

    private static VariableAccessor buildAccessor(String template, SecretProvider secretProvider) {
        return () -> UserSecretTemplate.of((String)template).format(secretProvider);
    }

    private GrantedPrivilegedVariables(Map<String, VariableAccessor> variables) {
        this.variables = variables;
    }

    public String get(String key) {
        VariableAccessor var = this.variables.get(key);
        if (var == null) {
            throw new ConfigException("_env variable '" + key + "' is required but not set");
        }
        String value = var.get();
        if (value == null) {
            throw new ConfigException("_env variable '" + key + "' is required but null");
        }
        return value;
    }

    public Optional<String> getOptional(String key) {
        VariableAccessor var = this.variables.get(key);
        if (var == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)var.get());
    }

    public List<String> getKeys() {
        return ImmutableList.copyOf(this.variables.keySet());
    }

    private static interface VariableAccessor {
        public String get();
    }

    private static class SecretOnlyGrant {
        @JsonProperty
        ConfigKey secret;

        private SecretOnlyGrant() {
        }
    }
}

