/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.TempFileManager;
import io.digdag.core.agent.WorkspaceManager;
import io.digdag.core.archive.ProjectArchives;
import io.digdag.spi.StorageObject;
import io.digdag.spi.TaskRequest;
import io.digdag.util.RetryExecutor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractArchiveWorkspaceManager
implements WorkspaceManager {
    private static final int EXTRACT_RETRIES = 10;
    private static final int EXTRACT_MIN_RETRY_WAIT_MS = 1000;
    private static final int EXTRACT_MAX_RETRY_WAIT_MS = 30000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TempFileManager tempFiles;

    @Inject
    public ExtractArchiveWorkspaceManager(TempFileManager tempFiles) {
        this.tempFiles = tempFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withExtractedArchive(TaskRequest request, WorkspaceManager.ArchiveProvider archiveProvider, WorkspaceManager.WithWorkspaceAction<T> func) throws IOException {
        try (TempFileManager.TempDir workspacePath = null;){
            try {
                workspacePath = (TempFileManager.TempDir)RetryExecutor.retryExecutor().retryIf(exception -> true).withInitialRetryWait(1000).withMaxRetryWait(30000).onRetry((exception, retryCount, retryLimit, retryWait) -> this.logger.warn("Failed to extract archive: retry {} of {}", new Object[]{retryCount, retryLimit, exception})).withRetryLimit(10).run(() -> {
                    TempFileManager.TempDir newWorkSpacePath = null;
                    try {
                        newWorkSpacePath = this.createNewWorkspace(request);
                        Optional<StorageObject> in = archiveProvider.open();
                        if (in.isPresent()) {
                            ProjectArchives.extractTarArchive(newWorkSpacePath.get(), ((StorageObject)in.get()).getContentInputStream());
                        }
                        return newWorkSpacePath;
                    }
                    catch (Throwable e) {
                        if (newWorkSpacePath != null) {
                            newWorkSpacePath.close();
                        }
                        throw e;
                    }
                });
            }
            catch (RetryExecutor.RetryGiveupException e) {
                throw ThrowablesUtil.propagate((Throwable)e.getCause());
            }
            T t = func.run(workspacePath.get());
            return t;
        }
    }

    private TempFileManager.TempDir createNewWorkspace(TaskRequest request) throws IOException {
        String workspacePrefix = request.getProjectId() + "_" + request.getWorkflowName() + "_" + request.getAttemptId() + "_" + request.getTaskId();
        return this.tempFiles.createTempDir("workspace", workspacePrefix);
    }
}

