/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.agent;

import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.core.archive.ProjectArchiveLoader;
import io.digdag.core.archive.WorkflowFile;
import io.digdag.spi.Operator;
import io.digdag.spi.OperatorContext;
import io.digdag.spi.OperatorFactory;
import io.digdag.spi.TaskRequest;
import io.digdag.spi.TaskResult;
import io.digdag.util.BaseOperator;
import io.digdag.util.Workspace;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallOperatorFactory
implements OperatorFactory {
    private static Logger logger = LoggerFactory.getLogger(CallOperatorFactory.class);
    private final ProjectArchiveLoader projectLoader;

    @Inject
    public CallOperatorFactory(ProjectArchiveLoader projectLoader) {
        this.projectLoader = projectLoader;
    }

    public String getType() {
        return "call";
    }

    public Operator newOperator(OperatorContext context) {
        return new CallOperator(context);
    }

    private class CallOperator
    extends BaseOperator {
        public CallOperator(OperatorContext context) {
            super(context);
        }

        public TaskResult runTask() {
            WorkflowFile workflowFile;
            Config config = this.request.getConfig();
            String workflowFileName = (String)config.get("_command", String.class);
            if (!workflowFileName.endsWith(".dig")) {
                workflowFileName = workflowFileName + ".dig";
            }
            Path workflowPath = this.workspace.getPath(workflowFileName);
            try {
                workflowFile = CallOperatorFactory.this.projectLoader.loadWorkflowFileFromPath(this.workspace.getProjectPath(), workflowPath, config);
            }
            catch (IOException ex) {
                throw (ConfigException)((Object)Workspace.propagateIoException((IOException)ex, (String)workflowFileName, ConfigException::new));
            }
            Config def = workflowFile.toWorkflowDefinition().getConfig();
            return TaskResult.defaultBuilder((TaskRequest)this.request).subtaskConfig(def).build();
        }
    }
}

