/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core;

import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.module.guice.ObjectMapperModule;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.util.Modules;
import io.digdag.client.api.JacksonTimeModule;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigElement;
import io.digdag.client.config.ConfigFactory;
import io.digdag.commons.ThrowablesUtil;
import io.digdag.core.EnvironmentModule;
import io.digdag.core.ExtensionServiceLoaderModule;
import io.digdag.core.Limits;
import io.digdag.core.LocalSite;
import io.digdag.core.TempFileManager;
import io.digdag.core.agent.AgentModule;
import io.digdag.core.agent.LocalAgentModule;
import io.digdag.core.archive.ProjectArchiveLoader;
import io.digdag.core.config.ConfigModule;
import io.digdag.core.database.DatabaseModule;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.log.LogModule;
import io.digdag.core.notification.NotificationModule;
import io.digdag.core.plugin.DynamicPluginModule;
import io.digdag.core.plugin.PluginSet;
import io.digdag.core.plugin.SystemPluginModule;
import io.digdag.core.queue.QueueModule;
import io.digdag.core.schedule.ScheduleExecutorModule;
import io.digdag.core.schedule.ScheduleModule;
import io.digdag.core.storage.StorageModule;
import io.digdag.core.workflow.WorkflowExecutorModule;
import io.digdag.core.workflow.WorkflowModule;
import io.digdag.metrics.StdDigdagMetrics;
import io.digdag.spi.metrics.DigdagMetrics;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.embulk.guice.LifeCycleInjector;

public class DigdagEmbed
implements AutoCloseable {
    private final LifeCycleInjector injector;

    DigdagEmbed(LifeCycleInjector injector) {
        this.injector = injector;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public LocalSite getLocalSite() {
        return (LocalSite)this.getInjector().getInstance(LocalSite.class);
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.getInjector().getInstance(TransactionManager.class);
    }

    @Override
    public void close() throws Exception {
        this.injector.destroy();
    }

    public static class TempFileManagerProvider
    implements Provider<TempFileManager> {
        private final TempFileManager manager;

        @Inject
        public TempFileManagerProvider(Config systemConfig) {
            Path dir = (Path)systemConfig.getOptional("tmpdir", String.class).transform(s -> Paths.get(s, new String[0])).or(() -> {
                try {
                    return Files.createTempDirectory("digdag-tempdir", new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw ThrowablesUtil.propagate((Throwable)ex);
                }
            });
            this.manager = new TempFileManager(dir);
        }

        public TempFileManager get() {
            return this.manager;
        }
    }

    public static class SystemConfigProvider
    implements Provider<Config> {
        private Config systemConfig;

        @Inject
        public SystemConfigProvider(ConfigElement ce, ConfigFactory cf) {
            this.systemConfig = ce.toConfig(cf);
        }

        public Config get() {
            return this.systemConfig;
        }
    }

    public static class Bootstrap {
        private final List<Function<? super List<Module>, ? extends Iterable<? extends Module>>> moduleOverrides = new ArrayList<Function<? super List<Module>, ? extends Iterable<? extends Module>>>();
        private ConfigElement systemConfig = ConfigElement.empty();
        private PluginSet systemPlugins = PluginSet.empty();
        private boolean withWorkflowExecutor = true;
        private boolean withScheduleExecutor = true;
        private boolean withLocalAgent = true;
        private boolean withExtensionLoader = true;
        private boolean withTaskQueueServer = true;
        private Map<String, String> environment = ImmutableMap.of();

        public Bootstrap addModules(Module ... additionalModules) {
            return this.addModules(Arrays.asList(additionalModules));
        }

        public Bootstrap addModules(Iterable<? extends Module> additionalModules) {
            ImmutableList copy = ImmutableList.copyOf(additionalModules);
            return this.overrideModules((Function<? super List<Module>, ? extends Iterable<? extends Module>>)((Function)arg_0 -> Bootstrap.lambda$addModules$0((List)copy, arg_0)));
        }

        public Bootstrap overrideModules(Function<? super List<Module>, ? extends Iterable<? extends Module>> function) {
            this.moduleOverrides.add(function);
            return this;
        }

        public Bootstrap overrideModulesWith(Module ... overridingModules) {
            return this.overrideModulesWith(Arrays.asList(overridingModules));
        }

        public Bootstrap overrideModulesWith(Iterable<? extends Module> overridingModules) {
            return this.overrideModules((Function<? super List<Module>, ? extends Iterable<? extends Module>>)((Function)modules -> ImmutableList.of((Object)Modules.override((Iterable)modules).with(overridingModules))));
        }

        public Bootstrap setEnvironment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public Bootstrap setSystemConfig(ConfigElement systemConfig) {
            this.systemConfig = systemConfig;
            return this;
        }

        public Bootstrap setSystemPlugins(PluginSet systemPlugins) {
            this.systemPlugins = systemPlugins;
            return this;
        }

        public Bootstrap withWorkflowExecutor(boolean v) {
            this.withWorkflowExecutor = v;
            return this;
        }

        public Bootstrap withScheduleExecutor(boolean v) {
            this.withScheduleExecutor = v;
            return this;
        }

        public Bootstrap withLocalAgent(boolean v) {
            this.withLocalAgent = v;
            return this;
        }

        public Bootstrap withExtensionLoader(boolean v) {
            this.withExtensionLoader = v;
            return this;
        }

        public Bootstrap withTaskQueueServer(boolean v) {
            this.withTaskQueueServer = v;
            return this;
        }

        public DigdagEmbed initialize() {
            return this.build(true);
        }

        public DigdagEmbed initializeWithoutShutdownHook() {
            return this.build(false);
        }

        private DigdagEmbed build(boolean destroyOnShutdownHook) {
            org.embulk.guice.Bootstrap bootstrap = this.build();
            Object injector = destroyOnShutdownHook ? bootstrap.initialize() : bootstrap.initializeCloseable();
            return new DigdagEmbed((LifeCycleInjector)injector);
        }

        public org.embulk.guice.Bootstrap build() {
            org.embulk.guice.Bootstrap bootstrap = new org.embulk.guice.Bootstrap(new Module[0]).requireExplicitBindings(true).addModules(this.standardModules(this.systemConfig));
            this.moduleOverrides.stream().forEach(override -> bootstrap.overrideModules(override));
            return bootstrap;
        }

        private List<Module> standardModules(ConfigElement systemConfig) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(Arrays.asList(new ObjectMapperModule().registerModule((com.fasterxml.jackson.databind.Module)new GuavaModule()).registerModule((com.fasterxml.jackson.databind.Module)new JacksonTimeModule()), new DynamicPluginModule(), new SystemPluginModule(this.systemPlugins), new DatabaseModule(this.withTaskQueueServer), new AgentModule(), new LogModule(), new ScheduleModule(), new ConfigModule(), new WorkflowModule(), new NotificationModule(), new StorageModule(), new EnvironmentModule(this.environment), binder -> {
                binder.bind(ProjectArchiveLoader.class);
                binder.bind(ConfigElement.class).toInstance((Object)systemConfig);
                binder.bind(Config.class).toProvider(SystemConfigProvider.class);
                binder.bind(TempFileManager.class).toProvider(TempFileManagerProvider.class).in(Scopes.SINGLETON);
                binder.bind(DigdagMetrics.class).toInstance((Object)StdDigdagMetrics.empty());
                binder.bind(Limits.class).asEagerSingleton();
            }));
            if (this.withWorkflowExecutor) {
                builder.add((Object)new WorkflowExecutorModule());
            }
            if (this.withScheduleExecutor) {
                builder.add((Object)new ScheduleExecutorModule());
            }
            if (this.withLocalAgent) {
                builder.add((Object)new LocalAgentModule());
            }
            if (this.withWorkflowExecutor) {
                builder.add(binder -> binder.bind(LocalSite.class).in(Scopes.SINGLETON));
            }
            if (this.withExtensionLoader) {
                builder.add((Object)new ExtensionServiceLoaderModule());
            }
            if (this.withTaskQueueServer) {
                builder.add((Object)new QueueModule());
            }
            return builder.build();
        }

        private static /* synthetic */ Iterable lambda$addModules$0(List copy, List modules) {
            return Iterables.concat((Iterable)modules, (Iterable)copy);
        }
    }
}

