/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage.commit.uccommitcoordinator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import io.delta.storage.commit.Commit;
import io.delta.storage.commit.CommitFailedException;
import io.delta.storage.commit.CoordinatedCommitsUtils;
import io.delta.storage.commit.GetCommitsResponse;
import io.delta.storage.commit.actions.AbstractMetadata;
import io.delta.storage.commit.actions.AbstractProtocol;
import io.delta.storage.commit.uccommitcoordinator.CommitLimitReachedException;
import io.delta.storage.commit.uccommitcoordinator.InvalidTargetTableException;
import io.delta.storage.commit.uccommitcoordinator.UCClient;
import io.delta.storage.commit.uccommitcoordinator.UCCommitCoordinatorException;
import io.delta.storage.commit.uccommitcoordinator.UCRestClientPayload;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class UCTokenBasedRestClient
implements UCClient {
    private final String baseUri;
    private final ObjectMapper mapper;
    private final CloseableHttpClient httpClient;

    public UCTokenBasedRestClient(String string, String string2) {
        this.baseUri = UCTokenBasedRestClient.resolve(string, "/api/2.1/unity-catalog");
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        this.httpClient = HttpClientBuilder.create().setDefaultHeaders(Arrays.asList(new BasicHeader("Authorization", "Bearer " + string2), new BasicHeader("Accept", ContentType.APPLICATION_JSON.getMimeType()), new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()))).build();
    }

    private static String resolve(String string, String string2) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string + string2;
    }

    private <T> String toJson(T t) throws JsonProcessingException {
        return this.mapper.writeValueAsString(t);
    }

    private <T> T fromJson(String string, Class<T> clazz) throws JsonProcessingException {
        return (T)this.mapper.readValue(string, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeHttpRequest(HttpUriRequest httpUriRequest, Object object, Class<T> clazz) throws IOException, HttpError {
        Object object2;
        if (object != null && httpUriRequest instanceof HttpEntityEnclosingRequestBase) {
            object2 = this.toJson(object);
            ((HttpEntityEnclosingRequestBase)httpUriRequest).setEntity((HttpEntity)new StringEntity((String)object2, ContentType.APPLICATION_JSON));
        }
        try {
            object2 = this.httpClient.execute(httpUriRequest);
            try {
                int n = object2.getStatusLine().getStatusCode();
                String string = EntityUtils.toString((HttpEntity)object2.getEntity());
                if (n != 200) {
                    if (n != 201) throw new HttpError(n, string);
                }
                T t = this.fromJson(string, clazz);
                return t;
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IOException("Failed to parse response", jsonProcessingException);
        }
    }

    @Override
    public String getMetastoreId() throws IOException {
        URI uRI = URI.create(UCTokenBasedRestClient.resolve(this.baseUri, "/metastore_summary"));
        HttpGet httpGet = new HttpGet(uRI);
        try {
            UCRestClientPayload.GetMetastoreSummaryResponse getMetastoreSummaryResponse = this.executeHttpRequest((HttpUriRequest)httpGet, null, UCRestClientPayload.GetMetastoreSummaryResponse.class);
            return getMetastoreSummaryResponse.metastoreId;
        }
        catch (HttpError httpError) {
            throw new IOException("Failed to get metastore ID (HTTP " + httpError.statusCode + "): " + httpError.responseBody);
        }
    }

    @Override
    public void commit(String string, URI uRI, Optional<Commit> optional, Optional<Long> optional2, boolean bl, Optional<AbstractMetadata> optional3, Optional<AbstractProtocol> optional4) throws IOException, CommitFailedException, UCCommitCoordinatorException {
        Objects.requireNonNull(string, "tableId must not be null.");
        Objects.requireNonNull(uRI, "tableUri must not be null.");
        UCRestClientPayload.CommitRequest commitRequest = new UCRestClientPayload.CommitRequest();
        commitRequest.tableId = string;
        commitRequest.tableUri = uRI.toString();
        optional.ifPresent(commit -> {
            commitRequest.commitInfo = UCRestClientPayload.CommitInfo.fromCommit(commit, bl);
        });
        optional2.ifPresent(l -> {
            commitRequest.latestBackfilledVersion = l;
        });
        optional3.ifPresent(abstractMetadata -> {
            commitRequest.metadata = UCRestClientPayload.Metadata.fromAbstractMetadata(abstractMetadata);
        });
        optional4.ifPresent(abstractProtocol -> {
            commitRequest.protocol = UCRestClientPayload.Protocol.fromAbstractProtocol(abstractProtocol);
        });
        URI uRI2 = URI.create(UCTokenBasedRestClient.resolve(this.baseUri, "/delta/preview/commits"));
        HttpPost httpPost = new HttpPost(uRI2);
        try {
            this.executeHttpRequest((HttpUriRequest)httpPost, commitRequest, Void.class);
        }
        catch (HttpError httpError) {
            switch (httpError.statusCode) {
                case 400: {
                    throw new CommitFailedException(false, false, "Invalid commit parameters: " + httpError.responseBody, httpError);
                }
                case 404: {
                    throw new InvalidTargetTableException("Invalid Target Table: " + httpError.responseBody);
                }
                case 409: {
                    throw new CommitFailedException(true, true, "Commit conflict: " + httpError.responseBody, httpError);
                }
                case 429: {
                    throw new CommitLimitReachedException("Backfilled commits limit reached: " + httpError.responseBody);
                }
            }
            throw new CommitFailedException(true, false, "Unexpected commit failure (HTTP " + httpError.statusCode + "): " + httpError.responseBody, httpError);
        }
    }

    @Override
    public GetCommitsResponse getCommits(String string, URI uRI, Optional<Long> optional, Optional<Long> optional2) throws IOException, UCCommitCoordinatorException {
        Objects.requireNonNull(string, "tableId must not be null.");
        Objects.requireNonNull(uRI, "tableUri must not be null.");
        UCRestClientPayload.GetCommitsRequest getCommitsRequest = new UCRestClientPayload.GetCommitsRequest();
        getCommitsRequest.tableId = string;
        getCommitsRequest.tableUri = uRI.toString();
        getCommitsRequest.startVersion = optional.orElse(0L);
        optional2.ifPresent(l -> {
            getCommitsRequest.endVersion = l;
        });
        URI uRI2 = URI.create(UCTokenBasedRestClient.resolve(this.baseUri, "/delta/preview/commits"));
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = new HttpEntityEnclosingRequestBase(){

            public String getMethod() {
                return "GET";
            }
        };
        httpEntityEnclosingRequestBase.setURI(uRI2);
        try {
            UCRestClientPayload.RestGetCommitsResponse restGetCommitsResponse = this.executeHttpRequest((HttpUriRequest)httpEntityEnclosingRequestBase, getCommitsRequest, UCRestClientPayload.RestGetCommitsResponse.class);
            Path path = CoordinatedCommitsUtils.commitDirPath(CoordinatedCommitsUtils.logDirPath(new Path(uRI)));
            ArrayList<Commit> arrayList = new ArrayList<Commit>();
            if (restGetCommitsResponse.commits != null) {
                for (UCRestClientPayload.CommitInfo commitInfo : restGetCommitsResponse.commits) {
                    arrayList.add(UCRestClientPayload.CommitInfo.toCommit(commitInfo, path));
                }
            }
            return new GetCommitsResponse(arrayList, restGetCommitsResponse.latestTableVersion);
        }
        catch (HttpError httpError) {
            switch (httpError.statusCode) {
                case 404: {
                    throw new InvalidTargetTableException("Invalid Target Table due to: " + httpError.responseBody);
                }
            }
            throw new IOException("Unexpected getCommits failure (HTTP " + httpError.statusCode + "): due to: " + httpError.responseBody);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private static class HttpError
    extends Throwable {
        final int statusCode;
        final String responseBody;

        HttpError(int n, String string) {
            super("HTTP Error " + n + ": " + string);
            this.statusCode = n;
            this.responseBody = string;
        }
    }
}

