/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage.commit.uccommitcoordinator;

import io.delta.storage.CloseableIterator;
import io.delta.storage.LogStore;
import io.delta.storage.commit.Commit;
import io.delta.storage.commit.CommitCoordinatorClient;
import io.delta.storage.commit.CommitFailedException;
import io.delta.storage.commit.CommitResponse;
import io.delta.storage.commit.CoordinatedCommitsUtils;
import io.delta.storage.commit.GetCommitsResponse;
import io.delta.storage.commit.TableDescriptor;
import io.delta.storage.commit.TableIdentifier;
import io.delta.storage.commit.UpdatedActions;
import io.delta.storage.commit.actions.AbstractMetadata;
import io.delta.storage.commit.actions.AbstractProtocol;
import io.delta.storage.commit.uccommitcoordinator.CommitLimitReachedException;
import io.delta.storage.commit.uccommitcoordinator.InvalidTargetTableException;
import io.delta.storage.commit.uccommitcoordinator.UCClient;
import io.delta.storage.commit.uccommitcoordinator.UCCommitCoordinatorException;
import io.delta.storage.commit.uccommitcoordinator.UpgradeNotAllowedException;
import io.delta.storage.internal.FileNameUtils;
import io.delta.storage.internal.LogStoreErrors;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileAlreadyExistsException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UCCommitCoordinatorClient
implements CommitCoordinatorClient {
    private static final Logger LOG = LoggerFactory.getLogger(UCCommitCoordinatorClient.class);
    private static final int SUPPORTED_READ_VERSION = 0;
    private static final int SUPPORTED_WRITE_VERSION = 0;
    private static final String READ_VERSION_KEY = "readVersion";
    private static final String WRITE_VERSION_KEY = "writeVersion";
    public static final String UC_TABLE_ID_KEY = "ucTableId";
    public static final String UC_METASTORE_ID_KEY = "ucMetastoreId";
    public static int BACKFILL_LISTING_OFFSET = 100;
    protected static final int MAX_RETRIES_ON_TRANSIENT_ERROR = 15;
    protected static final long TRANSIENT_ERROR_RETRY_INITIAL_WAIT_MS = 100L;
    protected static final long TRANSIENT_ERROR_RETRY_MAX_WAIT_MS = 60000L;
    protected static int THREAD_POOL_SIZE = 20;
    private static final ThreadPoolExecutor asyncExecutor = new ThreadPoolExecutor(THREAD_POOL_SIZE, THREAD_POOL_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new ThreadFactory(){
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(@Nonnull Runnable runnable) {
            Thread thread = this.defaultFactory.newThread(runnable);
            thread.setName("uc-commit-coordinator-" + thread.getName());
            thread.setDaemon(true);
            return thread;
        }
    });
    public final UCClient ucClient;
    public final Map<String, String> conf;

    public UCCommitCoordinatorClient(Map<String, String> map, UCClient uCClient) {
        this.conf = map;
        this.ucClient = uCClient;
    }

    protected <T> Future<T> executeAsync(Callable<T> callable) {
        return asyncExecutor.submit(callable);
    }

    protected String extractUCTableId(TableDescriptor tableDescriptor) {
        Map<String, String> map = tableDescriptor.getTableConf();
        if (!map.containsKey(UC_TABLE_ID_KEY)) {
            throw new IllegalStateException("UC Table ID not found in " + map);
        }
        return map.get(UC_TABLE_ID_KEY);
    }

    @Override
    public Map<String, String> registerTable(Path path, Optional<TableIdentifier> optional, long l, AbstractMetadata abstractMetadata, AbstractProtocol abstractProtocol) {
        Map<String, String> map = CoordinatedCommitsUtils.getTableConf(abstractMetadata);
        this.checkVersionSupported(map, false);
        if (!map.containsKey(UC_TABLE_ID_KEY)) {
            throw new IllegalStateException("Could not verify if the table is registered with the UC commit coordinator because the table ID is missing from the table metadata.");
        }
        if (!CoordinatedCommitsUtils.getCoordinatorConf(abstractMetadata).containsKey(UC_METASTORE_ID_KEY)) {
            throw new IllegalStateException("Could not verify if the table is registered with the UC commit coordinator because the metastore ID is missing from the table metadata.");
        }
        return map;
    }

    public long getLastKnownBackfilledVersion(final long l, Configuration configuration, LogStore logStore, final TableDescriptor tableDescriptor) {
        Path path = tableDescriptor.getLogPath();
        final long l2 = Math.max(0L, l - (long)BACKFILL_LISTING_OFFSET);
        Optional<Long> optional = this.listAndGetLastKnownBackfilledVersion(l2, logStore, configuration, path);
        if (!optional.isPresent()) {
            this.recordDeltaEvent("delta.coordinatedCommits.uc.lastKnownBackfilledVersionNotFound", new HashMap<String, Object>(){
                {
                    this.put("commitVersion", l);
                    this.put("conf", UCCommitCoordinatorClient.this.conf);
                    this.put("listFromVersion", l2);
                    this.put("tableConf", tableDescriptor.getTableConf());
                }
            }, path.getParent());
            long l3 = this.getCommits(tableDescriptor, null, null).getCommits().stream().min(Comparator.comparingLong(Commit::getVersion)).map(Commit::getVersion).orElseThrow(() -> new IllegalStateException("Couldn't find any unbackfilled commit for table at " + path + " at version " + l));
            optional = this.listAndGetLastKnownBackfilledVersion(l3 - 1L, logStore, configuration, path);
            if (!optional.isPresent()) {
                throw new IllegalStateException("Couldn't find any backfilled commit for table at " + path + " at version " + l);
            }
        }
        return optional.get();
    }

    protected Iterator<FileStatus> listFrom(LogStore logStore, long l, Configuration configuration, Path path) {
        Path path2 = CoordinatedCommitsUtils.getBackfilledDeltaFilePath(path, l);
        try {
            return logStore.listFrom(path2, configuration);
        }
        catch (IOException iOException) {
            LOG.error("Failed to list files from {} due to: {}", (Object)path2, (Object)this.exceptionString(iOException));
            throw new IllegalStateException(iOException);
        }
    }

    protected Optional<Long> listAndGetLastKnownBackfilledVersion(long l, LogStore logStore, Configuration configuration, Path path) {
        Optional<Long> optional = Optional.empty();
        Iterator<FileStatus> iterator = this.listFrom(logStore, l, configuration, path);
        while (iterator.hasNext()) {
            FileStatus fileStatus = iterator.next();
            if (!FileNameUtils.isDeltaFile(fileStatus.getPath())) continue;
            optional = Optional.of(FileNameUtils.deltaVersion(fileStatus.getPath()));
        }
        return optional;
    }

    @Override
    public CommitResponse commit(LogStore logStore, Configuration configuration, TableDescriptor tableDescriptor, long l, Iterator<String> iterator, UpdatedActions updatedActions) throws CommitFailedException {
        return this.commitImpl(logStore, configuration, tableDescriptor, l, iterator, updatedActions);
    }

    protected CommitResponse commitImpl(LogStore logStore, Configuration configuration, TableDescriptor tableDescriptor, long l3, Iterator<String> iterator, UpdatedActions updatedActions) throws CommitFailedException {
        long l4;
        FileStatus fileStatus;
        BiConsumer<Optional, String> biConsumer;
        block27: {
            Future<Long> future;
            Path path = tableDescriptor.getLogPath();
            Map<String, String> map = tableDescriptor.getTableConf();
            this.checkVersionSupported(map, false);
            this.checkVersionSupported(map, true);
            if (l3 == 0L) {
                throw new CommitFailedException(false, false, "Commit version 0 must go via filesystem.");
            }
            long l5 = System.currentTimeMillis();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("commitVersion", l3);
            hashMap.put("coordinatedCommitsTableConf", map);
            hashMap.put("updatedActions", updatedActions);
            biConsumer = (optional, string) -> {
                optional.ifPresent(throwable -> {
                    hashMap.put("exceptionClass", throwable.getClass().getName());
                    hashMap.put("exceptionString", this.exceptionString((Throwable)throwable));
                });
                hashMap.put("totalTimeTakenMs", System.currentTimeMillis() - l5);
                this.recordDeltaEvent((String)string, hashMap, path.getParent());
            };
            String string2 = this.extractUCTableId(tableDescriptor);
            LOG.info("Attempting to commit version " + l3 + " to table " + string2);
            AtomicLong atomicLong = new AtomicLong(System.currentTimeMillis());
            try {
                future = this.executeAsync(() -> {
                    long l3 = this.getLastKnownBackfilledVersion(l3, configuration, logStore, tableDescriptor);
                    atomicLong.getAndUpdate(l -> System.currentTimeMillis() - l);
                    return l3;
                });
            }
            catch (Exception exception) {
                LOG.warn("Error while submitting task to verify/retrieve last known backfilled version due to: " + this.exceptionString(exception) + ". Verifying/retrieving synchronously");
                biConsumer.accept(Optional.of(exception), "delta.coordinatedCommits.uc.backfillValidation.fallbackToSync");
                long l6 = this.getLastKnownBackfilledVersion(l3, configuration, logStore, tableDescriptor);
                atomicLong.getAndUpdate(l -> System.currentTimeMillis() - l);
                future = CompletableFuture.completedFuture(l6);
            }
            long l7 = System.currentTimeMillis();
            try {
                fileStatus = CoordinatedCommitsUtils.writeUnbackfilledCommitFile(logStore, configuration, path.toString(), l3, iterator, UUID.randomUUID().toString());
            }
            catch (IOException iOException) {
                throw new CommitFailedException(true, false, "Failed to write commit file due to: " + iOException.getMessage(), iOException);
            }
            hashMap.put("writeCommitFileTimeTakenMs", System.currentTimeMillis() - l7);
            AtomicLong atomicLong2 = new AtomicLong();
            try {
                atomicLong2.set(future.get());
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new RuntimeException(exception);
            }
            l4 = updatedActions.getCommitInfo().getCommitTimestamp();
            boolean bl = this.isDisownCommit(updatedActions.getOldMetadata(), updatedActions.getNewMetadata());
            hashMap.put("tableId", string2);
            hashMap.put("lastKnownBackfilledVersion", atomicLong2.get());
            hashMap.put("commitTimestamp", l4);
            hashMap.put("disown", bl);
            hashMap.put("timeSpentInGettingLastKnownBackfilledVersion", atomicLong);
            int n = 0;
            while (n <= 15) {
                try {
                    this.commitToUC(tableDescriptor, path, Optional.of(fileStatus), Optional.of(l3), Optional.of(l4), Optional.of(atomicLong2.get()), bl, updatedActions.getNewMetadata() == updatedActions.getOldMetadata() ? Optional.empty() : Optional.of(updatedActions.getNewMetadata()), updatedActions.getNewProtocol() == updatedActions.getOldProtocol() ? Optional.empty() : Optional.of(updatedActions.getNewProtocol()));
                    break;
                }
                catch (CommitFailedException commitFailedException) {
                    if (n > 0 && commitFailedException.getConflict() && commitFailedException.getRetryable() && this.hasSameContent(logStore, configuration, path, CoordinatedCommitsUtils.getBackfilledDeltaFilePath(path, l3), fileStatus.getPath())) {
                        hashMap.put("alreadyBackfilledCommitCausedConflict", true);
                        break;
                    }
                    biConsumer.accept(Optional.of(commitFailedException), "delta.coordinatedCommits.uc.commitStats");
                    throw commitFailedException;
                }
                catch (IOException iOException) {
                    if (n == 15) {
                        biConsumer.accept(Optional.of(iOException), "delta.coordinatedCommits.uc.commitStats");
                        throw new CommitFailedException(true, false, iOException.getMessage(), iOException);
                    }
                    long l8 = Math.min(100L << n, 60000L);
                    LOG.info("Sleeping for " + l8 + "ms before retrying commit after transient error " + iOException.getMessage());
                    try {
                        Thread.sleep(l8);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                    hashMap.put("transientErrorRetryCount", ++n);
                }
                catch (UpgradeNotAllowedException upgradeNotAllowedException) {
                    biConsumer.accept(Optional.of(upgradeNotAllowedException), "delta.coordinatedCommits.uc.commitStats");
                    throw new CommitFailedException(false, false, upgradeNotAllowedException.getMessage(), upgradeNotAllowedException);
                }
                catch (InvalidTargetTableException invalidTargetTableException) {
                    biConsumer.accept(Optional.of(invalidTargetTableException), "delta.coordinatedCommits.uc.commitStats");
                    throw new CommitFailedException(false, false, invalidTargetTableException.getMessage(), invalidTargetTableException);
                }
                catch (CommitLimitReachedException commitLimitReachedException) {
                    try {
                        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
                        atomicLong2.getAndUpdate(l2 -> {
                            try {
                                return this.attemptFullBackfill(logStore, configuration, tableDescriptor, l3, string2, l2, hashMap);
                            }
                            catch (Exception exception) {
                                atomicReference.set(exception);
                                return l2;
                            }
                        });
                        if (atomicReference.get() != null) {
                            throw (Exception)atomicReference.get();
                        }
                    }
                    catch (Throwable throwable) {
                        biConsumer.accept(Optional.of(throwable), "delta.coordinatedCommits.uc.fullBackfillAttemptFailed");
                        String string3 = String.format("Commit limit reached (%s) for table %s. A full backfill attempt failed due to: %s", this.exceptionString(commitLimitReachedException), string2, this.exceptionString(throwable));
                        throw new CommitFailedException(true, false, string3, commitLimitReachedException);
                    }
                    hashMap.put("lastKnownBackfilledVersion", atomicLong2.get());
                    hashMap.put("encounteredCommitLimitReachedException", true);
                }
                catch (UCCommitCoordinatorException uCCommitCoordinatorException) {
                    biConsumer.accept(Optional.of(uCCommitCoordinatorException), "delta.coordinatedCommits.uc.commitStats");
                    throw new CommitFailedException(false, false, uCCommitCoordinatorException.getMessage(), uCCommitCoordinatorException);
                }
            }
            LOG.info("Successfully wrote " + fileStatus.getPath() + " as commit " + l3 + " to table " + string2);
            Callable<Void> callable = () -> {
                this.backfillToVersion(logStore, configuration, tableDescriptor, l3, atomicLong2.get());
                return null;
            };
            try {
                this.executeAsync(callable);
            }
            catch (Throwable throwable) {
                if (LogStoreErrors.isFatal(throwable)) {
                    throw throwable;
                }
                LOG.warn("Error while submitting backfill task: " + this.exceptionString(throwable) + ". Performing synchronous backfill now.");
                biConsumer.accept(Optional.of(throwable), "delta.coordinatedCommits.uc.backfill.fallbackToSync");
                try {
                    callable.call();
                }
                catch (Throwable throwable2) {
                    if (!LogStoreErrors.isFatal(throwable2)) break block27;
                    throw new RuntimeException(throwable2);
                }
            }
        }
        biConsumer.accept(Optional.empty(), "delta.coordinatedCommits.uc.commitStats");
        return new CommitResponse(new Commit(l3, fileStatus, l4));
    }

    protected long attemptFullBackfill(LogStore logStore, Configuration configuration, final TableDescriptor tableDescriptor, final long l, final String string, final long l2, Map<String, Object> map) throws IOException, UCCommitCoordinatorException, CommitFailedException {
        Path path = tableDescriptor.getLogPath();
        LOG.info("Too many unbackfilled commits in UC at version {} for table at {} and ID {}. Last known backfill version is {}. Attempting a full backfill.", new Object[]{l, path, string, l2});
        long l3 = System.currentTimeMillis();
        this.backfillToVersion(logStore, configuration, tableDescriptor, l, l2);
        final long l4 = System.currentTimeMillis() - l3;
        final long l5 = this.getLastKnownBackfilledVersion(l, configuration, logStore, tableDescriptor);
        long l6 = System.currentTimeMillis();
        this.commitToUC(tableDescriptor, path, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(l5), true, Optional.empty(), Optional.empty());
        final long l7 = System.currentTimeMillis() - l6;
        this.recordDeltaEvent("delta.coordinatedCommits.uc.attemptFullBackfill", new HashMap<String, Object>(map){
            {
                super(map);
                this.put("commitVersion", l);
                this.put("coordinatedCommitsTableConf", tableDescriptor.getTableConf());
                this.put("lastKnownBackfilledVersion", l2);
                this.put("updatedLastKnownBackfilledVersion", l5);
                this.put("tableId", string);
                this.put("backfillTime", l4);
                this.put("ucCommitTime", l7);
            }
        }, path.getParent());
        return l5;
    }

    protected void commitToUC(TableDescriptor tableDescriptor, Path path, Optional<FileStatus> optional, Optional<Long> optional2, Optional<Long> optional3, Optional<Long> optional4, boolean bl, Optional<AbstractMetadata> optional5, Optional<AbstractProtocol> optional6) throws IOException, CommitFailedException, UCCommitCoordinatorException {
        Optional<Commit> optional7 = optional.map(fileStatus -> new Commit((Long)optional2.orElseThrow(() -> new IllegalArgumentException("Commit version should be specified when commitFile is present")), (FileStatus)fileStatus, (Long)optional3.orElseThrow(() -> new IllegalArgumentException("Commit timestamp should be specified when commitFile is present"))));
        this.ucClient.commit(this.extractUCTableId(tableDescriptor), CoordinatedCommitsUtils.getTablePath(path).toUri(), optional7, optional4, bl, optional5, optional6);
    }

    protected boolean isDisownCommit(AbstractMetadata abstractMetadata, AbstractMetadata abstractMetadata2) {
        return CoordinatedCommitsUtils.getCoordinatorName(abstractMetadata).filter("unity-catalog"::equals).isPresent() && !CoordinatedCommitsUtils.getCoordinatorName(abstractMetadata2).isPresent();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean hasSameContent(LogStore logStore, Configuration configuration, Path path, Path path2, Path path3) {
        Object object;
        try {
            object = path.getFileSystem(configuration);
            if (object.getFileStatus(path2).getLen() != object.getFileStatus(path3).getLen()) {
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        try {
            object = logStore.read(path2, configuration);
            try {
                boolean bl;
                block22: {
                    boolean bl2;
                    CloseableIterator<String> closeableIterator = logStore.read(path3, configuration);
                    try {
                        while (closeableIterator.hasNext() && object.hasNext()) {
                            if (((String)closeableIterator.next()).equals(object.next())) continue;
                            bl2 = false;
                            if (closeableIterator == null) break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (closeableIterator != null) {
                            try {
                                closeableIterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    {
                        block21: {
                            closeableIterator.close();
                        }
                        return bl2;
                    }
                    boolean bl3 = bl = !object.hasNext() && !closeableIterator.hasNext();
                    if (closeableIterator == null) break block22;
                    closeableIterator.close();
                }
                return bl;
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public GetCommitsResponse getCommits(TableDescriptor tableDescriptor, Long l, Long l2) {
        this.checkVersionSupported(tableDescriptor.getTableConf(), true);
        GetCommitsResponse getCommitsResponse = this.getCommitsFromUCImpl(tableDescriptor, Optional.ofNullable(l), Optional.ofNullable(l2));
        List<Commit> list = getCommitsResponse.getCommits().stream().sorted(Comparator.comparingLong(Commit::getVersion)).collect(Collectors.toList());
        return new GetCommitsResponse(list, getCommitsResponse.getLatestTableVersion());
    }

    protected GetCommitsResponse getCommitsFromUCImpl(TableDescriptor tableDescriptor, Optional<Long> optional, Optional<Long> optional2) {
        try {
            return this.ucClient.getCommits(this.extractUCTableId(tableDescriptor), CoordinatedCommitsUtils.getTablePath(tableDescriptor.getLogPath()).toUri(), optional, optional2);
        }
        catch (UCCommitCoordinatorException | IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void backfillToVersion(LogStore logStore, Configuration configuration, final TableDescriptor tableDescriptor, final long l, final Long l2) throws IOException {
        Commit commit;
        boolean bl;
        Object object;
        this.checkVersionSupported(tableDescriptor.getTableConf(), true);
        this.checkVersionSupported(tableDescriptor.getTableConf(), false);
        Path path = tableDescriptor.getLogPath();
        final String string = this.extractUCTableId(tableDescriptor);
        long l3 = l2 == null ? 0L : l2;
        final long l4 = System.currentTimeMillis();
        LOG.info("Backfilling {}: startVersion {} to endVersion {}", new Object[]{string, l3, l});
        if (l2 != null && !(object = path.getFileSystem(configuration)).exists(CoordinatedCommitsUtils.getBackfilledDeltaFilePath(path, l2))) {
            LOG.error("Specified last known backfilled version {} does not exist for table {}", (Object)l2, (Object)string);
            this.recordDeltaEvent("delta.coordinatedCommits.uc.backfillDoesNotExist", new HashMap<String, Object>(){
                {
                    this.put("lastKnownBackfilledVersion", l2);
                    this.put("version", l);
                    this.put("tableConf", tableDescriptor.getTableConf());
                }
            }, path.getParent());
            throw new IllegalStateException("Last known backfilled version " + l2 + " doesn't exist for table at " + path);
        }
        object = this.getCommits(tableDescriptor, l2, l);
        Iterator<Commit> iterator = ((GetCommitsResponse)object).getCommits().iterator();
        while (iterator.hasNext() && (bl = this.backfillSingleCommit(logStore, configuration, path, (commit = iterator.next()).getVersion(), commit.getFileStatus(), false))) {
        }
        this.recordDeltaEvent("delta.coordinatedCommits.uc.backfillToVersion", new HashMap<String, Object>(){
            {
                this.put("coordinatedCommitsTableConf", tableDescriptor.getTableConf());
                this.put("totalTimeTakenMs", System.currentTimeMillis() - l4);
                this.put("lastKnownBackfilledVersion", l2);
                this.put("tableId", string);
                this.put("version", l);
            }
        }, path.getParent());
    }

    protected boolean backfillSingleCommit(LogStore logStore, Configuration configuration, Path path, final long l, FileStatus fileStatus, Boolean bl) {
        Path path2 = CoordinatedCommitsUtils.getBackfilledDeltaFilePath(path, l);
        try (CloseableIterator<String> closeableIterator = logStore.read(fileStatus.getPath(), configuration);){
            logStore.write(path2, closeableIterator, false, configuration);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            LOG.info("The backfilled file {} already exists.", (Object)path2);
        }
        catch (Exception exception) {
            if (LogStoreErrors.isFatal(exception) || bl.booleanValue()) {
                throw new RuntimeException(exception);
            }
            LOG.warn("Backfill for table at {} failed for version {} due to: {}", new Object[]{path, l, this.exceptionString(exception)});
            this.recordDeltaEvent("delta.coordinatedCommits.uc.backfillFailed", new HashMap<String, Object>(){
                {
                    this.put("version", l);
                    this.put("exceptionClass", exception.getClass().getName());
                    this.put("exceptionString", UCCommitCoordinatorClient.this.exceptionString(exception));
                }
            }, path.getParent());
            return false;
        }
        return true;
    }

    @Override
    public boolean semanticEquals(CommitCoordinatorClient commitCoordinatorClient) {
        if (!(commitCoordinatorClient instanceof UCCommitCoordinatorClient)) {
            return false;
        }
        UCCommitCoordinatorClient uCCommitCoordinatorClient = (UCCommitCoordinatorClient)commitCoordinatorClient;
        return this.conf == uCCommitCoordinatorClient.conf;
    }

    protected void recordDeltaEvent(String string, Object object, Path path) {
        LOG.info("Delta event recorded with opType={}, data={}, and path={}", new Object[]{string, object, path});
    }

    protected String exceptionString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    protected void checkVersionSupported(Map<String, String> map, boolean bl) {
        String string;
        int n = Integer.parseInt(map.getOrDefault(READ_VERSION_KEY, "0"));
        int n2 = Integer.parseInt(map.getOrDefault(WRITE_VERSION_KEY, "0"));
        int n3 = bl ? n : n2;
        int n4 = bl ? 0 : 0;
        String string2 = string = bl ? "read" : "write";
        if (n4 != n3) {
            throw new UnsupportedOperationException("The version of the UC commit coordinator protocol is not supported by this version of the UC commit coordinator client. Please upgrade the commit coordinator client to " + string + " this table.");
        }
    }

    static {
        asyncExecutor.allowCoreThreadTimeOut(true);
    }
}

