/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.utils;

import io.delta.kernel.Scan;
import io.delta.kernel.Snapshot;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Objects;

public class PartitionUtils {
    private PartitionUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean partitionExists(Engine engine, Snapshot snapshot, Predicate predicate) {
        Objects.requireNonNull(engine, "engine is null");
        Objects.requireNonNull(snapshot, "snapshot is null");
        Objects.requireNonNull(predicate, "partitionPredicate is null");
        HashSet<String> hashSet = new HashSet<String>(snapshot.getPartitionColumnNames());
        io.delta.kernel.internal.util.PartitionUtils.validatePredicateOnlyOnPartitionColumns(predicate, hashSet);
        Scan scan = snapshot.getScanBuilder().withFilter(predicate).build();
        try (CloseableIterator<FilteredColumnarBatch> closeableIterator = scan.getScanFiles(engine);){
            while (closeableIterator.hasNext()) {
                CloseableIterator<Row> closeableIterator2 = closeableIterator.next().getRows();
                try {
                    if (!closeableIterator2.hasNext()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (closeableIterator2 == null) continue;
                    closeableIterator2.close();
                }
            }
            return false;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

