/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.utils;

import io.delta.kernel.annotation.Evolving;
import java.util.Objects;

@Evolving
public class FileStatus {
    private final String path;
    private final long size;
    private final long modificationTime;

    public static FileStatus of(String string, long l, long l2) {
        return new FileStatus(string, l, l2);
    }

    protected FileStatus(String string, long l, long l2) {
        this.path = Objects.requireNonNull(string, "path is null");
        this.size = l;
        this.modificationTime = l2;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public String toString() {
        return String.format("FileStatus{path='%s', size=%d, modificationTime=%d}", this.path, this.size, this.modificationTime);
    }

    public static FileStatus of(String string) {
        return new FileStatus(string, 0L, 0L);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FileStatus fileStatus = (FileStatus)object;
        return Objects.equals(this.path, fileStatus.path) && Objects.equals(this.size, fileStatus.size) && Objects.equals(this.modificationTime, fileStatus.modificationTime);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.size, this.modificationTime);
    }
}

