/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.internal.util.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class IntervalParserUtils {
    private static final String INTERVAL_STR = "interval";
    private static final String YEAR_STR = "year";
    private static final String MONTH_STR = "month";
    private static final String WEEK_STR = "week";
    private static final String DAY_STR = "day";
    private static final String HOUR_STR = "hour";
    private static final String MINUTE_STR = "minute";
    private static final String SECOND_STR = "second";
    private static final String MILLIS_STR = "millisecond";
    private static final String MICROS_STR = "microsecond";

    private IntervalParserUtils() {
    }

    public static long safeParseIntervalAsMillis(String string) {
        Preconditions.checkArgument(string != null, "interval string cannot be null");
        String string2 = string.trim().toLowerCase(Locale.ROOT);
        Preconditions.checkArgument(!string2.isEmpty(), "interval string cannot be empty");
        if (!string2.startsWith("interval ")) {
            string2 = "interval " + string2;
        }
        return IntervalParserUtils.parseIntervalAsMicros(string2) / 1000L;
    }

    public static long parseIntervalAsMicros(String string) {
        return new IntervalParser(string).toMicroSeconds();
    }

    private static class IntervalParser {
        private final String input;
        private String s;
        private ParseState state = ParseState.PREFIX;
        private int i = 0;
        private long currentValue = 0L;
        private boolean isNegative = false;
        private int days = 0;
        private long microseconds = 0L;
        private int fractionScale = 0;
        private int fraction = 0;
        private boolean pointPrefixed = false;

        IntervalParser(String string) {
            String string2;
            this.input = string;
            if (string == null) {
                this.throwIAE("interval string cannot be null");
            }
            if ((string2 = string.trim().toLowerCase(Locale.ROOT)).isEmpty()) {
                this.throwIAE(String.format("Error parsing '%s' to interval", string));
            }
            this.s = string2;
        }

        long toMicroSeconds() {
            byte[] byArray = this.s.getBytes(StandardCharsets.UTF_8);
            Preconditions.checkArgument(byArray.length > 0, "Interval string cannot be empty");
            block21: while (this.i < byArray.length) {
                byte by = byArray[this.i];
                int n = 100000000;
                switch (this.state) {
                    case PREFIX: {
                        if (this.s.startsWith(IntervalParserUtils.INTERVAL_STR)) {
                            if (this.s.length() == IntervalParserUtils.INTERVAL_STR.length()) {
                                this.throwIAE("interval string cannot be empty");
                            } else if (!Character.isWhitespace(byArray[this.i + IntervalParserUtils.INTERVAL_STR.length()])) {
                                this.throwIAE("invalid interval prefix " + this.currentWord());
                            } else {
                                this.i += IntervalParserUtils.INTERVAL_STR.length();
                            }
                        }
                        this.state = ParseState.TRIM_BEFORE_SIGN;
                        continue block21;
                    }
                    case TRIM_BEFORE_SIGN: {
                        this.trimToNextState(by, ParseState.SIGN);
                        continue block21;
                    }
                    case SIGN: {
                        this.currentValue = 0L;
                        this.fraction = 0;
                        this.state = ParseState.TRIM_BEFORE_VALUE;
                        this.fractionScale = -1;
                        if (by == 45 || by == 43) {
                            ++this.i;
                            this.isNegative = by == 45;
                            continue block21;
                        }
                        if (48 <= by && by <= 57) {
                            this.isNegative = false;
                            continue block21;
                        }
                        if (by == 46) {
                            this.isNegative = false;
                            this.fractionScale = n;
                            this.pointPrefixed = true;
                            ++this.i;
                            this.state = ParseState.VALUE_FRACTIONAL_PART;
                            continue block21;
                        }
                        this.throwIAE(String.format("unrecognized number '%s'", this.currentWord()));
                        continue block21;
                    }
                    case TRIM_BEFORE_VALUE: {
                        this.trimToNextState(by, ParseState.VALUE);
                        continue block21;
                    }
                    case VALUE: {
                        if (48 <= by && by <= 57) {
                            try {
                                this.currentValue = Math.addExact(Math.multiplyExact(10L, this.currentValue), (long)(by - 48));
                            }
                            catch (ArithmeticException arithmeticException) {
                                this.throwIAE(arithmeticException.getMessage(), arithmeticException);
                            }
                        } else if (Character.isWhitespace(by)) {
                            this.state = ParseState.TRIM_BEFORE_UNIT;
                        } else if (by == 46) {
                            this.fractionScale = n;
                            this.state = ParseState.VALUE_FRACTIONAL_PART;
                        } else {
                            this.throwIAE(String.format("invalid value '%s'", this.currentWord()));
                        }
                        ++this.i;
                        continue block21;
                    }
                    case VALUE_FRACTIONAL_PART: {
                        if (48 <= by && by <= 57 && this.fractionScale > 0) {
                            this.fraction += (by - 48) * this.fractionScale;
                            this.fractionScale /= 10;
                        } else if (Character.isWhitespace(by) && (!this.pointPrefixed || this.fractionScale < n)) {
                            this.fraction /= 1000;
                            this.state = ParseState.TRIM_BEFORE_UNIT;
                        } else if (48 <= by && by <= 57) {
                            this.throwIAE(String.format("interval can only support nanosecond precision, '%s' is out of range", this.currentWord()));
                        } else {
                            this.throwIAE(String.format("invalid value '%s'", this.currentWord()));
                        }
                        ++this.i;
                        continue block21;
                    }
                    case TRIM_BEFORE_UNIT: {
                        this.trimToNextState(by, ParseState.UNIT_BEGIN);
                        continue block21;
                    }
                    case UNIT_BEGIN: {
                        if (by != 115 && this.fractionScale >= 0) {
                            this.throwIAE(String.format("'%s' cannot have fractional part", this.currentWord()));
                        }
                        if (this.isNegative) {
                            this.currentValue = -this.currentValue;
                            this.fraction = -this.fraction;
                        }
                        try {
                            if (by == 121 && this.matchAt(this.i, IntervalParserUtils.YEAR_STR)) {
                                this.throwIAE("year is not supported, use days instead");
                            } else if (by == 119 && this.matchAt(this.i, IntervalParserUtils.WEEK_STR)) {
                                long l = Math.multiplyExact(7L, this.currentValue);
                                this.days = Math.toIntExact(Math.addExact((long)this.days, l));
                                this.i += IntervalParserUtils.WEEK_STR.length();
                            } else if (by == 100 && this.matchAt(this.i, IntervalParserUtils.DAY_STR)) {
                                this.days = Math.addExact(this.days, Math.toIntExact(this.currentValue));
                                this.i += IntervalParserUtils.DAY_STR.length();
                            } else if (by == 104 && this.matchAt(this.i, IntervalParserUtils.HOUR_STR)) {
                                long l = Math.multiplyExact(this.currentValue, 3600000000L);
                                this.microseconds = Math.addExact(this.microseconds, l);
                                this.i += IntervalParserUtils.HOUR_STR.length();
                            } else if (by == 115 && this.matchAt(this.i, IntervalParserUtils.SECOND_STR)) {
                                long l = Math.multiplyExact(this.currentValue, 1000000L);
                                this.microseconds = Math.addExact(Math.addExact(this.microseconds, l), (long)this.fraction);
                                this.i += IntervalParserUtils.SECOND_STR.length();
                            } else if (by == 109) {
                                if (this.matchAt(this.i, IntervalParserUtils.MONTH_STR)) {
                                    this.throwIAE("month is not supported, use days instead");
                                } else if (this.matchAt(this.i, IntervalParserUtils.MINUTE_STR)) {
                                    long l = Math.multiplyExact(this.currentValue, 60000000L);
                                    this.microseconds = Math.addExact(this.microseconds, l);
                                    this.i += IntervalParserUtils.MINUTE_STR.length();
                                } else if (this.matchAt(this.i, IntervalParserUtils.MILLIS_STR)) {
                                    long l = Math.multiplyExact(this.currentValue, 1000L);
                                    this.microseconds = Math.addExact(this.microseconds, l);
                                    this.i += IntervalParserUtils.MILLIS_STR.length();
                                } else if (this.matchAt(this.i, IntervalParserUtils.MICROS_STR)) {
                                    this.microseconds = Math.addExact(this.microseconds, this.currentValue);
                                    this.i += IntervalParserUtils.MICROS_STR.length();
                                } else {
                                    this.throwIAE(String.format("invalid unit '%s'", this.currentWord()));
                                }
                            } else {
                                this.throwIAE(String.format("invalid unit '%s'", this.currentWord()));
                            }
                        }
                        catch (ArithmeticException arithmeticException) {
                            this.throwIAE(arithmeticException.getMessage(), arithmeticException);
                        }
                        this.state = ParseState.UNIT_SUFFIX;
                        continue block21;
                    }
                    case UNIT_SUFFIX: {
                        if (by == 115) {
                            this.state = ParseState.UNIT_END;
                        } else if (Character.isWhitespace(by)) {
                            this.state = ParseState.TRIM_BEFORE_SIGN;
                        } else {
                            this.throwIAE(String.format("invalid unit '%s'", this.currentWord()));
                        }
                        ++this.i;
                        continue block21;
                    }
                    case UNIT_END: {
                        if (Character.isWhitespace(by)) {
                            ++this.i;
                            this.state = ParseState.TRIM_BEFORE_SIGN;
                            continue block21;
                        }
                        this.throwIAE(String.format("invalid unit '%s'", this.currentWord()));
                        continue block21;
                    }
                }
                this.throwIAE("invalid input: " + this.s);
            }
            switch (this.state) {
                case TRIM_BEFORE_SIGN: 
                case UNIT_SUFFIX: 
                case UNIT_END: {
                    return (long)this.days * 86400000000L + this.microseconds;
                }
                case TRIM_BEFORE_VALUE: {
                    this.throwIAE(String.format("expect a number after '%s' but hit EOL", this.currentWord()));
                    break;
                }
                case VALUE: 
                case VALUE_FRACTIONAL_PART: {
                    this.throwIAE(String.format("expect a unit name after '%s' but hit EOL", this.currentWord()));
                    break;
                }
                default: {
                    this.throwIAE(String.format("unknown error when parsing '%s'", this.currentWord()));
                }
            }
            this.throwIAE("invalid interval");
            return 0L;
        }

        private void trimToNextState(byte by, ParseState parseState) {
            if (Character.isWhitespace(by)) {
                ++this.i;
            } else {
                this.state = parseState;
            }
        }

        private String currentWord() {
            String string = "\\s+";
            String[] stringArray = this.s.split(string);
            int n = this.s.substring(this.i).split(string).length;
            return stringArray[stringArray.length - n];
        }

        private boolean matchAt(int n, String string) {
            if (n + string.length() > this.s.length()) {
                return false;
            }
            return this.s.substring(n, n + string.length()).equals(string);
        }

        private void throwIAE(String string, Exception exception) {
            throw new IllegalArgumentException(String.format("Error parsing '%s' to interval, %s", this.input, string), exception);
        }

        private void throwIAE(String string) {
            throw new IllegalArgumentException(String.format("Error parsing '%s' to interval, %s", this.input, string));
        }
    }

    static enum ParseState {
        PREFIX,
        TRIM_BEFORE_SIGN,
        SIGN,
        TRIM_BEFORE_VALUE,
        VALUE,
        VALUE_FRACTIONAL_PART,
        TRIM_BEFORE_UNIT,
        UNIT_BEGIN,
        UNIT_SUFFIX,
        UNIT_END;

    }
}

